/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.admin.apps.console.util;

import com.tongtech.tmqi.admin.apps.console.util.LabelledComponent;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LabelValuePanel
extends JPanel {
    private int vgap = 5;
    private int hgap = 5;
    private JPanel panel;
    private LabelledComponent[] items;

    public LabelValuePanel(LabelledComponent[] items) {
        this.items = items;
        this.init();
    }

    public LabelValuePanel(LabelledComponent[] items, int hgap, int vgap) {
        this.items = items;
        this.hgap = hgap;
        this.vgap = vgap;
        this.init();
    }

    public LabelledComponent[] getLabelledComponents() {
        return this.items;
    }

    private void init() {
        int i;
        int numItems = this.items.length;
        int longest = 0;
        this.setBorder(BorderFactory.createEmptyBorder(this.vgap, this.hgap, this.vgap, this.hgap));
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        for (i = 0; i < numItems; ++i) {
            if (this.items[i].getLabelWidth() > longest) {
                longest = this.items[i].getLabelWidth();
            }
            c.gridx = 0;
            c.gridy = i;
            c.ipadx = this.hgap;
            c.ipady = this.vgap;
            c.anchor = 17;
            c.weightx = 1.0;
            c.fill = 2;
            gridbag.setConstraints(this.items[i], c);
            this.add(this.items[i]);
        }
        for (i = 0; i < this.items.length; ++i) {
            JLabel l = this.items[i].getLabel();
            Dimension dim = l.getPreferredSize();
            dim.width = longest;
            l.setPreferredSize(dim);
        }
    }
}

