/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.clusterclient;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.clusterclient.ClusterConnectionFactory;
import com.tongtech.tmqi.clusterclient.ClusterExceptionListenerAdapter;
import com.tongtech.tmqi.clusterclient.ClusterQueueSupport;
import com.tongtech.tmqi.clusterclient.ConsumerObject;
import com.tongtech.tmqi.clusterclient.ProducerThread;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import java.util.ArrayList;
import java.util.List;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;

public class ClusterConnection
implements ExceptionListener {
    Logger logger = LoggerFactory.getLogger(ClusterConnection.class);
    public static final int DISCONNECTED = 0;
    public static final int CONNECTING = 1;
    public static final int CONNECTED = 2;
    public static final int DISCONNECTING = 3;
    private Object mLock = new Object();
    private int mState = 0;
    private Connection connection;
    private List producers;
    private List consumers;
    private ClusterConnectionFactory connectionFactory;
    private ClusterQueueSupport clusterQueueSupport;
    private int num;
    private boolean isClosed;

    public ClusterConnection(ClusterConnectionFactory factory, int num) throws JMSException {
        this.connectionFactory = factory;
        this.num = num;
        this.clusterQueueSupport = factory.getClusterQueueSupport();
    }

    protected void createConnection() throws JMSException {
        this.connection = this.connectionFactory.getConnectionFactory().createConnection();
        this.connection.setExceptionListener((ExceptionListener)this);
        ClusterExceptionListenerAdapter clusterQueueExceptionListener = new ClusterExceptionListenerAdapter(this);
        this.clusterQueueSupport.setExceptionListener(this, clusterQueueExceptionListener);
        this.setState(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createProducers() throws JMSException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mState != 2) {
                return;
            }
        }
        int sessionNum = this.connectionFactory.getClusterQueueSupport().getSessionNum();
        this.producers = new ArrayList(sessionNum);
        for (int i = 0; i < sessionNum; ++i) {
            Session session = this.connection.createSession(false, 0);
            MessageProducer producer = session.createProducer((Destination)this.connectionFactory.getClusterQueueSupport().getQueue().getQueue());
            ProducerThread thread = new ProducerThread(this, producer, session, this.clusterQueueSupport);
            this.producers.add(thread);
            this.logger.trace("Add send thread: " + this.connection + " " + producer);
            this.clusterQueueSupport.addProducer(thread);
            this.clusterQueueSupport.producerSize.addAndGet(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createConsumers() throws JMSException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mState != 2) {
                return;
            }
        }
        int sessionNum = this.connectionFactory.getClusterQueueSupport().getSessionNum();
        this.consumers = new ArrayList(sessionNum);
        for (int i = 0; i < sessionNum; ++i) {
            Session session = this.connection.createSession(false, 0);
            String selector = this.connectionFactory.getClusterQueueSupport().getClusterQueueConsumer().getSelector();
            try {
                MessageConsumer realConsumer = selector != null ? session.createConsumer((Destination)this.connectionFactory.getClusterQueueSupport().getQueue().getQueue(), selector) : session.createConsumer((Destination)this.connectionFactory.getClusterQueueSupport().getQueue().getQueue());
                ConsumerObject consumer = new ConsumerObject(realConsumer, session);
                this.consumers.add(consumer);
                continue;
            }
            catch (JMSException e) {
                this.logger.trace("exception:", e);
            }
        }
    }

    protected void start() throws JMSException {
        if (this.connection != null) {
            this.connection.start();
        }
    }

    protected void stop() throws JMSException {
        if (this.connection != null) {
            this.connection.stop();
        }
    }

    public ClusterConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public ClusterQueueSupport getClusterQueueSupport() {
        return this.clusterQueueSupport;
    }

    public void setMessageListener() throws JMSException {
        if (this.consumers != null) {
            for (int i = 0; i < this.consumers.size(); ++i) {
                ConsumerObject consumer = (ConsumerObject)this.consumers.get(i);
                consumer.setMessageListener(this.connectionFactory.getClusterQueueSupport().getClusterQueueConsumer().getMessageListener());
            }
        }
    }

    protected int getNum() {
        return this.num;
    }

    public void onException(JMSException ex) {
        this.logger.debug("handleException {}", this.connection);
        this.handleException(ex);
    }

    protected void handleException(JMSException ex) {
        this.close(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                ClusterConnection.this.tryConnectUntilSuccess();
            }
        }, "Reconnect Thread").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tryConnectUntilSuccess() {
        int state;
        Object object = this.mLock;
        synchronized (object) {
            state = this.mState;
        }
        if (state == 3) {
            this.setState(1);
        }
        int[] dts = new int[]{5, 5, 5, 5, 10};
        int attempt = 0;
        int dt = dts[0];
        while (true) {
            Object object2 = this.mLock;
            synchronized (object2) {
                this.logger.trace("Status:" + this.mState + "isClosed : " + this.isClosed);
                if (this.isClosed) {
                    this.setState(0);
                    return;
                }
            }
            this.setState(1);
            this.logger.trace("after conn Status:" + this.mState);
            try {
                object2 = this.mLock;
                synchronized (object2) {
                    for (int i = 0; i < dt && !this.isClosed; ++i) {
                        this.mLock.wait(1000L);
                    }
                    this.logger.trace("Status:" + this.mState + "isClosed : " + this.isClosed);
                    if (this.isClosed) {
                        this.setState(0);
                        return;
                    }
                }
                this.createConnection();
                this.createProducersAndConsumersStartConnectionIfNeeded();
                this.setState(2);
            }
            catch (Exception e) {
                this.logger.trace("exception:", e);
                dt = attempt < dts.length ? dts[attempt] : dts[dts.length - 1];
                ++attempt;
                continue;
            }
            break;
        }
    }

    private void createProducersAndConsumersStartConnectionIfNeeded() throws JMSException {
        if (this.clusterQueueSupport.getClusterQueueProdcuer() != null) {
            this.createProducers();
        }
        if (this.clusterQueueSupport.getClusterQueueConsumer() != null) {
            this.createConsumers();
            if (this.clusterQueueSupport.isListenerSetted()) {
                this.setMessageListener();
            }
        }
        if (this.clusterQueueSupport.isConnectionStarted()) {
            this.connection.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int state) {
        Object object = this.mLock;
        synchronized (object) {
            this.mState = state;
            this.mLock.notifyAll();
        }
    }

    public List getProducers() {
        return this.producers;
    }

    public List getConsumers() {
        return this.consumers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(boolean isExited) {
        while (true) {
            Object object = this.mLock;
            synchronized (object) {
                try {
                    if (this.isClosed) {
                        return;
                    }
                    this.logger.trace("close status " + this.mState + "isClosed :" + this.isClosed);
                    if (this.mState == 0) {
                        return;
                    }
                    if (this.mState == 1) {
                        this.isClosed = true;
                        this.mLock.wait();
                    } else {
                        if (this.mState == 2) {
                            this.setState(3);
                            break;
                        }
                        if (this.mState == 3) {
                            this.mLock.wait();
                        }
                    }
                }
                catch (InterruptedException e) {
                    this.logger.trace("exception:", e);
                }
            }
        }
        if (isExited) {
            this.isClosed = true;
        }
        this.closeProducers();
        this.closeConsumers();
        this.closeConnections();
    }

    private void closeConnections() {
        try {
            this.connection.close();
        }
        catch (JMSException e) {
            this.logger.trace("exception:", e);
        }
    }

    protected void closeConsumers() {
        if (this.consumers != null) {
            for (int i = 0; i < this.consumers.size(); ++i) {
                ConsumerObject consumer = (ConsumerObject)this.consumers.get(i);
                try {
                    consumer.close();
                    continue;
                }
                catch (JMSException e) {
                    this.logger.trace("exception:", e);
                }
            }
        }
    }

    protected void closeProducers() {
        if (this.producers != null) {
            int length = this.producers.size();
            for (int i = 0; i < length; ++i) {
                ProducerThread pt = (ProducerThread)this.producers.get(i);
                this.clusterQueueSupport.removeProducer(pt);
                pt.close();
            }
        }
    }

    public String toString() {
        return ((ConnectionImpl)this.connection).getLastContactedBrokerAddress();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClusterConnection clusterConn = (ClusterConnection)obj;
        return this.num == clusterConn.getNum() && (this.connectionFactory == clusterConn.getConnectionFactory() || this.connectionFactory != null && this.connectionFactory.equals(clusterConn.getConnectionFactory())) && (this.clusterQueueSupport == clusterConn.getClusterQueueSupport() || this.clusterQueueSupport != null && this.clusterQueueSupport.equals(clusterConn.getClusterQueueSupport()));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.num + (this.connectionFactory == null ? 0 : this.connectionFactory.hashCode()) + (this.clusterQueueSupport == null ? 0 : this.clusterQueueSupport.hashCode());
        return result;
    }
}

