/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.clusterclient;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.clusterclient.ClusterQueueSupport;
import javax.jms.Message;

public class MessageRecvDispatchThread
implements Runnable {
    Logger logger = LoggerFactory.getLogger(MessageRecvDispatchThread.class);
    private ClusterQueueSupport support;
    private boolean isClosed;
    private boolean isCloseCalled;
    private Object waitLock = new Object();

    protected MessageRecvDispatchThread(ClusterQueueSupport clusterQueueSupport) {
        this.support = clusterQueueSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.isClosed) {
            try {
                Message message = (Message)this.support.recvMessagePriorityQueue.take();
                if (message == null && this.isCloseCalled || this.isClosed) {
                    Object object = this.waitLock;
                    synchronized (object) {
                        this.waitLock.notify();
                    }
                    return;
                }
                if (message == null) continue;
                this.support.getClusterQueueConsumer().getMessageListener().applicationListener.onMessage(message);
            }
            catch (InterruptedException e) {
                this.logger.trace("exception:", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitClose() throws InterruptedException {
        this.isCloseCalled = true;
        if (this.isCloseCalled || this.isClosed) {
            return;
        }
        Object object = this.waitLock;
        synchronized (object) {
            this.waitLock.wait();
        }
    }

    protected void close() {
        this.isClosed = true;
    }
}

