/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.io;

import java.text.DecimalFormat;
import java.util.Random;

public class MessageIDGenerator {
    public static final int MESSAGEID_LEN = 33;
    public static final String ENCODER_PREFIX = "__TONGTECH__";
    public static final String ENCODER_POSTFIX = "__:ID:__";
    protected String srcNode;
    protected String rgsloc;
    private String timeValue = null;
    private String msValue;
    private String seqValue;
    private int seqGenerator;
    private static final int MAXSEQ = 1000000;
    private DecimalFormat dformat = new DecimalFormat("000000");
    private String TlQcuMng;
    final int timeValueLen = 8;

    public MessageIDGenerator(String srcNode, String rgsloc, String TlQcuMng) {
        this.srcNode = MessageIDGenerator.toHexString(Integer.parseInt(srcNode));
        this.rgsloc = MessageIDGenerator.toHexString(Integer.parseInt(rgsloc)).substring(2);
        this.TlQcuMng = TlQcuMng;
        Random random = new Random();
        this.seqGenerator = random.nextInt(99999);
    }

    public synchronized String nextMessageId() {
        StringBuffer idStr = new StringBuffer("ID:");
        if (this.seqGenerator == 0 || this.timeValue == null) {
            long timestamp = System.currentTimeMillis();
            String hexTime = MessageIDGenerator.toHexString(new Long(timestamp / 10L));
            this.timeValue = hexTime.substring(hexTime.length() - 8);
            if (this.timeValue.length() != 8) {
                throw new RuntimeException("timeValue length should be 9." + timestamp + " " + this.timeValue + " " + hexTime);
            }
        }
        this.seqValue = this.dformat.format(this.seqGenerator++);
        if (this.seqGenerator == 1000000) {
            this.seqGenerator = 0;
        }
        return idStr.append(this.srcNode).append(this.TlQcuMng).append(this.rgsloc).append(this.timeValue).append(this.seqValue).toString();
    }

    public static String toHexString(long value) {
        String hexString = Long.toHexString(value);
        if (hexString.length() < 8) {
            int len = 8 - hexString.length();
            for (int i = 0; i < len; ++i) {
                hexString = "0" + hexString;
            }
        } else {
            hexString = hexString.substring(hexString.length() - 8);
        }
        return hexString;
    }

    public static void main(String[] argv) {
        System.out.println("crc:" + Integer.toHexString(Integer.MIN_VALUE));
        MessageIDGenerator msgid = new MessageIDGenerator("-369788870", "2", "a");
        for (int i = 0; i < 10; ++i) {
            System.out.println(msgid.nextMessageId());
        }
        long time = System.currentTimeMillis();
        System.out.println(time);
    }
}

