/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.io;

import com.tongtech.tmqi.io.BigPacketException;
import com.tongtech.tmqi.io.ByteBufferPool;
import com.tongtech.tmqi.io.JMQByteBufferInputStream;
import com.tongtech.tmqi.io.JMQByteBufferOutputStream;
import com.tongtech.tmqi.io.PacketPayload;
import com.tongtech.tmqi.io.PacketType;
import com.tongtech.tmqi.io.PacketVariableHeader;
import com.tongtech.tmqi.io.SysMessageID;
import com.tongtech.tmqi.jmsservice.JMSPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StreamCorruptedException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.jms.Message;

public class Packet
implements JMSPacket {
    private static boolean DEBUG = false;
    private boolean destroyed = false;
    public static final int MAGIC = 469754818;
    public static final short VERSION1 = 103;
    public static final short VERSION2 = 200;
    public static final short VERSION3 = 301;
    public static final int HEADER_SIZE = 72;
    public static final int DEFAULT_POOL_SIZE = 0x100000;
    public static final int DEFAULT_POOL_BLOCKSIZE = 128;
    protected static int sequenceNumber = 0;
    protected static ByteBufferPool bbPool = null;
    protected static long SIZE_LOWER_BOUND = 524288L;
    protected static final long SIZE_UPPER_BOUND = Integer.MAX_VALUE;
    protected static long maxPacketSize = Integer.MAX_VALUE;
    protected boolean genTimestamp = true;
    protected boolean genSequenceNumber = true;
    protected ByteBuffer fixedBuf = null;
    protected boolean bufferDirty = false;
    protected boolean useDirect = false;
    protected ByteBuffer varBuf = null;
    protected ByteBuffer propBuf = null;
    protected ByteBuffer bodyBuf = null;
    protected ByteBuffer[] writeBufs = new ByteBuffer[4];
    protected ByteBuffer[] readBufs = new ByteBuffer[4];
    protected int[] readBufsLimits = new int[4];
    protected int nBufs = 0;
    protected ArrayList allocatedBuffers = new ArrayList(8);
    protected short version = (short)301;
    protected int magic = 469754818;
    protected short packetType = 0;
    protected int packetSize = 0;
    protected long expiration = 0L;
    protected int propertyOffset = 0;
    protected int propertySize = 0;
    protected byte encryption = 0;
    protected long transactionID = 0L;
    protected byte priority = (byte)5;
    protected int bitFlags = 0;
    protected long consumerID = 0L;
    protected SysMessageID sysMessageID = new SysMessageID();
    protected PacketVariableHeader packetVariableHeader = null;
    protected PacketPayload packetPayload = null;
    protected boolean readInProgress = false;
    protected boolean writeInProgress = false;
    protected boolean versionMismatch = false;
    protected int headerBytesRead = 0;
    protected int ropBytesRead = 0;
    protected int bytesWritten = 0;

    public static synchronized long setMaxPacketSize(long n) {
        maxPacketSize = n < SIZE_LOWER_BOUND ? SIZE_LOWER_BOUND : n;
        return maxPacketSize;
    }

    public static synchronized long getMaxPacketSize() {
        return maxPacketSize;
    }

    public static void setSizeLowerBound(long n) {
        SIZE_LOWER_BOUND = n;
    }

    public static long getSizeLowerBound() {
        return SIZE_LOWER_BOUND;
    }

    public static synchronized ByteBufferPool getBufferPool() {
        return bbPool;
    }

    public Packet() {
        this(false);
    }

    public Packet(boolean useDirect) {
        this.useDirect = useDirect;
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void fill(Packet sourcePacket) throws IOException {
        this.reset();
        Packet packet = sourcePacket;
        synchronized (packet) {
            PacketPayload sourcePayload;
            sourcePacket.updateBuffers();
            ByteBuffer buf = null;
            buf = sourcePacket.getHeaderBytes();
            buf.rewind();
            this.fixedBuf.rewind();
            this.fixedBuf.put(buf);
            buf.rewind();
            this.fixedBuf.rewind();
            try {
                buf = sourcePacket.getPacketVariableHeader().getBytes();
            }
            catch (IOException e) {
                System.out.println("Could not get variable header" + e);
                return;
            }
            if (buf != null) {
                ByteBuffer newBuf = this.packetVariableHeader.getBytes();
                if (newBuf == null || newBuf.capacity() < buf.limit()) {
                    newBuf = this.allocateBuffer(buf.limit());
                } else {
                    newBuf.limit(buf.limit());
                    newBuf.rewind();
                }
                newBuf.put(buf);
                newBuf.rewind();
                buf.rewind();
                this.packetVariableHeader.setBytes(newBuf);
            }
            if ((sourcePayload = sourcePacket.getPacketPayload()) != null) {
                ByteBuffer b = sourcePayload.getPropertiesBytes(this.version);
                if (b != null) {
                    this.packetPayload.setPropertiesBytes((ByteBuffer)b.duplicate().rewind(), this.version);
                }
                if ((b = sourcePayload.getBodyBytes()) != null) {
                    this.packetPayload.setBody((ByteBuffer)b.duplicate().rewind());
                    b.rewind();
                }
            }
        }
        this.parseFixedBuffer(this.fixedBuf);
        this.getTransactionID();
        this.generateSequenceNumber(false);
        this.generateTimestamp(false);
    }

    private void parseFixedBuffer(ByteBuffer buf) throws StreamCorruptedException, IOException {
        buf.rewind();
        this.magic = buf.getInt();
        if (this.magic != 469754818) {
            throw new StreamCorruptedException("Bad packet magic number: " + this.magic + ". Expecting: " + 469754818);
        }
        this.version = buf.getShort();
        this.packetType = buf.getShort();
        this.packetSize = buf.getInt();
        if (this.version == 103) {
            this.transactionID = buf.getInt();
        }
        this.expiration = buf.getLong();
        JMQByteBufferInputStream is = new JMQByteBufferInputStream(buf);
        DataInputStream dis = new DataInputStream(is);
        this.sysMessageID.readID(dis);
        dis.close();
        ((InputStream)is).close();
        this.propertyOffset = buf.getInt();
        this.propertySize = buf.getInt();
        this.priority = buf.get();
        this.encryption = buf.get();
        this.bitFlags = buf.getShort();
        if (this.version == 103) {
            this.consumerID = buf.getInt();
            this.bitFlags &= 0xFF;
        } else {
            this.consumerID = buf.getLong();
        }
        buf.rewind();
    }

    public boolean getFlag(int flag) {
        return (this.bitFlags & flag) == flag;
    }

    public int getVersion() {
        return this.version;
    }

    public int getMagic() {
        return this.magic;
    }

    public int getPacketType() {
        return this.packetType;
    }

    public synchronized int getPacketSize() {
        try {
            this.updateBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.packetSize;
    }

    public synchronized long getTransactionID() {
        if (this.version >= 200) {
            this.transactionID = this.packetVariableHeader.getLongField(8);
        }
        return this.transactionID;
    }

    public synchronized long getProducerID() {
        return this.packetVariableHeader.getLongField(9);
    }

    public synchronized long getTimestamp() {
        return this.sysMessageID.timestamp;
    }

    public synchronized long getExpiration() {
        return this.expiration;
    }

    public int getPort() {
        return this.sysMessageID.port;
    }

    public synchronized String getIPString() {
        return this.sysMessageID.toString();
    }

    public synchronized byte[] getIP() {
        return this.sysMessageID.getIPAddress();
    }

    public int getSequence() {
        return this.sysMessageID.sequence;
    }

    public synchronized int getPropertyOffset() {
        try {
            this.updateBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.propertyOffset;
    }

    public synchronized int getPropertySize() {
        try {
            this.updateBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.propertySize;
    }

    public int getEncryption() {
        return this.encryption;
    }

    public int getPriority() {
        return this.priority;
    }

    public synchronized long getConsumerID() {
        return this.consumerID;
    }

    public boolean getPersistent() {
        return this.getFlag(4);
    }

    public boolean getRedelivered() {
        return this.getFlag(2);
    }

    public boolean getIsQueue() {
        return this.getFlag(1);
    }

    public boolean getSelectorsProcessed() {
        return this.getFlag(8);
    }

    public boolean getSendAcknowledge() {
        return this.getFlag(16);
    }

    public boolean getIsLast() {
        return this.getFlag(32);
    }

    public boolean getFlowPaused() {
        return this.getFlag(64);
    }

    public boolean getIsTransacted() {
        return this.getFlag(128);
    }

    public boolean getConsumerFlow() {
        return this.getFlag(256);
    }

    public boolean getIndempontent() {
        return this.getFlag(2048);
    }

    public boolean getWildcard() {
        return this.getFlag(4096);
    }

    public synchronized String getMessageID() {
        String messageID = this.packetVariableHeader.getStringField(2);
        if (messageID == null) {
            return this.sysMessageID.toString();
        }
        return messageID;
    }

    public synchronized SysMessageID getSysMessageID() {
        return this.sysMessageID;
    }

    public synchronized String getDestination() {
        return this.packetVariableHeader.getStringField(1);
    }

    public synchronized String getDestinationClass() {
        return this.packetVariableHeader.getStringField(6);
    }

    public synchronized String getCorrelationID() {
        return this.packetVariableHeader.getStringField(3);
    }

    public synchronized String getReplyTo() {
        return this.packetVariableHeader.getStringField(4);
    }

    public synchronized String getReplyToClass() {
        return this.packetVariableHeader.getStringField(7);
    }

    public synchronized String getMessageType() {
        return this.packetVariableHeader.getStringField(5);
    }

    public synchronized Hashtable getProperties() throws IOException, ClassNotFoundException {
        return this.packetPayload.getProperties();
    }

    public synchronized int getMessageBodySize() {
        return this.packetPayload.getBodySize();
    }

    public synchronized ByteBuffer getMessageBody() {
        return this.packetPayload.getBodyBytes();
    }

    public synchronized byte[] getMessageBodyByteArray() {
        ByteBuffer bb = this.packetPayload.getBodyBytes();
        if (bb != null && bb.hasArray()) {
            return bb.array();
        }
        return null;
    }

    public synchronized void clearMessageBody() {
        if (this.packetPayload != null) {
            this.packetPayload.setBody(null);
        }
    }

    public synchronized InputStream getMessageBodyStream() {
        return this.packetPayload.getBodyStream();
    }

    public synchronized void reset() {
        this.version = (short)301;
        this.magic = 469754818;
        this.packetType = 0;
        this.packetSize = 0;
        this.expiration = 0L;
        this.propertyOffset = 0;
        this.propertySize = 0;
        this.encryption = 0;
        this.priority = (byte)5;
        this.bitFlags = 0;
        this.consumerID = 0L;
        this.transactionID = 0L;
        this.readInProgress = false;
        this.headerBytesRead = 0;
        this.ropBytesRead = 0;
        this.bufferDirty = false;
        this.sysMessageID.clear();
        if (this.fixedBuf != null) {
            this.fixedBuf.clear();
        } else {
            this.fixedBuf = this.allocateBuffer(72);
        }
        if (this.varBuf != null) {
            this.varBuf.clear();
        }
        if (this.propBuf != null) {
            this.propBuf.clear();
        }
        if (this.bodyBuf != null) {
            this.bodyBuf.clear();
        }
        if (this.packetVariableHeader != null) {
            this.packetVariableHeader.reset();
        } else {
            this.packetVariableHeader = new PacketVariableHeader();
        }
        if (this.packetPayload != null) {
            this.packetPayload.reset();
        } else {
            this.packetPayload = new PacketPayload();
        }
    }

    private void updateBuffers() throws IOException {
        if (!this.bufferDirty) {
            return;
        }
        ByteBuffer varBytes = this.version == 103 ? this.packetVariableHeader.getBytes2() : this.packetVariableHeader.getBytes();
        ByteBuffer propBytes = this.packetPayload.getPropertiesBytes(this.version);
        ByteBuffer bodyBytes = this.packetPayload.getBodyBytes();
        this.propertySize = propBytes == null ? 0 : propBytes.limit();
        int varSize = varBytes == null ? 0 : varBytes.limit();
        int bodySize = bodyBytes == null ? 0 : bodyBytes.limit();
        this.propertyOffset = 72 + varSize;
        this.packetSize = this.propertyOffset + this.propertySize + bodySize;
        this.fixedBuf.rewind();
        this.fixedBuf.putInt(469754818);
        this.fixedBuf.putShort(this.version);
        this.fixedBuf.putShort(this.packetType);
        this.fixedBuf.putInt(this.packetSize);
        if (this.version == 103) {
            this.fixedBuf.putInt((int)this.transactionID);
        }
        this.fixedBuf.putLong(this.expiration);
        JMQByteBufferOutputStream os = new JMQByteBufferOutputStream(this.fixedBuf);
        DataOutputStream dos = new DataOutputStream(os);
        this.sysMessageID.writeID(dos);
        try {
            dos.close();
            ((OutputStream)os).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fixedBuf.putInt(this.propertyOffset);
        this.fixedBuf.putInt(this.propertySize);
        this.fixedBuf.put(this.priority);
        this.fixedBuf.put(this.encryption);
        this.fixedBuf.putShort((short)this.bitFlags);
        if (this.version == 103) {
            this.fixedBuf.putInt((int)this.consumerID);
        } else {
            this.fixedBuf.putLong(this.consumerID);
        }
        this.bufferDirty = false;
        this.fixedBuf.rewind();
    }

    public synchronized void setPacketType(int pType) {
        this.packetType = (short)pType;
        this.bufferDirty = true;
    }

    public synchronized void setTimestamp(long t) {
        this.sysMessageID.setTimestamp(t);
        this.bufferDirty = true;
    }

    public synchronized void setExpiration(long e) {
        this.expiration = e;
        this.bufferDirty = true;
    }

    public synchronized void setPort(int p) {
        this.sysMessageID.port = p;
        this.bufferDirty = true;
    }

    public synchronized void setIP(byte[] ip) {
        this.sysMessageID.setIPAddress(ip);
        this.bufferDirty = true;
    }

    public synchronized void setIP(byte[] ip, byte[] mac) {
        this.sysMessageID.setIPAddress(ip, mac);
        this.bufferDirty = true;
    }

    public synchronized void setSequence(int n) {
        this.sysMessageID.setSequence(n);
        this.bufferDirty = true;
    }

    public synchronized void setVersion(int n) {
        if (this.version != (short)n) {
            this.version = (short)n;
            if (this.version >= 200) {
                this.setTransactionID(this.transactionID);
            }
            this.bufferDirty = true;
        }
    }

    public synchronized void setTransactionID(long n) {
        this.transactionID = n;
        this.bufferDirty = true;
        if (this.version >= 200) {
            this.packetVariableHeader.setLongField(8, n);
        }
    }

    public synchronized void setProducerID(long n) {
        this.packetVariableHeader.setLongField(9, n);
        this.bufferDirty = true;
    }

    public synchronized void setEncryption(int e) {
        this.encryption = (byte)e;
        this.bufferDirty = true;
    }

    public synchronized void setPriority(int p) {
        this.priority = (byte)p;
        this.bufferDirty = true;
    }

    public synchronized void setConsumerID(long n) {
        this.consumerID = n;
        this.bufferDirty = true;
    }

    public void setPersistent(boolean b) {
        this.setFlag(4, b);
    }

    public void setRedelivered(boolean b) {
        this.setFlag(2, b);
    }

    public void setIsQueue(boolean b) {
        this.setFlag(1, b);
    }

    public void setSelectorsProcessed(boolean b) {
        this.setFlag(8, b);
    }

    public void setSendAcknowledge(boolean b) {
        this.setFlag(16, b);
    }

    public void setIsLast(boolean b) {
        this.setFlag(32, b);
    }

    public void setFlowPaused(boolean b) {
        this.setFlag(64, b);
    }

    public void setIsTransacted(boolean b) {
        this.setFlag(128, b);
    }

    public void setConsumerFlow(boolean b) {
        this.setFlag(256, b);
    }

    public void setIndempontent(boolean b) {
        this.setFlag(2048, b);
    }

    public void setWildcard(boolean b) {
        this.setFlag(4096, b);
    }

    public synchronized void setFlag(int flag, boolean on) {
        this.bitFlags = on ? (this.bitFlags |= flag) : (this.bitFlags &= ~flag);
        this.bufferDirty = true;
    }

    public synchronized void setDestination(String s) {
        this.packetVariableHeader.setStringField(1, s);
        this.bufferDirty = true;
    }

    public synchronized void setDestinationClass(String s) {
        this.packetVariableHeader.setStringField(6, s);
        this.bufferDirty = true;
    }

    public synchronized void setCorrelationID(String s) {
        this.packetVariableHeader.setStringField(3, s);
        this.bufferDirty = true;
    }

    public synchronized void setReplyTo(String s) {
        this.packetVariableHeader.setStringField(4, s);
        this.bufferDirty = true;
    }

    public synchronized void setReplyToClass(String s) {
        this.packetVariableHeader.setStringField(7, s);
        this.bufferDirty = true;
    }

    public synchronized void setMessageType(String s) {
        this.packetVariableHeader.setStringField(5, s);
        this.bufferDirty = true;
    }

    public synchronized void setProperties(Hashtable props) {
        this.packetPayload.setProperties(props);
        this.bufferDirty = true;
    }

    public synchronized void setMessageBody(ByteBuffer body) {
        this.packetPayload.setBody(body.slice());
        this.bufferDirty = true;
    }

    public synchronized void setMessageBody(byte[] body) {
        ByteBuffer buf = ByteBuffer.wrap(body);
        this.packetPayload.setBody(buf);
        this.bufferDirty = true;
    }

    public synchronized void setMessageBody(byte[] body, int off, int len) {
        ByteBuffer buf = ByteBuffer.wrap(body, off, len);
        this.packetPayload.setBody(buf);
        this.bufferDirty = true;
    }

    protected ByteBuffer getHeaderBytes() {
        return this.fixedBuf;
    }

    protected PacketPayload getPacketPayload() {
        return this.packetPayload;
    }

    protected PacketVariableHeader getPacketVariableHeader() {
        return this.packetVariableHeader;
    }

    public void generateSequenceNumber(boolean generate) {
        this.genSequenceNumber = generate;
    }

    public void generateTimestamp(boolean generate) {
        this.genTimestamp = generate;
    }

    public synchronized void updateTimestamp() {
        this.setTimestamp(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateSequenceNumber() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.setSequence(++sequenceNumber);
        }
    }

    public synchronized boolean readPacket(ScatteringByteChannel channel, boolean block) throws IOException {
        if (this.writeInProgress) {
            throw new IOException("Can't read packet. Write in progress.");
        }
        if (this.destroyed) {
            throw new IOException("Packet has been destroyed");
        }
        if (!this.readInProgress) {
            this.reset();
            this.headerBytesRead = 0;
            this.ropBytesRead = 0;
            this.readInProgress = true;
            this.versionMismatch = false;
        }
        if (this.headerBytesRead < 72 && !this.readFixedHeader(channel, block)) {
            return false;
        }
        this.fixedBuf.rewind();
        this.parseFixedBuffer(this.fixedBuf);
        if ((long)this.packetSize > maxPacketSize) {
            this.skipBytes(channel, (long)(this.packetSize - 72));
            throw new BigPacketException("Packet size (" + this.packetSize + ") is greater than the maximum allowed packet size (" + maxPacketSize + "). Disgarding packet.");
        }
        if (this.ropBytesRead == 0) {
            this.initializeReadBufs();
        }
        if (!this.readRestOfPacket(channel, block)) {
            return false;
        }
        this.packetVariableHeader.setBytes(this.varBuf);
        this.packetPayload.setPropertiesBytes(this.propBuf, this.version);
        this.packetPayload.setBody(this.bodyBuf);
        this.readInProgress = false;
        if (this.versionMismatch) {
            throw new IllegalArgumentException("Bad packet version number: " + this.version + ". Expecting: " + 103 + " or " + 200 + " or " + 301);
        }
        return true;
    }

    private long skipBytes(InputStream is, long n) throws IOException {
        long total = 0L;
        int zeroReads = 0;
        long r = 0L;
        do {
            if (zeroReads > 1000) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                zeroReads = 0;
            }
            if ((r = is.skip(n - total)) < 0L) {
                throw new EOFException();
            }
            if (r != 0L) continue;
            ++zeroReads;
        } while ((total += r) < n);
        return total;
    }

    private long skipBytes(ReadableByteChannel ch, long n) throws IOException {
        int CHUNK_SIZE = 1024;
        ByteBuffer buf = ByteBuffer.allocate(CHUNK_SIZE);
        SelectableChannel sch = null;
        Selector selector = null;
        if (ch instanceof SelectableChannel) {
            sch = (SelectableChannel)((Object)ch);
        }
        if (sch != null && !sch.isBlocking()) {
            selector = Selector.open();
            sch.register(selector, 1);
        }
        long total = 0L;
        int zeroReads = 0;
        long r = 0L;
        do {
            if (zeroReads > 1000) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                zeroReads = 0;
            }
            buf.rewind();
            r = ch.read(buf);
            if (r < 0L) {
                throw new EOFException();
            }
            if (r == 0L) {
                ++zeroReads;
                if (selector == null) continue;
                selector.select(1000L);
                continue;
            }
            total += r;
        } while (total < n);
        return total;
    }

    private boolean readFixedHeader(ScatteringByteChannel channel, boolean block) throws IOException {
        int n = 0;
        do {
            if ((n = channel.read(this.fixedBuf)) < 0) {
                throw new EOFException();
            }
            this.headerBytesRead += n;
        } while ((n > 0 || block) && this.headerBytesRead < 72);
        return this.headerBytesRead >= 72;
    }

    private void initializeReadBufs() {
        if (this.version != 103 && this.version != 200 && this.version != 301) {
            this.propertyOffset = 72;
            this.propertySize = 0;
            this.versionMismatch = true;
        }
        int size = 0;
        this.nBufs = 0;
        size = this.propertyOffset - 72;
        if (size != 0) {
            if (this.varBuf == null || this.varBuf.capacity() < size) {
                this.varBuf = this.allocateBuffer(size);
            } else {
                this.varBuf.clear();
                this.varBuf.limit(size);
            }
            this.readBufs[this.nBufs++] = this.varBuf;
        }
        if ((size = this.propertySize) > 0) {
            if (this.propBuf == null || this.propBuf.capacity() < size) {
                this.propBuf = this.allocateBuffer(size);
            } else {
                this.propBuf.clear();
                this.propBuf.limit(size);
            }
            this.readBufs[this.nBufs++] = this.propBuf;
        }
        if ((size = this.packetSize - this.propertyOffset - this.propertySize) > 0) {
            if (this.bodyBuf == null || this.bodyBuf.capacity() < size) {
                this.bodyBuf = this.allocateBuffer(size);
            } else {
                this.bodyBuf.clear();
                this.bodyBuf.limit(size);
            }
            this.readBufs[this.nBufs++] = this.bodyBuf;
        }
        for (int i = 0; i < this.readBufs.length; ++i) {
            if (this.readBufs[i] == null) continue;
            this.readBufsLimits[i] = this.readBufs[i].limit();
        }
    }

    private boolean readRestOfPacket(ScatteringByteChannel channel, boolean block) throws IOException {
        long n = 0L;
        do {
            if ((n = Packet.myChannelRead(channel, this.readBufs, 0, this.nBufs)) < 0L) {
                throw new EOFException();
            }
            this.ropBytesRead = (int)((long)this.ropBytesRead + n);
            for (int i = 0; i < this.readBufs.length; ++i) {
                if (this.readBufs[i] == null || this.readBufs[i].limit() == this.readBufsLimits[i]) continue;
                this.readBufs[i].limit(this.readBufsLimits[i]);
            }
        } while ((n > 0L || block) && this.ropBytesRead + this.headerBytesRead < this.packetSize);
        return this.headerBytesRead + this.ropBytesRead == this.packetSize;
    }

    private int initializeWriteBufs() throws IOException {
        this.nBufs = 0;
        this.fixedBuf.rewind();
        this.writeBufs[this.nBufs] = this.fixedBuf;
        ++this.nBufs;
        this.writeBufs[this.nBufs] = this.version == 103 ? this.packetVariableHeader.getBytes2() : this.packetVariableHeader.getBytes();
        if (this.writeBufs[this.nBufs] != null) {
            ++this.nBufs;
        }
        this.writeBufs[this.nBufs] = this.packetPayload.getPropertiesBytes(this.version);
        if (this.writeBufs[this.nBufs] != null) {
            ++this.nBufs;
        }
        this.writeBufs[this.nBufs] = this.packetPayload.getBodyBytes();
        if (this.writeBufs[this.nBufs] != null) {
            ++this.nBufs;
        }
        return this.nBufs;
    }

    public synchronized boolean writePacket(GatheringByteChannel channel, boolean block) throws IOException {
        if (this.readInProgress) {
            throw new IOException("Can't write packet. Read in progress.");
        }
        if (!this.writeInProgress) {
            if (this.genSequenceNumber) {
                this.updateSequenceNumber();
            }
            if (this.genTimestamp) {
                this.updateTimestamp();
            }
            this.updateBuffers();
            this.initializeWriteBufs();
            this.writeInProgress = true;
            this.bytesWritten = 0;
        }
        long n = 0L;
        do {
            n = Packet.myChannelWrite(channel, this.writeBufs, 0, this.nBufs);
            this.bytesWritten = (int)((long)this.bytesWritten + n);
        } while ((n > 0L || block) && this.bytesWritten < this.packetSize);
        if (this.bytesWritten != this.packetSize) {
            return false;
        }
        this.writeInProgress = false;
        return true;
    }

    public synchronized String toString() {
        return PacketType.getString(this.packetType) + ":" + this.sysMessageID.toString();
    }

    public synchronized String dumpPacketString(String prefix) {
        return "Packet.dumpPacketString.";
    }

    public String dumpPacketString() {
        return this.dumpPacketString(null);
    }

    public void dump(PrintStream os) {
    }

    public synchronized String headerToString() {
        return "Packet.headerToString";
    }

    public synchronized void dump(PrintStream os, String prefix) {
    }

    public synchronized void readPacket(InputStream is) throws IOException, EOFException, StreamCorruptedException, IllegalArgumentException {
        if (this.writeInProgress) {
            throw new IOException("Can't read packet. Write in progress.");
        }
        this.reset();
        this.readFully(is, this.fixedBuf, true);
        this.fixedBuf.rewind();
        this.parseFixedBuffer(this.fixedBuf);
        if ((long)this.packetSize > maxPacketSize) {
            this.skipBytes(is, (long)(this.packetSize - 72));
            throw new BigPacketException("Packet size (" + this.packetSize + ") is greater than the maximum allowed packet size (" + maxPacketSize + "). Disgarding packet.");
        }
        this.initializeReadBufs();
        for (int i = 0; i < this.nBufs; ++i) {
            this.readFully(is, this.readBufs[i], true);
        }
        this.packetVariableHeader.setBytes(this.varBuf);
        this.packetPayload.setPropertiesBytes(this.propBuf, this.version);
        this.packetPayload.setBody(this.bodyBuf);
        if (this.versionMismatch) {
            throw new IllegalArgumentException("Bad packet version number: " + this.version + ". Expecting: " + 103 + " or " + 200 + " or " + 301);
        }
    }

    private void readFully(InputStream in, ByteBuffer b, boolean retry) throws IOException, EOFException, InterruptedIOException {
        byte[] abuf = null;
        int offset = 0;
        int length = 0;
        boolean allocate = false;
        if (!b.hasArray()) {
            allocate = true;
        }
        if (!allocate) {
            try {
                abuf = b.array();
                offset = b.arrayOffset() + b.position();
                length = b.remaining();
            }
            catch (UnsupportedOperationException e) {
                allocate = true;
            }
        }
        if (allocate) {
            abuf = new byte[b.remaining()];
            allocate = true;
            offset = 0;
            length = abuf.length;
        }
        this.readFully(in, abuf, offset, length, true);
        b.rewind();
        if (allocate) {
            b.put(abuf);
        }
    }

    private void readFully(InputStream in, byte[] b, int off, int len, boolean retry) throws IOException, EOFException, InterruptedIOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = 0;
            try {
                count = in.read(b, off + n, len - n);
            }
            catch (InterruptedIOException e) {
                if (!retry && n == 0 && count == 0 && e.bytesTransferred == 0) {
                    throw new InterruptedIOException("no data available");
                }
                count = e.bytesTransferred;
                Thread.yield();
            }
            if (count >= 0) continue;
            throw new EOFException("Trying to read " + (len - n) + " bytes. Already read " + n + " bytes.");
        }
    }

    public synchronized void writePacket(OutputStream os) throws IOException {
        if (this.genSequenceNumber) {
            this.updateSequenceNumber();
        }
        if (this.genTimestamp) {
            this.updateTimestamp();
        }
        this.updateBuffers();
        this.initializeWriteBufs();
        byte[] b = null;
        int offset = 0;
        int length = 0;
        boolean allocate = false;
        for (int i = 0; i < this.nBufs; ++i) {
            if (this.writeBufs[i].isDirect()) {
                allocate = true;
            }
            if (!allocate) {
                try {
                    b = this.writeBufs[i].array();
                    offset = this.writeBufs[i].arrayOffset();
                    length = this.writeBufs[i].remaining();
                }
                catch (UnsupportedOperationException e) {
                    allocate = true;
                }
            }
            if (allocate) {
                b = new byte[this.writeBufs[i].remaining()];
                this.writeBufs[i].get(b);
                offset = 0;
                length = b.length;
            }
            os.write(b, offset, length);
        }
        os.flush();
    }

    public synchronized byte[] getBytes() throws IOException {
        if (this.genSequenceNumber) {
            this.updateSequenceNumber();
        }
        if (this.genTimestamp) {
            this.updateTimestamp();
        }
        this.updateBuffers();
        this.initializeWriteBufs();
        byte[] b = new byte[this.packetSize];
        int offset = 0;
        int length = 0;
        for (int i = 0; i < this.nBufs; ++i) {
            length = this.writeBufs[i].remaining();
            this.writeBufs[i].get(b, offset, length);
            offset += length;
        }
        return b;
    }

    public synchronized void prepareToSend() {
        this.updateSequenceNumber();
        this.updateTimestamp();
        if (this.packetVariableHeader.getStringField(2) != null) {
            this.packetVariableHeader.setStringField(2, null);
        }
    }

    private ByteBuffer allocateBuffer(int capacity) {
        ByteBuffer b = null;
        if (this.useDirect) {
            b = bbPool == null ? ByteBuffer.allocateDirect(capacity) : bbPool.get(capacity);
            this.allocatedBuffers.add(b);
        } else {
            b = ByteBuffer.allocate(capacity);
        }
        return b;
    }

    public synchronized void destroy() {
        int i;
        this.destroyed = true;
        ByteBuffer b = null;
        this.reset();
        Iterator iterator = this.allocatedBuffers.iterator();
        while (iterator.hasNext()) {
            b = (ByteBuffer)iterator.next();
            if (b.isDirect() && bbPool != null) {
                bbPool.put(b);
            }
            iterator.remove();
        }
        for (i = 0; i < this.writeBufs.length; ++i) {
            this.writeBufs[i] = null;
        }
        for (i = 0; i < this.readBufs.length; ++i) {
            this.readBufs[i] = null;
        }
        this.varBuf = null;
        this.propBuf = null;
        this.bodyBuf = null;
        this.fixedBuf = null;
        this.packetVariableHeader = null;
        this.packetPayload = null;
    }

    public static void dumpBufs(ByteBuffer[] bufs) {
        for (int i = 0; i < bufs.length; ++i) {
            System.out.println("bufs[" + i + "]=" + bufs[i]);
        }
    }

    public static long myChannelWrite(GatheringByteChannel channel, ByteBuffer[] bufs, int offset, int length) throws IOException {
        int n = 0;
        int r = 0;
        int i = offset;
        while (i < length) {
            int remains = bufs[i].remaining();
            if (remains != 0) {
                r = channel.write(bufs[i]);
                if (r < 0) {
                    return r;
                }
                if (r == 0) {
                    return n;
                }
                n += r;
                if (r != remains) continue;
                ++i;
                continue;
            }
            ++i;
        }
        return n;
    }

    public static long myChannelRead(ScatteringByteChannel channel, ByteBuffer[] bufs, int offset, int length) throws IOException {
        int n = 0;
        int r = 0;
        int i = offset;
        while (i < length) {
            int remains = bufs[i].remaining();
            if (remains != 0) {
                r = channel.read(bufs[i]);
                if (r < 0) {
                    return r;
                }
                if (r == 0) {
                    return n;
                }
                n += r;
                if (r != remains) continue;
                ++i;
                continue;
            }
            ++i;
        }
        return n;
    }

    public Message getMessage() {
        return null;
    }

    @Override
    public Packet getPacket() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<Packet> clazz = Packet.class;
        synchronized (Packet.class) {
            if (bbPool == null) {
                bbPool = new ByteBufferPool(0x100000, true);
                bbPool.setBlockSize(72);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

