/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.io;

import com.tongtech.tmqi.io.JMQByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

public class PacketVariableHeader {
    protected static CharsetDecoder decoder = null;
    protected static CharsetEncoder encoder = null;
    protected static Charset charset = null;
    protected ByteBuffer buffer = null;
    protected boolean bufferDirty = false;
    protected boolean bufferParsed = false;
    protected long transactionID = 0L;
    protected long producerID = 0L;
    protected String[] stringItems = new String[10];

    public PacketVariableHeader() {
        this.reset();
    }

    public synchronized void setBytes(ByteBuffer buf) {
        this.reset();
        if (buf == null) {
            this.buffer = null;
        } else {
            this.buffer = buf;
            this.buffer.rewind();
        }
        this.bufferParsed = false;
        this.bufferDirty = false;
    }

    public synchronized ByteBuffer getBytes() throws IOException {
        if (this.bufferDirty) {
            this.updateBuffer();
        }
        if (this.buffer == null) {
            return null;
        }
        this.buffer.rewind();
        return this.buffer;
    }

    public synchronized ByteBuffer getBytes2() throws IOException {
        if (this.bufferDirty || this.buffer == null) {
            this.updateBuffer();
        }
        return this.getBytes();
    }

    public synchronized String getStringField(int field) {
        if (!this.bufferParsed) {
            this.parseBuffer();
        }
        if (field < 10) {
            return this.stringItems[field];
        }
        return null;
    }

    public synchronized long getLongField(int field) {
        if (!this.bufferParsed) {
            this.parseBuffer();
        }
        switch (field) {
            case 8: {
                return this.transactionID;
            }
            case 9: {
                return this.producerID;
            }
        }
        return 0L;
    }

    public synchronized void setStringField(int field, String value) {
        if (!this.bufferParsed) {
            this.parseBuffer();
        }
        if (field < 10) {
            this.stringItems[field] = value;
            this.bufferDirty = true;
        }
    }

    public synchronized void setLongField(int field, long value) {
        if (!this.bufferParsed) {
            this.parseBuffer();
        }
        switch (field) {
            case 8: {
                this.transactionID = value;
                this.bufferDirty = true;
                break;
            }
            case 9: {
                this.producerID = value;
                this.bufferDirty = true;
                break;
            }
        }
    }

    protected void reset() {
        for (int n = 0; n < 10; ++n) {
            this.stringItems[n] = null;
        }
        this.transactionID = 0L;
        this.producerID = 0L;
        if (this.buffer != null) {
            this.buffer.clear();
        }
        this.bufferDirty = false;
        this.bufferParsed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parseBuffer() {
        short len = 0;
        if (this.buffer == null) {
            this.bufferParsed = true;
            return;
        }
        this.buffer.rewind();
        short type = this.buffer.getShort();
        while (type != 0) {
            switch (type) {
                case 8: {
                    len = this.buffer.getShort();
                    this.transactionID = this.buffer.getLong();
                    break;
                }
                case 9: {
                    len = this.buffer.getShort();
                    this.producerID = this.buffer.getLong();
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    len = this.buffer.getShort();
                    int currentLimit = this.buffer.limit();
                    int currentPosition = this.buffer.position();
                    this.buffer.limit(currentPosition + len);
                    try {
                        CharsetDecoder charsetDecoder = decoder;
                        synchronized (charsetDecoder) {
                            this.stringItems[type] = decoder.decode(this.buffer).toString();
                        }
                    }
                    catch (CharacterCodingException e) {
                        System.out.println("Could not decode string " + e);
                    }
                    this.buffer.limit(currentLimit);
                    break;
                }
                default: {
                    len = this.buffer.getShort();
                    this.buffer.position(this.buffer.position() + len);
                }
            }
            type = this.buffer.getShort();
        }
        this.bufferParsed = true;
    }

    private void updateBuffer() throws IOException {
        byte[] pad = new byte[4];
        byte[] buf = new byte[512];
        JMQByteArrayOutputStream bos = new JMQByteArrayOutputStream(buf);
        DataOutputStream dos = new DataOutputStream(bos);
        if (this.transactionID != 0L) {
            this.writeLong(dos, 8, this.transactionID);
        }
        if (this.producerID != 0L) {
            this.writeLong(dos, 9, this.producerID);
        }
        for (int n = 0; n < 10; ++n) {
            if (this.stringItems[n] == null) continue;
            this.writeString(dos, n, this.stringItems[n]);
        }
        dos.writeShort(0);
        dos.flush();
        int padding = 4 - bos.getCount() % 4;
        bos.write(pad, 0, padding);
        bos.flush();
        this.buffer = ByteBuffer.wrap(bos.getBuf(), 0, bos.getCount());
        this.bufferDirty = false;
        this.bufferParsed = true;
        bos.close();
        dos.close();
    }

    private void writeString(DataOutputStream dos, int type, String value) throws IOException {
        if (value != null) {
            dos.writeShort(type);
            dos.writeUTF(value);
        }
    }

    private void writeLong(DataOutputStream dos, int type, long value) throws IOException {
        dos.writeShort(type);
        dos.writeShort(8);
        dos.writeLong(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<PacketVariableHeader> clazz = PacketVariableHeader.class;
        synchronized (PacketVariableHeader.class) {
            if (charset == null) {
                try {
                    charset = Charset.forName("UTF-8");
                    decoder = charset.newDecoder();
                    encoder = charset.newEncoder();
                }
                catch (Exception e) {
                    System.err.println("Could not get charset: " + e);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

