/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.io;

import com.tongtech.tmqi.io.VRFileRAF;
import com.tongtech.tmqi.io.VRecord;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class VRecordRAF
extends VRecord {
    private static boolean DEBUG = Boolean.getBoolean("vrfile.debug");
    private VRFileRAF parent;
    private long recordStartAt;
    private int index;

    VRecordRAF(VRFileRAF p, long from, int c, short state) throws IOException {
        this(p, from, c, state, false);
        this.cookie = p.readShort(this.recordStartAt + 10L);
    }

    VRecordRAF(VRFileRAF p, long from, int c, short s, boolean dowrite) throws IOException {
        if (DEBUG) {
            System.out.println("VRecordRAF:new record: from " + from + " for " + c);
        }
        this.parent = p;
        this.recordStartAt = from;
        this.capacity = c;
        this.state = s;
        if (dowrite) {
            ByteBuffer bbuf = ByteBuffer.allocate(12);
            bbuf.putInt(this.magic);
            bbuf.putInt(this.capacity);
            bbuf.putShort(this.state);
            bbuf.putShort((short)0);
            bbuf.rewind();
            p.writeByteBuffer(this.recordStartAt, bbuf);
        }
        this.index = 12;
        if (DEBUG) {
            System.out.println("index start at " + this.index);
        }
    }

    @Override
    public void setCookie(short c) throws IOException {
        this.cookie = c;
        try {
            this.parent.writeShort(this.recordStartAt + 10L, this.cookie);
            if (this.parent.getSafe()) {
                this.force();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(this.toString() + ":setCookie()", e);
        }
    }

    @Override
    public short getCookie() {
        return this.cookie;
    }

    @Override
    public void force() throws IOException {
        if (DEBUG) {
            System.out.println("will do force on " + this.parent);
        }
        this.parent.force();
    }

    public String toString() {
        return "VRecordRAF: start=" + this.recordStartAt + "; cap=" + this.capacity + ";state=" + this.state + ";index=" + this.index;
    }

    @Override
    void free() {
        this.index = 12;
        this.state = 1;
        try {
            this.parent.writeShort(this.recordStartAt + 8L, this.state);
            this.parent.writeShort(this.recordStartAt + 10L, (short)0);
        }
        catch (IOException e) {
            throw new RuntimeException(this.toString() + ":free()", e);
        }
    }

    @Override
    void allocate(short s) {
        this.state = s;
        try {
            this.parent.writeShort(this.recordStartAt + 8L, this.state);
        }
        catch (IOException e) {
            throw new RuntimeException(this.toString() + ":allocate()", e);
        }
    }

    public void writeInt(int i, int v) throws IOException {
        if (i > this.getDataCapacity() - 4) {
            throw new IndexOutOfBoundsException(this.toString() + ": try to write integer at position " + i);
        }
        this.parent.writeInt(this.recordStartAt + 12L + (long)i, v);
    }

    public void writeInt(int v) throws IOException {
        if (this.index > this.capacity - 4) {
            throw new IndexOutOfBoundsException(this.toString() + ": try to write integer at position " + this.index);
        }
        this.parent.writeInt((long)this.index + this.recordStartAt, v);
        this.index += 4;
        if (DEBUG) {
            System.out.println("index = " + this.index + " after writeInt");
        }
    }

    public int readInt() throws IOException {
        if (this.index > this.capacity - 4) {
            throw new IndexOutOfBoundsException(this.toString() + ": try to read an integer from position " + this.index);
        }
        int v = this.parent.readInt((long)this.index + this.recordStartAt);
        this.index += 4;
        if (DEBUG) {
            System.out.println("index = " + this.index + " after readInt");
        }
        return v;
    }

    public long readLong() throws IOException {
        if (this.index > this.capacity - 8) {
            throw new IndexOutOfBoundsException(this.toString() + ": try to read a long from position " + this.index);
        }
        long v = this.parent.readLong((long)this.index + this.recordStartAt);
        this.index += 8;
        if (DEBUG) {
            System.out.println("index = " + this.index + " after readLong");
        }
        return v;
    }

    public int write(ByteBuffer buf) throws IOException {
        if (this.index > this.capacity - buf.remaining()) {
            throw new IndexOutOfBoundsException(this.toString() + ": try to write " + buf.remaining() + " bytes at position " + this.index);
        }
        int len = this.parent.writeByteBuffer((long)this.index + this.recordStartAt, buf);
        this.index += len;
        if (DEBUG) {
            System.out.println("index = " + this.index + " after write ByteBuffer");
        }
        return len;
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int offset, int len) throws IOException {
        if (this.index > this.capacity - len) {
            throw new IndexOutOfBoundsException(this.toString() + ": try to write " + len + " bytes at position " + this.index);
        }
        this.parent.write((long)this.index + this.recordStartAt, buf, offset, len);
        this.index += len;
        if (DEBUG) {
            System.out.println("index = " + this.index + " after write byte[]");
        }
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int offset, int len) throws IOException {
        if (this.index > this.capacity - len) {
            throw new IndexOutOfBoundsException(this.toString() + ": try to read " + len + "bytes from position " + this.index);
        }
        int result = this.parent.read((long)this.index + this.recordStartAt, buf, offset, len);
        this.index += result;
        if (DEBUG) {
            System.out.println("index = " + this.index + " after read byte[]");
        }
        return result;
    }

    public FileChannel getChannel() {
        return this.parent.getChannel();
    }

    public void rewind() {
        this.index = 12;
        if (DEBUG) {
            System.out.println("rewind index to " + this.index);
        }
    }

    public void position(int pos) {
        if (pos > this.getDataCapacity()) {
            throw new IndexOutOfBoundsException(this.toString() + ": try to position at position " + pos);
        }
        this.index = 12 + pos;
    }

    public int remaining() {
        return this.capacity - this.index;
    }

    public void writeLong(long v) throws IOException {
        if (this.index > this.capacity - 8) {
            throw new IndexOutOfBoundsException(this.toString() + ": try to write a long at position " + this.index);
        }
        this.parent.writeLong((long)this.index + this.recordStartAt, v);
        this.index += 8;
        if (DEBUG) {
            System.out.println("index = " + this.index + " after writeLong");
        }
    }

    public int read(ByteBuffer buf) throws IOException {
        if (this.index > this.capacity - buf.remaining()) {
            throw new IndexOutOfBoundsException(this.toString() + ": try to read " + buf.remaining() + " bytes at position " + this.index);
        }
        int len = this.parent.readByteBuffer((long)this.index + this.recordStartAt, buf);
        this.index += len;
        if (DEBUG) {
            System.out.println("index = " + this.index + " after read ByteBuffer");
        }
        return len;
    }

    public void writeShort(int i, short v) throws IOException {
        if (i > this.getDataCapacity() - 2) {
            throw new IndexOutOfBoundsException(this.toString() + ": try to write a short at position " + i);
        }
        this.parent.writeShort(this.recordStartAt + 12L + (long)i, v);
        if (DEBUG) {
            System.out.println("this writeShort does not change index");
        }
    }
}

