/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.tmqi.jmsclient.ClusterLocalXAResourceManager;
import com.tongtech.tmqi.jmsclient.ClusterMessage;
import com.tongtech.tmqi.jmsclient.ClusterXAResourceImpl;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.XASession;

public class ClusterReceiver
implements ExceptionListener {
    public static final int INIT = 0;
    public static final int CONNECTING = 1;
    public static final int CONNECTED = 2;
    public static final int FORBID = 3;
    private int id;
    private Connection conn;
    private Session sess;
    private MessageConsumer consumer;
    private int status = 0;
    private Boolean internalToggled = false;
    private MessageListener internalListener = null;
    private MessageListener externalListener = null;
    private Boolean enableLocalTran = false;
    private Boolean disableInternalListener = false;
    private ArrayBlockingQueue receiveQueue = null;
    private ArrayBlockingQueue notifyQueue = new ArrayBlockingQueue(1);
    private int weight = 1;
    private int curWeight = 0;
    private boolean xaTransactionFlag = false;
    private ClusterXAResourceImpl clusterXAResource = null;
    private boolean localXaTransactionFlag = false;
    private ClusterLocalXAResourceManager localXaManager = null;

    public ClusterReceiver(int id) {
        this.id = id;
    }

    public void setEnableLocalTran(boolean flag) {
        this.enableLocalTran = flag;
    }

    public Boolean getInternalToggled() {
        return this.internalToggled;
    }

    public Boolean isDisableInternalListener() {
        return this.disableInternalListener;
    }

    public ArrayBlockingQueue getNotifyQueue() {
        return this.notifyQueue;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Connection getConn() {
        return this.conn;
    }

    public void setConn(Connection conn) throws JMSException {
        this.conn = conn;
        this.conn.setExceptionListener((ExceptionListener)this);
        this.conn.start();
    }

    public Session getSess() {
        return this.sess;
    }

    public void setSess(Session sess) {
        this.sess = sess;
    }

    public MessageConsumer getConsumer() {
        return this.consumer;
    }

    public void setConsumer(MessageConsumer consumer) {
        this.consumer = consumer;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public synchronized void setInternalListener(ArrayBlockingQueue receiveQueue) throws JMSException {
        this.disableInternalListener = false;
        this.internalToggled = false;
        this.receiveQueue = receiveQueue;
        this.resetInternalListener();
        this.resetExternalListener();
        final ClusterReceiver receiver = this;
        if (this.consumer != null) {
            this.internalListener = new MessageListener(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void onMessage(Message paramMessage) {
                    try {
                        boolean result = false;
                        while (!receiver.isDisableInternalListener().booleanValue()) {
                            if (ClusterReceiver.this.enableLocalTran.booleanValue()) {
                                ClusterMessage msg = new ClusterMessage();
                                msg.setMsg(paramMessage);
                                msg.setReceiver(receiver);
                                result = receiver.receiveQueue.offer(msg, 1L, TimeUnit.SECONDS);
                                if (result) {
                                    if (msg.setAlarm(1)) {
                                        msg.commit();
                                        return;
                                    }
                                    Thread.currentThread();
                                    Thread.sleep(100L);
                                    continue;
                                }
                                Thread.currentThread();
                                Thread.sleep(100L);
                                continue;
                            }
                            result = receiver.receiveQueue.offer(paramMessage, 1L, TimeUnit.SECONDS);
                            if (result) return;
                            Thread.currentThread();
                            Thread.sleep(100L);
                        }
                        return;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        return;
                    }
                    catch (JMSException e) {
                        e.printStackTrace();
                    }
                }
            };
            this.consumer.setMessageListener(this.internalListener);
        }
        this.internalToggled = true;
    }

    public void resetInternalListener() throws JMSException {
        if (this.consumer != null && this.internalListener != null) {
            this.consumer.setMessageListener(null);
            this.internalListener = null;
        }
        this.internalToggled = false;
    }

    private void resetExternalListener() throws JMSException {
        this.externalListener = null;
        if (this.consumer != null && this.externalListener != null) {
            this.consumer.setMessageListener(null);
        }
    }

    public void setListener(MessageListener listener) throws JMSException {
        this.resetInternalListener();
        this.externalListener = listener;
        if (this.consumer != null) {
            this.consumer.setMessageListener(listener);
        }
    }

    public synchronized void close() {
        XASession xasess2;
        this.disableInternalListener = true;
        if (this.consumer != null) {
            try {
                this.consumer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.xaTransactionFlag) {
            try {
                if (this.clusterXAResource != null && this.sess != null) {
                    xasess2 = (XASession)this.sess;
                    this.clusterXAResource.removeXAResource(xasess2.getXAResource());
                }
            }
            catch (Exception xasess2) {
                // empty catch block
            }
        }
        if (this.localXaTransactionFlag) {
            try {
                if (this.localXaManager != null && this.sess != null) {
                    xasess2 = (XASession)this.sess;
                    this.localXaManager.removeXAResource(xasess2.getXAResource());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.sess != null) {
            try {
                this.sess.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.consumer = null;
        this.xaTransactionFlag = false;
        this.clusterXAResource = null;
        this.localXaTransactionFlag = false;
        this.localXaManager = null;
        this.sess = null;
        this.conn = null;
        this.status = 0;
    }

    public synchronized void commit() throws JMSException {
        if (this.status == 2 && this.sess != null) {
            this.sess.commit();
        }
    }

    public synchronized void rollback() throws JMSException {
        if (this.status == 2 && this.sess != null) {
            this.sess.rollback();
        }
    }

    public synchronized void closeConnection() {
        if (this.status == 2 && this.conn != null) {
            try {
                this.conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.conn = null;
        }
    }

    public void onException(JMSException paramJMSException) {
        this.close();
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public int getCurWeight() {
        return this.curWeight;
    }

    public void setCurWeight(int curWeight) {
        this.curWeight = curWeight;
    }

    public void resetCurWeight() {
        this.curWeight = 0;
    }

    public void incrCurWeight() {
        ++this.curWeight;
    }

    public Message receiveNoWait() throws JMSException {
        if (this.consumer != null) {
            return this.consumer.receiveNoWait();
        }
        return null;
    }

    public void setClusterXAResource(ClusterXAResourceImpl clusterXAResource) {
        this.clusterXAResource = clusterXAResource;
        this.xaTransactionFlag = true;
    }

    public boolean isXA() {
        return this.xaTransactionFlag;
    }

    public void setLocalXAResource(ClusterLocalXAResourceManager manager) {
        this.localXaManager = manager;
        this.localXaTransactionFlag = true;
    }

    public boolean isLocalXA() {
        return this.localXaTransactionFlag;
    }
}

