/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.tmqi.jmsclient.ClusterLocalXAResourceManager;
import com.tongtech.tmqi.jmsclient.ClusterXAResourceImpl;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.XASession;

public class ClusterSender {
    public static final int INIT = 0;
    public static final int CONNECTING = 1;
    public static final int CONNECTED = 2;
    public static final int FORBID = 3;
    private int id;
    private Connection conn;
    private Session sess;
    private MessageProducer producer;
    private int weight;
    private int curWeight = 0;
    private int status = 0;
    private boolean xaTransactionFlag = false;
    private ClusterXAResourceImpl clusterXAResource = null;
    private boolean localXaTransactionFlag = false;
    private ClusterLocalXAResourceManager localXaManager = null;

    public ClusterSender(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Connection getConn() {
        return this.conn;
    }

    public void setConn(Connection conn) {
        this.conn = conn;
    }

    public Session getSess() {
        return this.sess;
    }

    public void setSess(Session sess) {
        this.sess = sess;
    }

    public MessageProducer getProducer() {
        return this.producer;
    }

    public void setProducer(MessageProducer producer) {
        this.producer = producer;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public int getCurWeight() {
        return this.curWeight;
    }

    public void setCurWeight(int curWeight) {
        this.curWeight = curWeight;
    }

    public void resetCurWeight() {
        this.curWeight = 0;
    }

    public void incrCurWeight() {
        ++this.curWeight;
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.producer.setDeliveryMode(deliveryMode);
    }

    public void setPriority(int priority) throws JMSException {
        this.producer.setPriority(priority);
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.producer.setTimeToLive(timeToLive);
    }

    public synchronized void close() {
        XASession xasess2;
        if (this.producer != null) {
            try {
                this.producer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.xaTransactionFlag) {
            try {
                if (this.clusterXAResource != null && this.sess != null) {
                    xasess2 = (XASession)this.sess;
                    this.clusterXAResource.removeXAResource(xasess2.getXAResource());
                }
            }
            catch (Exception xasess2) {
                // empty catch block
            }
        }
        if (this.localXaTransactionFlag) {
            try {
                if (this.localXaManager != null && this.sess != null) {
                    xasess2 = (XASession)this.sess;
                    this.localXaManager.removeXAResource(xasess2.getXAResource());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.sess != null) {
            try {
                this.sess.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.xaTransactionFlag = false;
        this.clusterXAResource = null;
        this.localXaTransactionFlag = false;
        this.localXaManager = null;
        this.producer = null;
        this.sess = null;
        this.conn = null;
        this.status = 0;
    }

    public void setClusterXAResource(ClusterXAResourceImpl clusterXAResource) {
        this.clusterXAResource = clusterXAResource;
        this.xaTransactionFlag = true;
    }

    public boolean isXA() {
        return this.xaTransactionFlag;
    }

    public void setLocalXAResource(ClusterLocalXAResourceManager manager) {
        this.localXaManager = manager;
        this.localXaTransactionFlag = true;
    }

    public boolean isLocalXA() {
        return this.localXaTransactionFlag;
    }
}

