/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.tmqi.AdministeredObject;
import com.tongtech.tmqi.jmsclient.ConnectionConsumerReader;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.Consumer;
import com.tongtech.tmqi.jmsclient.MessageImpl;
import com.tongtech.tmqi.jmsclient.SessionImpl;
import com.tongtech.tmqi.jmsclient.SessionQueue;
import com.tongtech.tmqi.jmsclient.Traceable;
import com.tongtech.tmqi.jmsspi.ServerSession;
import java.io.PrintStream;
import java.util.Hashtable;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;

public class ConnectionConsumerImpl
extends Consumer
implements ConnectionConsumer,
Traceable {
    protected ServerSessionPool serverSessionPool;
    protected int maxMessages;
    private SessionQueue readQueue = null;
    private ConnectionConsumerReader reader = null;
    private Long readQueueId = null;
    private javax.jms.ServerSession serverSession = null;
    public SessionImpl session = null;
    public SessionImpl sessionS = null;

    public ConnectionConsumerImpl(ConnectionImpl connection, Destination d, String messageSelector, ServerSessionPool sessionPool, int maxMessages, String durablename) throws JMSException {
        super(connection, d, messageSelector, false);
        if (durablename != null) {
            if (connection.clientID == null) {
                String errorString = AdministeredObject.cr.getKString("C4053", "\"\"");
                throw new JMSException(errorString, "C4053");
            }
            this.setDurable(true);
            this.setDurableName(durablename);
        }
        this.serverSessionPool = sessionPool;
        this.maxMessages = maxMessages;
        this.init();
    }

    public void init() throws JMSException {
        this.readQueue = new SessionQueue();
        if (this.connection.getIsStopped()) {
            this.readQueue.setIsLocked(true);
        }
        this.readQueueId = this.connection.getNextSessionId();
        this.connection.addToReadQTable(this.readQueueId, this.readQueue);
        this.reader = new ConnectionConsumerReader(this);
        this.reader.start();
        this.sessionS = new SessionImpl(this.connection, false, 1);
        this.addInterest();
    }

    private void addInterest() throws JMSException {
        this.connection.addConnectionConsumer(this);
        this.registerInterest();
    }

    private void removeInterest() throws JMSException {
        this.connection.removeConnectionConsumer(this);
        this.deregisterInterest();
    }

    @Override
    public Long getReadQueueId() {
        return this.readQueueId;
    }

    protected SessionQueue getReadQueue() {
        return this.readQueue;
    }

    @Override
    protected void onMessage(MessageImpl message) throws JMSException {
        if (this.session == null) {
            this.serverSession = this.serverSessionPool.getServerSession();
            try {
                this.session = (SessionImpl)this.serverSession.getSession();
                if (this.session.getConnection() != this.connection) {
                    String errorString = AdministeredObject.cr.getKString("C4029");
                    throw new JMSException(errorString, "C4029");
                }
                if (this.session.getMessageListener() == null) {
                    String errorString = AdministeredObject.cr.getKString("C4029");
                    throw new IllegalStateException(errorString, "C4029");
                }
            }
            catch (JMSException e) {
                if (this.session != null && this.serverSession instanceof ServerSession) {
                    ((ServerSession)this.serverSession).destroy();
                }
                this.session = null;
                this.serverSession = null;
                throw e;
            }
        }
        message.setSession(this.session);
        this.session.loadMessageToServerSession(message, this.serverSession);
    }

    protected void startServerSession() throws JMSException {
        if (this.serverSession != null) {
            this.serverSession.start();
            this.serverSession = null;
            this.session = null;
        }
    }

    protected int getMaxMessages() {
        return this.maxMessages;
    }

    public ServerSessionPool getServerSessionPool() throws JMSException {
        return this.serverSessionPool;
    }

    public void close() throws JMSException {
        this.reader.close();
        this.removeInterest();
        this.connection.removeFromReadQTable(this.readQueueId);
        this.isClosed = true;
    }

    protected void stop() {
        this.readQueue.stop(false);
    }

    protected void start() {
        this.readQueue.start();
    }

    @Override
    public void dump(PrintStream ps) {
    }

    @Override
    protected Hashtable getDebugState(boolean verbose) {
        Hashtable ht = super.getDebugState(verbose);
        ht.put("maxMessages", String.valueOf(this.maxMessages));
        return ht;
    }

    @Override
    public SessionImpl getSession() throws JMSException {
        return this.sessionS;
    }

    public void unregisteredXAResource() {
    }
}

