/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.backport.java.util.concurrent.ArrayBlockingQueue;
import com.tongtech.backport.java.util.concurrent.BlockingQueue;
import com.tongtech.jms.Connection;
import com.tongtech.jms.notification.EventListener;
import com.tongtech.jms.util.InjectorUtil;
import com.tongtech.log.JDKLogger;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.AdministeredObject;
import com.tongtech.tmqi.Version;
import com.tongtech.tmqi.io.PacketType;
import com.tongtech.tmqi.io.ReadWritePacket;
import com.tongtech.tmqi.jmsclient.ConnectionConsumerImpl;
import com.tongtech.tmqi.jmsclient.ConnectionInitiator;
import com.tongtech.tmqi.jmsclient.ConnectionMetaDataImpl;
import com.tongtech.tmqi.jmsclient.ConnectionResult;
import com.tongtech.tmqi.jmsclient.Consumer;
import com.tongtech.tmqi.jmsclient.ExceptionHandler;
import com.tongtech.tmqi.jmsclient.FlowControl;
import com.tongtech.tmqi.jmsclient.InterestTable;
import com.tongtech.tmqi.jmsclient.MessageConsumerImpl;
import com.tongtech.tmqi.jmsclient.MessageProducerImpl;
import com.tongtech.tmqi.jmsclient.ProtocolHandler;
import com.tongtech.tmqi.jmsclient.QueueSessionImpl;
import com.tongtech.tmqi.jmsclient.ReadQTable;
import com.tongtech.tmqi.jmsclient.SessionImpl;
import com.tongtech.tmqi.jmsclient.SessionQueue;
import com.tongtech.tmqi.jmsclient.TemporaryDestination;
import com.tongtech.tmqi.jmsclient.TopicSessionImpl;
import com.tongtech.tmqi.jmsclient.Traceable;
import com.tongtech.tmqi.jmsclient.UnifiedReadChannel;
import com.tongtech.tmqi.jmsclient.UnifiedSessionImpl;
import com.tongtech.tmqi.jmsclient.WriteChannel;
import com.tongtech.tmqi.jmsclient.XASessionImpl;
import com.tongtech.tmqi.jmsclient.notification.EventHandler;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSession;
import javax.jms.XASession;

public class ConnectionImpl
implements Connection,
Traceable {
    private static final String ENABLE_FAILOVER_PROP = "tmqi.enable_failover";
    Logger logger = LoggerFactory.getLogger(ConnectionImpl.class);
    public static final Version version = new Version();
    private boolean daemonThreads = false;
    private boolean hasNamespace = false;
    private String raNamespaceUID = null;
    private Object nsSyncObj = new Object();
    public ExceptionListener exceptionListener = null;
    public String clientID = null;
    protected String clientIPAddress = null;
    public UnifiedReadChannel readChannel = null;
    public WriteChannel writeChannel = null;
    protected ProtocolHandler protocolHandler = null;
    public FlowControl flowControl = null;
    public ConnectionInitiator initiator = null;
    public boolean reconnecting = false;
    private Object reconnectSyncObj = new Object();
    protected Hashtable producers = new Hashtable();
    public ExceptionHandler exceptionHandler = null;
    public InterestTable interestTable = null;
    public ReadQTable readQTable = null;
    public ReadQTable ackQTable = null;
    public Hashtable requestMetaData = null;
    protected boolean isTopicConnection = false;
    protected boolean isQueueConnection = false;
    protected boolean isStopped = true;
    public boolean isClosed = true;
    public boolean isCloseCalled = false;
    protected boolean isSuspended = false;
    protected Vector sessionTable = null;
    protected Vector connectionConsumerTable = null;
    protected Vector tempDestTable = null;
    protected long nextSessionId = 0L;
    protected boolean sessionIdReset = false;
    protected int nextTransactionID = 0;
    protected boolean openedFromXA = false;
    public boolean protectMode = false;
    public int flowControlMsgSize = 100;
    public int flowControlWaterMark = 1000;
    public int prefetchMaxMsgCount = 100;
    public int prefetchThresholdPercent = 50;
    public volatile boolean tmqiReconnect = false;
    protected boolean failoverEnabled = false;
    protected Hashtable licenseProps = null;
    public boolean tmqiEnableSharedClientID = false;
    public boolean tmqiEnableSharedSubscriptions = false;
    protected int dupsOkLimit = 10;
    protected boolean isAckLimited = false;
    protected int ackLimit = 100;
    private int tempDestSequence = 0;
    private int tempDestCounter = 0;
    public volatile boolean connectionIsBroken = false;
    public volatile boolean recoverInProcess = false;
    protected static long nextConnectionID = 0L;
    public String connectionID = null;
    public String localIP = null;
    public int localPort = 0;
    protected long localID = 0L;
    protected boolean jmqOverrideJMSMsgHeaders = false;
    protected boolean jmqOverrideJMSDeliveryMode = false;
    protected boolean jmqOverrideJMSExpiration = false;
    protected boolean jmqOverrideJMSPriority = false;
    protected boolean jmqOverrideMsgsToTempDests = false;
    protected int jmqJMSDeliveryMode = 2;
    protected long jmqJMSExpiration = 0L;
    protected int jmqJMSPriority = 4;
    protected boolean dupsOkAckOnEmptyQueue = false;
    protected long dupsOkAckTimeout = 7000L;
    protected boolean allowToSetClientID = true;
    protected boolean adminSetClientID = false;
    private Object syncObj = new Object();
    private transient String userName = null;
    private transient String password = null;
    private String ackOnProduce = null;
    private String ackOnAcknowledge = null;
    private String connectionType = "NORMAL";
    private boolean adminKeyUsed = false;
    public ConnectionMetaDataImpl connectionMetaData = null;
    Properties configuration = null;
    private boolean isDedicatedToConnectionConsumer = true;
    private volatile boolean negotiateProtocolLevel = false;
    private int brokerProtocolLevel = 0;
    private String brokerVersion = "Unknown";
    private long tmqiPingInterval = 30000L;
    private static long WAIT_TIME_OUT = 30000L;
    protected EventListener eventListener = null;
    protected EventHandler eventHandler = null;
    protected volatile boolean isConnectedToHABroker = false;
    public String JMQClusterID = null;
    public Long JMQStoreSession = null;
    public String JMQBrokerList = null;
    public String savedJMQBrokerList = null;
    public String JMQStoreOwner = null;
    protected String lastContactedBrokerAddress = null;
    private boolean extendedEventNotification = false;
    public static final String ROOT_LOGGER_NAME = "javax.jms";
    public static final String CONNECTION_LOGGER_NAME = "javax.jms.connection";
    public static final JDKLogger connectionLogger = JDKLogger.getLogger("javax.jms.connection", "com.tongtech.tmqi.jmsclient.resources.ClientResources");
    private static boolean isHADisabled = Boolean.getBoolean("tmqi.ha.disabled");
    public static final long CONNECTION_TIMEOUT_IN_SECONDS = 60L;
    protected BlockingQueue ackQueue = new ArrayBlockingQueue(1);
    public static final int GOODBYE_OK = 0;
    private int protocolType = 1;
    static char XOR_KEY = (char)65413;
    private volatile boolean disableReopenFromRA = false;

    private static String EnCryptData(String buf) {
        int i = 0;
        if (buf == null || buf.length() == 0) {
            return null;
        }
        char[] inbuf = buf.toCharArray();
        for (i = 0; i < buf.length(); ++i) {
            inbuf[i] = (char)(inbuf[i] ^ XOR_KEY);
            inbuf[i] = ~inbuf[i];
        }
        return new String(inbuf);
    }

    private static String BufferToHexStr(String inbuf) {
        char[] buffer = inbuf.toCharArray();
        char[] hexStr = new char[buffer.length * 2];
        int j = 0;
        for (int i = 0; i < buffer.length; ++i) {
            char temp = buffer[i] / 16 <= 9 ? (char)(48 + buffer[i] / 16) : (char)(65 + buffer[i] / 16 - 10);
            hexStr[j++] = temp;
            temp = buffer[i] % 16 <= 9 ? (char)(48 + buffer[i] % 16) : (char)(65 + buffer[i] % 16 - 10);
            hexStr[j++] = temp;
        }
        return new String(hexStr);
    }

    private static String EnCryptDataAndToHexString(String buf) {
        boolean ret = false;
        if (buf.length() == 0) {
            return buf;
        }
        String enBuf = ConnectionImpl.EnCryptData(buf);
        if (enBuf == null) {
            return null;
        }
        String hexBuf = ConnectionImpl.BufferToHexStr(enBuf);
        return hexBuf;
    }

    public void setProtocolType(int type) {
        this.protocolType = type;
    }

    public int getProtocolType() {
        return this.protocolType;
    }

    public void sayGoodbye(Integer i) {
        try {
            this.ackQueue.put(i);
        }
        catch (InterruptedException ex) {
            this.logger.warn("", ex);
        }
    }

    public boolean isHAEnabled() {
        return !isHADisabled;
    }

    public ConnectionImpl(Properties configuration, String userName, String password, String type) throws JMSException {
        this.configuration = configuration;
        this.userName = userName;
        this.password = ConnectionImpl.EnCryptDataAndToHexString(password);
        if ("ADMINKEY".equals(type)) {
            this.connectionType = "ADMIN";
            this.adminKeyUsed = true;
        } else if (type != null) {
            this.connectionType = type;
        }
        this.connectionID = String.valueOf(ConnectionImpl.getNextConnectionID());
        this.localID = Long.parseLong(this.connectionID);
        this.init();
        this.logLifeCycle("I100");
    }

    public long getLocalID() {
        return this.localID;
    }

    public String getBrokerVersion() {
        return this.brokerVersion;
    }

    public void setBrokerVersion(String brokerVersion) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("setBrokerVersion : {}", (Object)brokerVersion);
        }
        this.brokerVersion = brokerVersion;
    }

    public long generateUID() throws JMSException {
        return this.protocolHandler.generateUID();
    }

    public int getBrokerProtocolLevel() {
        return this.brokerProtocolLevel;
    }

    public void setBrokerProtocolLevel(int brokerProtocolLevel) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("setBrokerProtocolLevel : {}", brokerProtocolLevel);
        }
        this.brokerProtocolLevel = brokerProtocolLevel;
    }

    public boolean checkBrokerProtocolLevel() throws JMSException {
        return this.brokerProtocolLevel >= 200;
    }

    public static void checkHostPort(String host, int port) throws JMSException {
        if (port <= 0) {
            String errorString0 = "[" + host + "," + port + "]";
            String errorString = AdministeredObject.cr.getKString("C4090", errorString0);
            JMSException jmse = new JMSException(errorString, "C4090");
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    public boolean getNegotiateProtocolLevel() {
        return this.negotiateProtocolLevel;
    }

    public void setNegotiateProtocolLevel(boolean negotiateProtocolLevel) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("setNegotiateProtocolLevel : {}", negotiateProtocolLevel);
        }
        this.negotiateProtocolLevel = negotiateProtocolLevel;
    }

    protected void updateLicenseProps() throws JMSException {
        this.licenseProps = null;
        this.failoverEnabled = false;
        if (this.getBrokerProtocolLevel() > 350) {
            this.licenseProps = this.protocolHandler.getLicense();
        }
        if (this.licenseProps != null) {
            String fo = (String)this.licenseProps.get(ENABLE_FAILOVER_PROP);
            if (fo != null && "true".equalsIgnoreCase(fo)) {
                this.failoverEnabled = true;
            }
            this.checkLicense();
        }
    }

    protected void hello() throws JMSException {
        this.protocolHandler.hello(this.userName, this.password);
        this.updateLicenseProps();
    }

    protected void hello(boolean reconnect) throws JMSException {
        this.protocolHandler.hello(this.userName, this.password, this.connectionID);
        this.updateLicenseProps();
    }

    private void checkLicense() throws JMSException {
        if (this.tmqiReconnect && !this.failoverEnabled && this.initiator.getAddrListSize() > 1) {
            String bname = this.protocolHandler.getConnectionHandler().getBrokerHostName();
            String errorString = AdministeredObject.cr.getKString("C4097", bname);
            JMSException jmse = new JMSException(errorString, "C4097");
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    protected boolean waitForReconnecting(Exception e) {
        boolean isReconnected = false;
        if (!this.tmqiReconnect) {
            return false;
        }
        if (!(e instanceof JMSException)) {
            return false;
        }
        JMSException jmse = (JMSException)((Object)e);
        String ecode = jmse.getErrorCode();
        if ("C4001".equals(ecode) || "C4000".equals(ecode)) {
            SessionImpl.yield();
            try {
                this.checkReconnecting(null);
                isReconnected = !this.isCloseCalled && !this.connectionIsBroken;
            }
            catch (Exception e2) {
                isReconnected = false;
            }
        }
        return isReconnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkReconnecting(ReadWritePacket pkt) throws JMSException {
        Object object = this.reconnectSyncObj;
        synchronized (object) {
            while (this.reconnecting) {
                try {
                    this.reconnectSyncObj.wait(WAIT_TIME_OUT);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!this.connectionIsBroken && !this.isCloseCalled) continue;
                return;
            }
        }
        if (pkt != null) {
            this.checkPacketType(pkt);
        }
    }

    private void checkPacketType(ReadWritePacket pkt) throws JMSException {
        boolean isAllowed = this.isAllowedToFailover(pkt);
        if (!isAllowed) {
            String msg = AdministeredObject.cr.getKString("C4001") + ", packet type = " + PacketType.getString(pkt.getPacketType());
            com.tongtech.jms.JMSException jmse = new com.tongtech.jms.JMSException(msg, "C4001");
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    private boolean isAllowedToFailover(ReadWritePacket pkt) {
        long tid;
        Object sid;
        Hashtable ht = null;
        try {
            ht = pkt.getProperties();
        }
        catch (Exception e) {
            connectionLogger.log(Level.WARNING, "C4005", e);
            return false;
        }
        if (ht != null && (sid = ht.get("JMQSessionID")) != null) {
            return false;
        }
        int packetType = pkt.getPacketType();
        if (packetType == 24 || packetType == 14 || packetType == 18 || packetType == 12 || packetType == 34 || packetType == 68 || packetType == 16 || packetType == 66 || packetType == 36 || packetType == 70 || packetType == 56 || packetType == 50 || packetType == 44 || packetType == 48) {
            return false;
        }
        return packetType != 6 && packetType != 2 && packetType != 3 && packetType != 1 && packetType != 5 && packetType != 4 || (tid = pkt.getTransactionID()) <= 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getReconnecting() {
        Object object = this.reconnectSyncObj;
        synchronized (object) {
            return this.reconnecting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReconnecting(boolean reconnecting) {
        Object object = this.reconnectSyncObj;
        synchronized (object) {
            this.reconnecting = reconnecting;
            this.reconnectSyncObj.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkAndSetReconnecting() throws JMSException {
        Object object = this.reconnectSyncObj;
        synchronized (object) {
            if (!(this.reconnecting || this.connectionIsBroken || this.isCloseCalled)) {
                this.setReconnecting(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean useNamespace() {
        Object object = this.nsSyncObj;
        synchronized (object) {
            return this.hasNamespace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setRANamespaceUID(String raNamespaceUID) {
        Object object = this.nsSyncObj;
        synchronized (object) {
            this.tmqiEnableSharedClientID = true;
            this.tmqiEnableSharedSubscriptions = true;
            this.raNamespaceUID = raNamespaceUID;
            this.hasNamespace = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRANamespaceUID() {
        Object object = this.nsSyncObj;
        synchronized (object) {
            return this.raNamespaceUID;
        }
    }

    private void init() throws JMSException {
        block31: {
            try {
                String pInterval;
                String dedicateToCC;
                String isLimited;
                String ackCount;
                this.exceptionHandler = new ExceptionHandler();
                this.interestTable = new InterestTable();
                this.readQTable = new ReadQTable();
                this.ackQTable = new ReadQTable();
                this.requestMetaData = new Hashtable();
                this.sessionTable = new Vector();
                this.connectionConsumerTable = new Vector();
                this.tempDestTable = new Vector();
                String prop = null;
                int propval = 0;
                long lpropval = 0L;
                InjectorUtil.init();
                String cid = this.getTrimmedProperty("tmqiConfiguredClientID");
                if (cid != null) {
                    this.clientID = cid;
                    this.adminSetClientID = true;
                }
                if (Boolean.valueOf(prop = this.getProperty("tmqi.DaemonThreads", "false")).booleanValue()) {
                    this.daemonThreads = true;
                }
                if (Boolean.valueOf(prop = this.getProperty("tmqi.disableReopenFramRA", "false")).booleanValue()) {
                    this.disableReopenFromRA = true;
                }
                if (Boolean.valueOf(prop = this.getTrimmedProperty("tmqiOverrideJMSDeliveryMode")).booleanValue()) {
                    prop = this.getTrimmedProperty("tmqiJMSDeliveryMode");
                    if ("PERSISTENT".equals(prop)) {
                        this.jmqJMSDeliveryMode = 2;
                        this.jmqOverrideJMSDeliveryMode = true;
                    }
                    if ("NON_PERSISTENT".equals(prop)) {
                        this.jmqJMSDeliveryMode = 1;
                        this.jmqOverrideJMSDeliveryMode = true;
                    }
                }
                if (Boolean.valueOf(prop = this.getTrimmedProperty("tmqiOverrideJMSExpiration")).booleanValue() && (lpropval = Long.parseLong(prop = this.getTrimmedProperty("tmqiJMSExpiration"))) >= 0L) {
                    this.jmqJMSExpiration = lpropval;
                    this.jmqOverrideJMSExpiration = true;
                }
                if (Boolean.valueOf(prop = this.getTrimmedProperty("tmqiOverrideJMSPriority")).booleanValue() && (propval = Integer.parseInt(prop = this.getTrimmedProperty("tmqiJMSPriority"))) >= 0 && propval <= 9) {
                    this.jmqJMSPriority = propval;
                    this.jmqOverrideJMSPriority = true;
                }
                if (this.jmqOverrideJMSDeliveryMode || this.jmqOverrideJMSExpiration || this.jmqOverrideJMSPriority) {
                    this.jmqOverrideJMSMsgHeaders = true;
                }
                prop = this.getTrimmedProperty("tmqiOverrideJMSHeadersToTemporaryDestinations");
                this.jmqOverrideMsgsToTempDests = Boolean.valueOf(prop);
                String disableSetID = this.getProperty("tmqiDisableSetClientID");
                if (Boolean.valueOf(disableSetID).booleanValue()) {
                    this.setClientIDFlag();
                }
                if (Boolean.valueOf(prop = this.getProperty("tmqiConnectionFlowLimitEnabled")).booleanValue()) {
                    this.protectMode = true;
                }
                if ((prop = this.getTrimmedProperty("tmqiConnectionFlowLimit")) != null) {
                    this.flowControlWaterMark = Integer.parseInt(prop);
                }
                if ((prop = this.getTrimmedProperty("tmqiConnectionFlowCount")) != null) {
                    this.flowControlMsgSize = Integer.parseInt(prop);
                }
                if ((prop = this.getTrimmedProperty("tmqiConsumerFlowLimit")) != null) {
                    this.prefetchMaxMsgCount = Integer.parseInt(prop);
                }
                if ((prop = this.getTrimmedProperty("tmqiConsumerFlowThreshold")) != null) {
                    this.prefetchThresholdPercent = Integer.parseInt(prop);
                }
                if ((prop = this.getTrimmedProperty("tmqiReconnectEnabled")) != null) {
                    this.tmqiReconnect = Boolean.valueOf(prop);
                }
                if ((prop = this.getTrimmedProperty("tmqiEnableSharedClientID")) != null) {
                    this.tmqiEnableSharedClientID = Boolean.valueOf(prop);
                }
                this.ackOnProduce = this.getTrimmedProperty("tmqiAckOnProduce");
                this.ackOnAcknowledge = this.getTrimmedProperty("tmqiAckOnAcknowledge");
                String dupsOk = System.getProperty("tmqiDupsOkLimit");
                if (dupsOk != null) {
                    this.dupsOkLimit = Integer.parseInt(dupsOk);
                }
                if ((prop = System.getProperty("tmqiDupsOkAckTimeout")) != null) {
                    this.dupsOkAckTimeout = Integer.parseInt(prop);
                }
                if ((prop = System.getProperty("tmqiDupsOkAckOnEmptyQueue")) != null) {
                    this.dupsOkAckOnEmptyQueue = Boolean.valueOf(prop);
                }
                if ((ackCount = System.getProperty("tmqiAckLimit")) != null) {
                    this.ackLimit = Integer.parseInt(ackCount);
                }
                if ((isLimited = System.getProperty("tmqiAckIsLimited")) != null && isLimited.equals("true")) {
                    this.isAckLimited = true;
                }
                if ((dedicateToCC = System.getProperty("tmqi.dedicateToConnectionConsumer")) != null && dedicateToCC.equals("false")) {
                    this.isDedicatedToConnectionConsumer = false;
                }
                if ((pInterval = this.getTrimmedProperty("tmqiPingInterval")) != null) {
                    int tmp = Integer.parseInt(pInterval);
                    this.tmqiPingInterval = tmp <= 0 ? 0L : (long)(tmp * 1000);
                }
                this.initiator = new ConnectionInitiator(this);
                this.setBrokerProtocolLevel(PacketType.getProtocolVersion());
                try {
                    this.openConnection(false);
                }
                catch (Exception e) {
                    if (this.negotiateProtocolLevel) {
                        this.openConnection(false);
                        break block31;
                    }
                    if (e instanceof JMSException) {
                        throw e;
                    }
                    ExceptionHandler.handleException(e, "C4038", true);
                }
            }
            catch (JMSException jmse) {
                throw jmse;
            }
            catch (Exception e) {
                ExceptionHandler.handleException(e, "C4038", true);
            }
        }
    }

    private static synchronized long getNextConnectionID() {
        return nextConnectionID++;
    }

    protected String getConnectionID() {
        return this.connectionID;
    }

    public String _getConnectionID() {
        return this.connectionID;
    }

    public void setConnectionID(String id) {
        this.connectionID = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getTempDestSequence() {
        Object object = this.syncObj;
        synchronized (object) {
            ++this.tempDestCounter;
            return ++this.tempDestSequence;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decreaseTempDestCounter() {
        Object object = this.syncObj;
        synchronized (object) {
            --this.tempDestCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getTempDestCounter() {
        Object object = this.syncObj;
        synchronized (object) {
            return this.tempDestCounter;
        }
    }

    protected void setProtectMode(boolean mode) {
        this.protectMode = mode;
    }

    public boolean getProtectMode() {
        return this.protectMode;
    }

    protected int getDupsOkLimit() {
        return this.dupsOkLimit;
    }

    protected int getAckLimit() {
        return this.ackLimit;
    }

    protected boolean getIsAckLimited() {
        return this.isAckLimited;
    }

    protected boolean getIsDedicatedToConnectionConsumer() {
        return this.isDedicatedToConnectionConsumer && !this.connectionConsumerTable.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long getNextSessionId() {
        Object object = this.syncObj;
        synchronized (object) {
            ++this.nextSessionId;
            if (this.nextSessionId == Long.MAX_VALUE) {
                this.nextSessionId = 1L;
                this.sessionIdReset = true;
            }
            if (this.sessionIdReset) {
                boolean found = false;
                while (!found) {
                    SessionQueue key = this.readQTable.get(new Long(this.nextSessionId));
                    if (key == null) {
                        found = true;
                        continue;
                    }
                    ++this.nextSessionId;
                    if (this.nextSessionId != Long.MAX_VALUE) continue;
                    this.nextSessionId = 1L;
                }
            }
            return new Long(this.nextSessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNextTransactionID() throws JMSException {
        Object object = this.syncObj;
        synchronized (object) {
            ++this.nextTransactionID;
            if (this.nextTransactionID == Integer.MAX_VALUE) {
                this.nextTransactionID = 1;
            }
            return this.nextTransactionID;
        }
    }

    protected void addToReadQTable(Object sid, Object readQueue) {
        this.readQTable.put(sid, readQueue);
    }

    protected void removeFromReadQTable(Object sid) {
        this.readQTable.remove(sid);
    }

    public void addToAckQTable(Object aid, Object readQueue) {
        this.ackQTable.put(aid, readQueue);
    }

    public ReadQTable getAckQTable() {
        return this.ackQTable;
    }

    public void removeFromAckQTable(Object aid) {
        this.ackQTable.remove(aid);
    }

    public Object getAndRemoveFromAckQTable(Object aid) {
        SessionQueue obj = this.ackQTable.get(aid);
        this.ackQTable.remove(aid);
        return obj;
    }

    protected void addMessageProducer(Object producerIDKey, MessageProducerImpl producer) {
        MessageProducerImpl o = this.producers.put(producerIDKey, producer);
        if (o != null && this.logger.isTraceEnabled()) {
            this.logger.trace("ERROR : Duplicate ProducerID in connection.addMessageProducer : {}", producerIDKey);
        }
    }

    protected void removeMessageProducer(Object producerIDKey) {
        Object o = this.producers.remove(producerIDKey);
        if (o == null && this.logger.isTraceEnabled()) {
            this.logger.trace("ERROR : Unknown producer in connection.removeMessageProducer : {}", producerIDKey);
        }
    }

    public MessageProducerImpl findMessageProducer(Object producerIDKey) {
        return (MessageProducerImpl)this.producers.get(producerIDKey);
    }

    protected void addLocalInterest(Consumer consumer) {
    }

    protected void removeLocalInterest(Consumer consumer) {
        this.interestTable.removeInterest(consumer);
    }

    protected void addInterest(Consumer consumer) throws JMSException {
        this.addLocalInterest(consumer);
        this.writeChannel.addInterest(consumer);
    }

    protected void removeInterest(Consumer consumer) throws JMSException {
        this.writeChannel.removeInterest(consumer);
        this.removeLocalInterest(consumer);
    }

    protected void unsubscribe(String durableName) throws JMSException {
        Enumeration enum2 = this.connectionConsumerTable.elements();
        ConnectionConsumerImpl connConsumer = null;
        while (enum2.hasMoreElements()) {
            connConsumer = (ConnectionConsumerImpl)enum2.nextElement();
            if (!connConsumer.getDurable() || !connConsumer.getDurableName().equals(durableName)) continue;
            String errorString = AdministeredObject.cr.getKString("C4007", durableName);
            JMSException jmse = new JMSException(errorString, "C4007");
            ExceptionHandler.throwJMSException(jmse);
        }
        this.writeChannel.unsubscribe(durableName);
    }

    public ProtocolHandler getProtocolHandler() {
        return this.protocolHandler;
    }

    protected WriteChannel getWriteChannel() {
        return this.writeChannel;
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    public boolean isAdminKeyUsed() {
        return this.adminKeyUsed;
    }

    protected Properties getConfiguration() {
        return (Properties)this.configuration.clone();
    }

    public String getProperty(String propname) {
        String propval = (String)this.configuration.get(propname);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("****** property {} : {}", (Object)propname, (Object)propval);
        }
        return propval;
    }

    public String getTrimmedProperty(String propName) {
        String prop = this.getProperty(propName);
        if (prop != null && prop.trim().length() == 0) {
            prop = null;
        }
        return prop;
    }

    public String getProperty(String propname, String propdefault) {
        String propval = (String)this.configuration.get(propname);
        if (propval == null) {
            propval = System.getProperty(propname);
        }
        return propval == null ? propdefault : propval;
    }

    public UnifiedReadChannel getUnifiedReadChannel() {
        return this.readChannel;
    }

    protected void setProtocolHandler(ProtocolHandler handler) {
        this.protocolHandler = handler;
    }

    protected boolean getIsTopicConnection() {
        return this.isTopicConnection;
    }

    protected void setIsTopicConnection(boolean isTopic) {
        this.isTopicConnection = isTopic;
    }

    protected boolean getISQueueConnection() {
        return this.isQueueConnection;
    }

    protected void setIsQueueConnection(boolean isQueue) {
        this.isQueueConnection = isQueue;
    }

    protected InterestTable getInterestTable() {
        return this.interestTable;
    }

    protected void addSession(SessionImpl session) {
        this.sessionTable.addElement(session);
    }

    protected boolean removeSession(SessionImpl session) {
        return this.sessionTable.removeElement(session);
    }

    protected void addConnectionConsumer(ConnectionConsumerImpl connectionConsumer) {
        this.connectionConsumerTable.addElement(connectionConsumer);
    }

    protected void removeConnectionConsumer(ConnectionConsumerImpl connectionConsumer) {
        this.connectionConsumerTable.removeElement(connectionConsumer);
    }

    protected void addTempDest(TemporaryDestination tempDest) {
        this.tempDestTable.addElement(tempDest);
    }

    protected void removeTempDest(TemporaryDestination tempDest) {
        this.tempDestTable.removeElement(tempDest);
    }

    protected void startSessions() throws JMSException {
        Enumeration enum2 = this.sessionTable.elements();
        SessionImpl session = null;
        while (enum2.hasMoreElements()) {
            session = (SessionImpl)enum2.nextElement();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("starting session: {}", session.getSessionId());
            }
            session.start();
        }
    }

    protected void stopSessions() throws JMSException {
        Enumeration enum2 = this.sessionTable.elements();
        SessionImpl session = null;
        while (enum2.hasMoreElements()) {
            session = (SessionImpl)enum2.nextElement();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("stopping session: {}", session.getSessionId());
            }
            session.stop();
        }
    }

    private void startConnectionConsumers() {
        Enumeration enum2 = this.connectionConsumerTable.elements();
        ConnectionConsumerImpl connectionConsumer = null;
        while (enum2.hasMoreElements()) {
            connectionConsumer = (ConnectionConsumerImpl)enum2.nextElement();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("starting connectionConsumer: {}", connectionConsumer.getReadQueueId().intValue());
            }
            connectionConsumer.start();
        }
    }

    private void stopConnectionConsumers() {
        Enumeration enum2 = this.connectionConsumerTable.elements();
        ConnectionConsumerImpl connectionConsumer = null;
        while (enum2.hasMoreElements()) {
            connectionConsumer = (ConnectionConsumerImpl)enum2.nextElement();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("stopping connectionConsumer: {}", connectionConsumer.getReadQueueId().intValue());
            }
            connectionConsumer.stop();
        }
    }

    private void closeConnectionConsumers() throws JMSException {
        block3: {
            ConnectionConsumerImpl connectionConsumer = null;
            try {
                while (!this.connectionConsumerTable.isEmpty()) {
                    connectionConsumer = (ConnectionConsumerImpl)this.connectionConsumerTable.firstElement();
                    connectionConsumer.close();
                    this.connectionConsumerTable.remove(connectionConsumer);
                }
            }
            catch (Exception e) {
                if (!this.logger.isTraceEnabled()) break block3;
                this.logger.trace("", e);
            }
        }
    }

    protected synchronized void suspendMessageDelivery() throws JMSException {
        if (this.getIsSuspended()) {
            return;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("sending STOP to broker ...");
        }
        this.protocolHandler.stop();
        this.isSuspended = true;
    }

    protected synchronized void resumeMessageDelivery() throws JMSException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("sending START to broker ...");
        }
        this.protocolHandler.start();
        this.isSuspended = false;
    }

    public boolean getIsSuspended() {
        return this.isSuspended;
    }

    public boolean getIsStopped() {
        return this.isStopped;
    }

    public String getClientID() throws JMSException {
        this.checkConnectionState();
        return this.clientID;
    }

    public String getCliID() {
        return this.clientID;
    }

    public void setClientID(String clientID) throws JMSException {
        this.checkConnectionState();
        this.checkSetClientID(clientID);
        this.protocolHandler.setClientID(clientID);
        this.clientID = clientID;
        this.setClientIDFlag();
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        this.checkConnectionState();
        return this.connectionMetaData;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        this.checkConnectionState();
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.checkConnectionState();
        this.exceptionListener = listener;
        this.setClientIDFlag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JMSException {
        this.checkConnectionState();
        if (!this.isStopped) {
            return;
        }
        this.setClientIDFlag();
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.protocolHandler.start();
            this.isStopped = false;
            this.startSessions();
            this.startConnectionConsumers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws JMSException {
        this.checkConnectionState();
        if (this.isStopped || this.isClosed) {
            return;
        }
        if (this.connectionIsBroken) {
            this.exitConnection();
            return;
        }
        this.checkPermission();
        this.setClientIDFlag();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("stopping readChannel ...");
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.protocolHandler.stop();
            this.stopSessions();
            this.stopConnectionConsumers();
            this.isStopped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void close() throws JMSException {
        this.isCloseCalled = true;
        if (this.eventHandler != null) {
            this.eventHandler.close();
        }
        if (this.isClosed) {
            return;
        }
        if (this.connectionIsBroken || this.recoverInProcess) {
            this.exitConnection();
            return;
        }
        this.checkPermission();
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            block20: {
                block19: {
                    block18: {
                        if (this.isClosed) {
                            return;
                        }
                        this.protocolHandler.incStoppedCount();
                        this.stop();
                        this.closeAllSessions();
                        this.closeConnectionConsumers();
                        this.protocolHandler.checkout();
                        this.isClosed = true;
                        this.protocolHandler.goodBye(true);
                        this.readChannel.waitGoodByeAck(this.ackQueue);
                        if (!this.logger.isTraceEnabled()) break block18;
                        this.logger.trace("send goodbye ok.");
                    }
                    Object var4_2 = null;
                    try {
                        this.readChannel.close();
                        this.writeChannel.close();
                        this.protocolHandler.close();
                    }
                    catch (Exception ex2) {
                        if (!this.logger.isTraceEnabled()) break block19;
                        this.logger.trace("", ex2);
                    }
                }
                this.protocolHandler = null;
                this.readChannel = null;
                this.writeChannel = null;
                this.logLifeCycle("I101");
                {
                    break block20;
                    catch (JMSException e) {
                        block21: {
                            if (!(this.connectionIsBroken || this.recoverInProcess || this.isClosed)) {
                                throw e;
                            }
                            this.exitConnection();
                            Object var4_3 = null;
                            try {
                                this.readChannel.close();
                                this.writeChannel.close();
                                this.protocolHandler.close();
                            }
                            catch (Exception ex2) {
                                if (!this.logger.isTraceEnabled()) break block21;
                                this.logger.trace("", ex2);
                            }
                        }
                        this.protocolHandler = null;
                        this.readChannel = null;
                        this.writeChannel = null;
                        this.logLifeCycle("I101");
                        break block20;
                    }
                    catch (Exception ex) {
                        block22: {
                            this.logger.error("", ex);
                            Object var4_4 = null;
                            try {
                                this.readChannel.close();
                                this.writeChannel.close();
                                this.protocolHandler.close();
                            }
                            catch (Exception ex2) {
                                if (!this.logger.isTraceEnabled()) break block22;
                                this.logger.trace("", ex2);
                            }
                        }
                        this.protocolHandler = null;
                        this.readChannel = null;
                        this.writeChannel = null;
                        this.logLifeCycle("I101");
                    }
                }
                catch (Throwable throwable) {
                    block23: {
                        Object var4_5 = null;
                        try {
                            this.readChannel.close();
                            this.writeChannel.close();
                            this.protocolHandler.close();
                        }
                        catch (Exception ex2) {
                            if (!this.logger.isTraceEnabled()) break block23;
                            this.logger.trace("", ex2);
                        }
                    }
                    this.protocolHandler = null;
                    this.readChannel = null;
                    this.writeChannel = null;
                    this.logLifeCycle("I101");
                    throw throwable;
                }
            }
        }
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    protected void checkSetClientID(String cid) throws JMSException {
        IllegalStateException jmse;
        String errorString;
        if (!this.allowToSetClientID) {
            errorString = AdministeredObject.cr.getKString("C4054");
            jmse = new IllegalStateException(errorString, "C4054");
            ExceptionHandler.throwJMSException((JMSException)jmse);
        }
        if (cid == null || cid.trim().length() == 0) {
            errorString = AdministeredObject.cr.getKString("C4053", "\"\"");
            jmse = new InvalidClientIDException(errorString, "C4053");
            ExceptionHandler.throwJMSException((JMSException)jmse);
        }
    }

    protected void setClientIDFlag() throws JMSException {
        this.allowToSetClientID = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAllSessions() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("closing all sessions ...");
        }
        SessionImpl session = null;
        try {
            while (this.sessionTable.size() > 0) {
                session = (SessionImpl)this.sessionTable.firstElement();
                this.closeSession(session);
            }
            Object var3_2 = null;
            connectionLogger.log(Level.FINEST, "all sessions closed ...");
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            connectionLogger.log(Level.FINEST, "all sessions closed ...");
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void closeSession(SessionImpl session) {
        try {
            try {
                session.close();
            }
            catch (Exception e) {
                this.logger.warn(e.getMessage(), e);
                Object var4_3 = null;
                this.sessionTable.remove(session);
                return;
            }
            Object var4_2 = null;
            this.sessionTable.remove(session);
            return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.sessionTable.remove(session);
            throw throwable;
        }
    }

    protected void closeConsumerQueues() {
        Object[] tmp = this.interestTable.toArray();
        for (int i = 0; i < tmp.length; ++i) {
            if (!(tmp[i] instanceof MessageConsumerImpl)) continue;
            ((MessageConsumerImpl)tmp[i]).receiveQueue.close();
            ((MessageConsumerImpl)tmp[i]).isClosed = true;
            connectionLogger.log(Level.FINEST, "Message consumer closed: " + tmp[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exitConnection() {
        connectionLogger.log(Level.FINEST, "Starting to exit connection ...");
        if (this.isClosed) {
            return;
        }
        try {
            block5: {
                try {
                    this.closeAllSessions();
                    this.closeConsumerQueues();
                    this.closeConnectionConsumers();
                    if (this.writeChannel == null) break block5;
                    this.writeChannel.close();
                }
                catch (Exception e) {
                    this.logger.warn(e.getMessage(), e);
                    Object var3_2 = null;
                    this.isClosed = true;
                    this.setReconnecting(false);
                }
            }
            Object var3_1 = null;
            this.isClosed = true;
            this.setReconnecting(false);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.isClosed = true;
            this.setReconnecting(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnectionFromRA() throws JMSException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.openedFromXA) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openConnectionFromRA(boolean mode) throws JMSException {
        if (this.connectionIsBroken || this.reconnecting) {
            return;
        }
        if (this.disableReopenFromRA) {
            return;
        }
        Object object = this.syncObj;
        synchronized (object) {
            this.openConnection(mode);
        }
    }

    private void openConnection(boolean mode) throws JMSException {
        if (!this.isClosed()) {
            return;
        }
        this.connectionMetaData = new ConnectionMetaDataImpl(this);
        this.protocolType = this.initiator.getMqAddress().getProtocolType();
        this.protocolHandler = InjectorUtil.createProtocolHandle(this.getProtocolType());
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("generate protocol handler: {}", this.protocolHandler);
        }
        this.protocolHandler.setConnection(this);
        if (this.ackOnProduce != null) {
            if (this.ackOnProduce.equals("true")) {
                this.protocolHandler.enableWriteAcknowledge(true);
            } else if (this.ackOnProduce.equals("false")) {
                this.protocolHandler.enableWriteAcknowledge(false);
            }
        }
        if (this.ackOnAcknowledge != null && this.ackOnAcknowledge.equals("false")) {
            this.protocolHandler.setAckAck(false);
        }
        this.connectionIsBroken = false;
        this.recoverInProcess = false;
        this.readChannel = InjectorUtil.createReadChannel(this.getProtocolType());
        this.readChannel.setConnection(this);
        this.writeChannel = new WriteChannel(this);
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("waiting for checkin ack.");
            }
            ConnectionResult ex = this.protocolHandler.getConnectionResult();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("after checkin ack, ex:{}", ex);
            }
            if (ex == null) {
                throw new JMSException("waiting for checkin timeout.");
            }
            if (ex.getErrorCode() == -1) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("checkin error, {}", (Object)ex.getDescribe());
                }
                throw new JMSException(ex.getDescribe());
            }
        }
        catch (Exception ex1) {
            this.logger.error("why???", ex1);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("{}", this);
        }
        try {
            this.hello();
            if (this.adminSetClientID) {
                this.protocolHandler.setClientID(this.clientID);
                this.setClientIDFlag();
            }
        }
        catch (JMSException e) {
            if (!this.connectionIsBroken) {
                try {
                    this.protocolHandler.goodBye(false);
                }
                catch (JMSException e1) {
                    // empty catch block
                }
            }
            try {
                this.readChannel.close();
                this.protocolHandler.close();
            }
            catch (JMSException e2) {
                e2.setLinkedException((Exception)((Object)e));
                throw e2;
            }
            throw e;
        }
        this.isClosed = false;
        this.openedFromXA = mode;
    }

    protected void checkPermission() throws JMSException {
        SessionImpl session = null;
        try {
            Enumeration enum2 = this.sessionTable.elements();
            while (enum2.hasMoreElements()) {
                session = (SessionImpl)enum2.nextElement();
                session.checkPermission();
            }
        }
        catch (JMSException ie) {
            throw ie;
        }
        catch (Exception ex) {
            IllegalStateException jmse = new IllegalStateException(ex.toString());
            jmse.setLinkedException(ex);
            ExceptionHandler.throwJMSException((JMSException)jmse);
        }
    }

    protected void checkConnectionState() throws JMSException {
        if (this.isClosed) {
            String errorString = AdministeredObject.cr.getKString("C4062");
            IllegalStateException jmse = new IllegalStateException(errorString, "C4062");
            ExceptionHandler.throwJMSException((JMSException)jmse);
        }
    }

    protected boolean isBroken() {
        return this.connectionIsBroken;
    }

    protected synchronized boolean isClosed() {
        return this.isClosed;
    }

    public synchronized boolean _isClosed() {
        return this.isClosed();
    }

    public synchronized void _unsetClientID() throws JMSException {
        this.clientID = null;
        this.allowToSetClientID = true;
        this.protocolHandler.unsetClientID();
    }

    public synchronized void _setClientID(String cid) throws JMSException {
        this.checkConnectionState();
        this.protocolHandler.setClientID(cid);
        this.clientID = cid;
        this.allowToSetClientID = false;
    }

    public synchronized String _getClientID() {
        return this.clientID;
    }

    public synchronized void _closeForPooling() throws JMSException {
        block4: {
            TemporaryDestination tDest = null;
            try {
                while (!this.tempDestTable.isEmpty()) {
                    tDest = (TemporaryDestination)this.tempDestTable.firstElement();
                    tDest.delete();
                    this.tempDestTable.remove(tDest);
                }
            }
            catch (Exception e) {
                if (!this.logger.isTraceEnabled()) break block4;
                this.logger.trace("", e);
            }
        }
        if (this.clientID != null) {
            this._unsetClientID();
        }
    }

    public void _setExceptionListenerFromRA(ExceptionListener listener) throws JMSException {
        this.checkConnectionState();
        this.exceptionListener = listener;
    }

    public boolean hasDaemonThreads() {
        return this.daemonThreads;
    }

    protected void setIsBroken(boolean flag) {
        this.connectionIsBroken = flag;
    }

    public void setRecoverInProcess(boolean state) {
        this.recoverInProcess = state;
    }

    protected boolean getRecoverInProcess() {
        return this.recoverInProcess;
    }

    public String getUserName() {
        return this.userName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getClientIDOrIPAddress() {
        if (this.clientID != null) {
            return this.clientID;
        }
        if (this.clientIPAddress == null) {
            Object object = this.syncObj;
            synchronized (object) {
                try {
                    this.clientIPAddress = InetAddress.getLocalHost().getHostAddress();
                }
                catch (Exception e) {
                    this.clientIPAddress = "127.0.0.1";
                }
            }
        }
        return this.clientIPAddress;
    }

    public void dump(PrintStream ps) {
    }

    protected long getPingInterval() {
        return this.tmqiPingInterval;
    }

    public String toString() {
        return "BrokerAddress=" + this.getLastContactedBrokerAddress() + ", ConnectionID=" + this.getConnectionID() + ", ReconnectEnabled: " + this.tmqiReconnect + ", IsConnectedToHABroker: " + this.isConnectedToHABroker;
    }

    public Hashtable getDebugState(boolean verbose) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("Configuration", this.configuration);
        ht.put("connectionID", String.valueOf(this.connectionID));
        ht.put("clientID", String.valueOf(this.clientID));
        ht.put("brokerProtocolLevel", String.valueOf(this.brokerProtocolLevel));
        ht.put("reconnecting", String.valueOf(this.reconnecting));
        ht.put("isTopicConnection", String.valueOf(this.isTopicConnection));
        ht.put("isQueueConnection", String.valueOf(this.isQueueConnection));
        ht.put("isStopped", String.valueOf(this.isStopped));
        ht.put("isClosed", String.valueOf(this.isClosed));
        ht.put("connectionIsBroken", String.valueOf(this.connectionIsBroken));
        ht.put("recoverInProcess", String.valueOf(this.recoverInProcess));
        ht.put("failoverEnabled", String.valueOf(this.failoverEnabled));
        ht.put("tmqiReconnectEnabled", String.valueOf(this.tmqiReconnect));
        ht.put("isConnectedToHABroker", String.valueOf(this.isConnectedToHABroker));
        if (this.JMQBrokerList != null) {
            ht.put("JMQBrokerList", this.JMQBrokerList);
        }
        if (this.JMQClusterID != null) {
            ht.put("JMQClusterID", this.JMQClusterID);
        }
        if (this.JMQStoreOwner != null) {
            ht.put("JMQStoreOwner", this.JMQStoreOwner);
        }
        if (this.JMQStoreSession != null) {
            ht.put("JMQStoreSession", String.valueOf(this.JMQStoreSession));
        }
        boolean isExpLsrSet = false;
        if (this.exceptionListener != null) {
            isExpLsrSet = true;
        }
        ht.put("IsExceptionListenerSet", String.valueOf(isExpLsrSet));
        this.readChannel.putHashTable(ht);
        if (this.protocolHandler != null) {
            ht.put("protocolHandlerIsClosed", String.valueOf(this.protocolHandler.isClosed()));
            ht.put("UserBrokerInfo", this.protocolHandler.getUserBrokerInfo());
        }
        ht.put("FlowControl", this.flowControl.getDebugState(this));
        ht.put("# sessions", String.valueOf(this.sessionTable.size()));
        int n = 0;
        Enumeration enum2 = this.sessionTable.elements();
        while (enum2.hasMoreElements()) {
            SessionImpl session = (SessionImpl)enum2.nextElement();
            ht.put("Session[" + n + "]", session.getDebugState(verbose));
            ++n;
        }
        ht.put("# connectionConsumers", String.valueOf(this.connectionConsumerTable.size()));
        n = 0;
        enum2 = this.connectionConsumerTable.elements();
        while (enum2.hasMoreElements()) {
            ConnectionConsumerImpl connectionConsumer = (ConnectionConsumerImpl)enum2.nextElement();
            ht.put("ConnectionConsuer[" + n + "]", connectionConsumer.getDebugState(verbose));
            ++n;
        }
        return ht;
    }

    public Object TEST_GetAttribute(String name) {
        if (name.startsWith("FlowControl")) {
            return this.flowControl.TEST_GetAttribute(name, this);
        }
        return null;
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkConnectionState();
        this.setClientIDFlag();
        return new UnifiedSessionImpl(this, transacted, acknowledgeMode);
    }

    public XASession createXASession() throws JMSException {
        this.checkConnectionState();
        this.setClientIDFlag();
        return new XASessionImpl(this, false, 0);
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.createUnifiedConnectionConsumer(destination, messageSelector, sessionPool, maxMessages, null, false);
    }

    protected QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkConnectionState();
        this.setClientIDFlag();
        return new QueueSessionImpl(this, transacted, acknowledgeMode);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.createUnifiedConnectionConsumer((Destination)queue, messageSelector, sessionPool, maxMessages, null, false);
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkConnectionState();
        TopicSessionImpl ts = new TopicSessionImpl(this, transacted, acknowledgeMode);
        this.setClientIDFlag();
        return ts;
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.createUnifiedConnectionConsumer((Destination)topic, messageSelector, sessionPool, maxMessages, null, false);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.createUnifiedConnectionConsumer((Destination)topic, messageSelector, sessionPool, maxMessages, subscriptionName, true);
    }

    private ConnectionConsumer createUnifiedConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages, String subscriptionName, boolean durable) throws JMSException {
        this.checkConnectionState();
        if (durable && (subscriptionName == null || "".equals(subscriptionName))) {
            String errorString = AdministeredObject.cr.getKString("C4066", "\"\"");
            JMSException jmse = new JMSException(errorString, "C4066");
            ExceptionHandler.throwJMSException(jmse);
        }
        if (maxMessages < 1) {
            String mmsg = String.valueOf(maxMessages);
            String errorString = AdministeredObject.cr.getKString("C4030", mmsg);
            JMSException jmse = new JMSException(errorString, "C4030");
            ExceptionHandler.throwJMSException(jmse);
        }
        int load = 1;
        String lm = this.getProperty("tmqiLoadMaxToServerSession");
        if (lm != null && lm.equals("true")) {
            load = maxMessages;
        }
        this.setClientIDFlag();
        return new ConnectionConsumerImpl(this, destination, messageSelector, sessionPool, load, subscriptionName);
    }

    public Session createSession(int acknowledgeMode) throws JMSException {
        this.checkConnectionState();
        this.setClientIDFlag();
        return new UnifiedSessionImpl(this, acknowledgeMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEventListener(EventListener eventListener) throws JMSException {
        this.checkConnectionState();
        Object object = this.syncObj;
        synchronized (object) {
            if (eventListener != null) {
                this.constructEventHandler();
            }
            this.eventListener = eventListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventListener getEventListener() {
        Object object = this.syncObj;
        synchronized (object) {
            return this.eventListener;
        }
    }

    public String getBrokerAddress() {
        String brokerAddr = null;
        try {
            brokerAddr = this.getProtocolHandler().getConnectionHandler().getBrokerAddress();
        }
        catch (Exception e) {
            brokerAddr = this.getLastContactedBrokerAddress();
        }
        return brokerAddr;
    }

    public boolean isConnectedToSameBroker(ConnectionImpl foreignConn) {
        boolean isSame = false;
        if (foreignConn == null) {
            return false;
        }
        String foreignAddr = foreignConn.getBrokerAddress();
        String myAddr = this.getBrokerAddress();
        if (myAddr.equals(foreignAddr)) {
            isSame = true;
        }
        return isSame;
    }

    public String getBrokerAddressList() {
        return this.JMQBrokerList;
    }

    public boolean isConnectedToHABroker() {
        return this.isConnectedToHABroker;
    }

    public boolean getIsCloseCalled() {
        return this.isCloseCalled;
    }

    private void constructEventHandler() {
        if (this.eventHandler == null) {
            this.eventHandler = new EventHandler(this);
        }
    }

    public EventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void triggerConnectionReconnectedEvent() {
        if (this.eventListener != null) {
            this.eventHandler.triggerConnectionReconnectedEvent();
        } else {
            this.setReconnecting(false);
        }
        this.logLifeCycle("E301");
    }

    public void triggerConnectionReconnectFailedEvent(JMSException jmse) {
        if (this.eventListener != null) {
            this.eventHandler.triggerConnectionReconnectFailedEvent(jmse, this.lastContactedBrokerAddress);
        }
        this.logLifeCycle("E401");
    }

    public void triggerConnectionClosingEvent(long timePeriod) {
        if (this.eventListener != null) {
            this.eventHandler.triggerConnectionClosingEvent("E101", timePeriod);
        }
        this.logLifeCycle("E101");
    }

    public void triggerConnectionClosedEvent(String evcode, JMSException jmse) {
        if (this.eventListener != null) {
            this.eventHandler.triggerConnectionClosedEvent(evcode, jmse);
        }
        this.logLifeCycle(evcode);
    }

    public void triggerConnectionExitEvent(JMSException jmse) {
        if (this.eventListener != null) {
            this.eventHandler.triggerConnectionExitEvent(jmse, this.exceptionListener);
        } else if (this.exceptionListener != null) {
            this.exceptionListener.onException(jmse);
        }
    }

    public void triggerConnectionAddressListChangedEvent(String addressList) {
        if (this.eventListener != null && this.extendedEventNotification) {
            this.eventHandler.triggerConnectionAddressListChangedEvent(addressList);
        }
        this.logLifeCycle("E600");
    }

    public void logLifeCycle(String key) {
        if (connectionLogger.isLoggable(Level.FINE)) {
            connectionLogger.log(Level.FINE, key, this);
        }
    }

    public boolean shouldUpdateAddressList() {
        boolean flag = false;
        flag = this.JMQBrokerList == null ? false : !this.JMQBrokerList.equals(this.savedJMQBrokerList);
        return flag;
    }

    public void setLastContactedBrokerAddress(String addr) {
        this.lastContactedBrokerAddress = addr;
    }

    public String getLastContactedBrokerAddress() {
        return this.lastContactedBrokerAddress;
    }

    public static JDKLogger getConnectionLogger() {
        return connectionLogger;
    }

    public synchronized void setExtendedEventNotification(boolean flag) {
        this.extendedEventNotification = flag;
    }

    public synchronized boolean getExtendedEventNotification() {
        return this.extendedEventNotification;
    }

    public long getTimeout() {
        return this.protocolHandler.getTimeout();
    }

    public synchronized void setEnableSharedClientID(boolean flag) {
        this.tmqiEnableSharedClientID = flag;
    }

    public synchronized boolean getEnableSharedClientID() {
        return this.tmqiEnableSharedClientID;
    }

    public synchronized void setEnableSharedSubscriptions(boolean flag) {
        this.tmqiEnableSharedSubscriptions = flag;
    }

    public synchronized boolean getEnableSharedSubscriptions(boolean flag) {
        return this.tmqiEnableSharedSubscriptions;
    }

    public void setConnectedToHABroker() {
        if (this.isHAEnabled()) {
            this.isConnectedToHABroker = true;
            if (!"ADMIN".equals(this.connectionType)) {
                this.tmqiReconnect = true;
                this.configuration.setProperty("tmqiReconnectEnabled", Boolean.toString(true));
                connectionLogger.fine("Connected to HA broker, auto-reconnect is enabled");
            } else {
                connectionLogger.fine("*** admin user, no auto-reconnect");
            }
        } else {
            String info = AdministeredObject.cr.getKString("I112", this.getLastContactedBrokerAddress());
            connectionLogger.log(Level.WARNING, info);
        }
    }

    public long getConnectionTotalSendCount() {
        return this.protocolHandler.getConnectionTotalSendCount();
    }

    public long getConnectionTotalRecCount() {
        return this.protocolHandler.getConnectionTotalRecCount();
    }

    public void sendServerControl(byte type) throws JMSException {
        this.protocolHandler.sendServerControl(type);
    }

    public void triggerSendExcetpion(JMSException jmse) {
        if (this.exceptionListener != null) {
            this.exceptionListener.onException(jmse);
        }
    }

    public String getLocalIP() {
        return this.localIP;
    }

    public void setLocalIP(String localIP) {
        this.localIP = localIP;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }
}

