/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.jms.util.InjectorUtil;
import com.tongtech.jms.util.TongJMSConfig;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.AdministeredObject;
import com.tongtech.tmqi.io.MQAddress;
import com.tongtech.tmqi.jmsclient.ConnectException;
import com.tongtech.tmqi.jmsclient.ConnectionHandler;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.ExceptionHandler;
import com.tongtech.tmqi.jmsclient.MQAddressList;
import com.tongtech.tmqi.jmsclient.StreamHandler;
import java.net.MalformedURLException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.jms.JMSException;

public class ConnectionInitiator {
    static Logger logger = LoggerFactory.getLogger(ConnectionInitiator.class);
    private ConnectionImpl connection = null;
    private MQAddressList addrList = null;
    private String addrListString = null;
    private boolean useAddressList = false;
    private int nextStart = 0;
    private int reconnectDelay = 3000;
    private int reconnectRetries = 0;
    private int addressListIterations = 0;
    private static final String PRIORITY = "PRIORITY";
    private static final String RANDOM = "RANDOM";
    private static final String JMS_SERVICE_NAME = "jms";
    private String defaultService = "jms";
    private static final String SSLJMS_SERVICE_NAME = "ssljms";
    public static final int HA_RECONNECT_DELAY = 3000;
    private boolean useStaticAddressList = false;
    private boolean isJMSService = true;
    private volatile boolean shouldRedirect = false;
    private boolean isRedirected = false;
    private String redirectURL = null;

    public ConnectionInitiator(ConnectionImpl connection) throws JMSException, MalformedURLException {
        this.connection = connection;
        this.init();
    }

    private void init() throws JMSException, MalformedURLException {
        if (logger.isTraceEnabled()) {
            logger.trace("In ConnectionInitiator.init()");
        }
        this.useStaticAddressList = Boolean.getBoolean("tmqi.useStaticAddressList");
        String prop = this.connection.getTrimmedProperty("tmqiReconnectInterval");
        if (prop != null) {
            this.reconnectDelay = Integer.parseInt(prop);
            if (this.connection.isConnectedToHABroker && this.reconnectDelay < 3000) {
                this.reconnectDelay = 3000;
            }
        } else if (this.connection.isConnectedToHABroker) {
            this.reconnectDelay = 3000;
        }
        if ((prop = this.connection.getTrimmedProperty("tmqiReconnectAttempts")) != null) {
            this.reconnectRetries = Integer.parseInt(prop);
        }
        if ((prop = this.connection.getTrimmedProperty("tmqiAddressListIterations")) != null) {
            this.addressListIterations = Integer.parseInt(prop);
        }
        prop = this.connection.getTrimmedProperty("tmqiAddressList");
        this.addrList = this.createAddressList(prop);
        this.setDefaultService(this.addrList);
    }

    public ConnectionHandler createConnection() throws JMSException {
        return this.createConnection(false);
    }

    public ConnectionHandler reconnect() throws JMSException, MalformedURLException {
        ConnectionHandler handler = null;
        if (logger.isTraceEnabled()) {
            logger.trace("In ConnectionInitiator.reconnect()");
        }
        if (this.connection.isConnectedToHABroker && this.reconnectDelay < 3000) {
            this.reconnectDelay = 3000;
        }
        if (this.shouldRedirect) {
            handler = this.redirect();
        } else {
            if (logger.isTraceEnabled()) {
                logger.trace("*** Old broker list: " + this.connection.savedJMQBrokerList);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("*** New broker list: " + this.connection.JMQBrokerList);
            }
            if (this.connection.shouldUpdateAddressList()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("*** updating broker address list: {}", (Object)this.connection.JMQBrokerList);
                }
                this.resetAddressList(this.connection.JMQBrokerList);
                this.connection.savedJMQBrokerList = this.connection.JMQBrokerList;
            }
            handler = this.createConnection(true);
        }
        return handler;
    }

    private ConnectionHandler createConnection(boolean isReconnect) throws JMSException {
        ConnectionHandler ch = null;
        ch = this.useAddressList ? this.createConnectionNew(isReconnect) : this.createConnectionOld(isReconnect);
        if (ch == null && logger.isTraceEnabled()) {
            logger.trace("*** ConnectionInitiator.createConnection() returning null ConnectionHandler ...");
        }
        return ch;
    }

    private ConnectionHandler createConnectionNew(boolean isReconnect) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("In ConnectionInitiator.createConnectionNew()");
        }
        if (isReconnect && this.connection.isConnectedToHABroker) {
            this.addressListIterations = -1;
        }
        Exception[] elist = new Exception[this.addrList.size()];
        String[] alist = new String[this.addrList.size()];
        for (int i = 0; this.addressListIterations <= 0 || i < this.addressListIterations; ++i) {
            for (int j = 0; j < this.addrList.size(); ++j) {
                int currentIndex = (this.nextStart + j) % this.addrList.size();
                MQAddress addr = (MQAddress)this.addrList.get(currentIndex);
                try {
                    ConnectionHandler connHandler = this.createConnection(addr);
                    this.nextStart = this.getNextStartIndex(isReconnect, currentIndex);
                    return connHandler;
                }
                catch (Exception e) {
                    if (this.connection.isCloseCalled) {
                        if (e instanceof JMSException) {
                            throw (JMSException)((Object)e);
                        }
                        ExceptionHandler.handleConnectException(e, null);
                    }
                    logger.warn("", e);
                    elist[j] = e;
                    alist[j] = addr.toString();
                    if (j == this.addrList.size() - 1) continue;
                    try {
                        Thread.sleep(this.reconnectDelay);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    continue;
                }
            }
            if (i == this.addressListIterations - 1) continue;
            try {
                Thread.sleep(this.reconnectDelay);
                continue;
            }
            catch (Exception j) {
                // empty catch block
            }
        }
        if (elist.length == 1) {
            MQAddress addr = (MQAddress)this.addrList.get(0);
            String url = addr.getURL();
            ExceptionHandler.handleConnectException(elist[0], url);
            return null;
        }
        String errorString = AdministeredObject.cr.getKString("C4003", "[" + this.addrListString + "]");
        ConnectException ce = new ConnectException(errorString, "C4003", elist, alist);
        ExceptionHandler.handleConnectException((Exception)((Object)ce), "");
        return null;
    }

    private ConnectionHandler createConnectionOld(boolean isReconnect) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("In ConnectionInitiator.createConnectionOld()");
        }
        int count = 0;
        while (true) {
            if (this.connection.isCloseCalled) {
                String errstr = AdministeredObject.cr.getKString("C4062");
                com.tongtech.jms.JMSException jmse = new com.tongtech.jms.JMSException(errstr, "C4062");
                ExceptionHandler.throwJMSException(jmse);
            }
            ++count;
            try {
                if (isReconnect) {
                    this.sleep(this.reconnectDelay);
                }
                return this.openConnection();
            }
            catch (JMSException jmse) {
                if (!isReconnect) {
                    throw jmse;
                }
                this.triggerConnectionReconnectFailedEvent(jmse);
                if (this.reconnectRetries <= 0 || count < this.reconnectRetries) continue;
                throw jmse;
            }
            break;
        }
    }

    private void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
        }
    }

    private ConnectionHandler openConnection() throws JMSException {
        try {
            StreamHandler sh = InjectorUtil.createStreamHandler(this.connection.getProtocolType());
            return sh.openConnection(this.connection);
        }
        catch (Exception e) {
            JMSException jmse = null;
            if (e instanceof JMSException) {
                jmse = (JMSException)((Object)e);
            } else {
                jmse = ExceptionHandler.getJMSException(e, "C4038", false);
                jmse.setLinkedException(e);
            }
            ExceptionHandler.throwJMSException(jmse);
            return null;
        }
    }

    public boolean getUseAddressList() {
        return this.useAddressList;
    }

    public int getAddrListSize() {
        int size = 0;
        if (this.addrList != null) {
            size = this.addrList.size();
        }
        return size;
    }

    private void setBehavior(MQAddressList aList) throws JMSException {
        this.useAddressList = false;
        if (aList != null && aList.size() > 0) {
            this.useAddressList = true;
            String prop = this.connection.getProperty("tmqiAddressListBehavior");
            if (PRIORITY.equalsIgnoreCase(prop)) {
                aList.setBehavior(1);
            } else if (RANDOM.equalsIgnoreCase(prop)) {
                aList.setBehavior(2);
            } else {
                com.tongtech.jms.JMSException jmse = new com.tongtech.jms.JMSException("Bad tmqiAddressListBehavior value : " + prop);
                ExceptionHandler.throwJMSException(jmse);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Address list : \n" + aList);
            }
        }
    }

    private void validate(MQAddressList aList) throws JMSException {
    }

    private MQAddressList createAddressList(String addrString) throws JMSException, MalformedURLException {
        MQAddressList aList = null;
        this.addrListString = addrString;
        logger.debug("createAddressList, addrString={}", (Object)addrString);
        if (addrString != null && !addrString.equals("")) {
            aList = MQAddressList.createMQAddressList(addrString);
            this.validate(this.addrList);
        } else {
            String qcuName = null;
            try {
                qcuName = TongJMSConfig.getInstance().getQcuName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (qcuName == null || qcuName.length() == 0) {
                qcuName = "qcu1";
            }
            this.addrListString = "tlqlocal://localhost/" + qcuName;
            aList = MQAddressList.createMQAddressList(this.addrListString);
            this.validate(this.addrList);
        }
        this.setBehavior(aList);
        this.nextStart = 0;
        return aList;
    }

    private void setDefaultService(MQAddressList aList) {
        if (logger.isTraceEnabled()) {
            logger.trace("*** set default service with address list: " + aList);
        }
        if (aList != null && aList.size() > 0) {
            MQAddress addr = (MQAddress)aList.get(0);
            this.defaultService = addr.getServiceName();
        } else {
            this.defaultService = this.connection.getTrimmedProperty("tmqiBrokerServiceName");
            if (this.defaultService == null) {
                this.defaultService = JMS_SERVICE_NAME;
            }
        }
        this.isJMSService = JMS_SERVICE_NAME.equalsIgnoreCase(this.defaultService);
        if (logger.isTraceEnabled()) {
            logger.trace("*** default service name: " + this.defaultService);
        }
    }

    public String getDefaultServiceName() {
        return this.defaultService;
    }

    public void resetAddressList(String alString) throws JMSException, MalformedURLException {
        boolean resetAddr = false;
        if (this.useStaticAddressList) {
            return;
        }
        if (alString == null || alString.length() < 5) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("*** isJMSService: " + this.isJMSService);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("*** defaultService: " + this.defaultService);
        }
        if (this.isJMSService) {
            this.addrListString = alString;
            this.addrList = this.createAddressList(alString);
            resetAddr = true;
        } else if (SSLJMS_SERVICE_NAME.equalsIgnoreCase(this.defaultService)) {
            String newAddrList;
            this.addrListString = newAddrList = ConnectionInitiator.appendServiceName(alString, SSLJMS_SERVICE_NAME);
            this.addrList = this.createAddressList(newAddrList);
            resetAddr = true;
        }
        if (resetAddr && logger.isTraceEnabled()) {
            logger.trace("**** address list reset: {}", (Object)this.addrListString);
        }
    }

    public static String appendServiceName(String addrString, String serviceName) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(addrString, " ,");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            sb.append(s);
            if (s.indexOf(47, 5) < 0) {
                sb.append('/');
            }
            sb.append(serviceName);
            if (!st.hasMoreTokens()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private ConnectionHandler redirect() throws JMSException {
        ConnectionHandler connHandler = null;
        try {
            connHandler = this.doRedirect();
        }
        catch (Exception e) {
            connHandler = this.createConnectionNew(true);
        }
        return connHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionHandler doRedirect() throws JMSException {
        ConnectionHandler connHandler = null;
        String newaddr = this.redirectURL;
        try {
            if (!this.isJMSService) {
                StringBuffer sb = new StringBuffer();
                sb.append(this.redirectURL);
                if (this.redirectURL.indexOf(47, 5) < 0) {
                    sb.append('/');
                }
                sb.append(SSLJMS_SERVICE_NAME);
                newaddr = sb.toString();
            }
            logger.info("**** ConnectionInitiator: redirecting connection: {}", (Object)newaddr);
            MQAddress mqaddr = InjectorUtil.createMQAddress(this.connection.getProtocolType());
            mqaddr.initialize(newaddr);
            StreamHandler sh = InjectorUtil.createStreamHandler(this.connection.getProtocolType());
            connHandler = sh.openConnection(mqaddr, this.connection);
            this.isRedirected = true;
            logger.info("**** ConnectionInitiator: conn redirected: {}", (Object)newaddr);
        }
        catch (JMSException jmse) {
            throw jmse;
        }
        catch (Exception e) {
            ExceptionHandler.handleConnectException(e, this.connection.getLastContactedBrokerAddress());
        }
        finally {
            this.shouldRedirect = false;
        }
        return connHandler;
    }

    public void setRedirectURL(String url) {
        this.shouldRedirect = true;
        this.redirectURL = url;
        String msg = "RedirectURL=" + url;
        ConnectionImpl.connectionLogger.log(Level.INFO, msg);
    }

    public boolean isBrokerRedirected() {
        if (this.isRedirected) {
            this.isRedirected = false;
            return true;
        }
        return false;
    }

    private ConnectionHandler createConnection(MQAddress address) throws JMSException {
        ConnectionHandler connHandler = null;
        if (logger.isTraceEnabled()) {
            logger.trace("Create connection with MQ address: {}", address);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Reconnect retries: {}", this.reconnectRetries);
        }
        boolean keepTrying = true;
        int ct = 0;
        while (keepTrying) {
            JMSException jmse;
            if (this.connection.isCloseCalled) {
                if (logger.isTraceEnabled()) {
                    logger.trace("#### connection.isClosed = true");
                }
                String errstr = AdministeredObject.cr.getKString("C4062");
                jmse = new com.tongtech.jms.JMSException(errstr, "C4062");
                ExceptionHandler.throwJMSException(jmse);
            }
            try {
                if (logger.isTraceEnabled()) {
                    logger.trace("#### Connecting to :{},  counter: {}", address, (Object)new Integer(ct));
                }
                StreamHandler sh = InjectorUtil.createStreamHandler(this.connection.getProtocolType());
                connHandler = sh.openConnection(address, this.connection);
                return connHandler;
            }
            catch (Exception e) {
                ++ct;
                if (logger.isTraceEnabled()) {
                    logger.trace("\nConnection Attempt failed.\n, Address = " + address + ", attempt# = " + ct);
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("", e);
                }
                jmse = this.getJMSException(e);
                this.triggerConnectionReconnectFailedEvent(jmse);
                if (!(e instanceof JMSException)) {
                    ExceptionHandler.logCaughtException(e);
                }
                if (this.reconnectRetries < 0 || ct < this.reconnectRetries) {
                    this.sleepReconnectDelay();
                    continue;
                }
                ExceptionHandler.throwJMSException(jmse);
            }
        }
        if (connHandler == null) {
            logger.info("**** error: Connection handler is null ****");
        }
        return connHandler;
    }

    private void sleepReconnectDelay() {
        try {
            Thread.sleep(this.reconnectDelay);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JMSException getJMSException(Exception e) {
        if (e instanceof JMSException) {
            return (JMSException)((Object)e);
        }
        JMSException jmse = ExceptionHandler.getJMSException(e, "C4038", false);
        jmse.setLinkedException(e);
        return jmse;
    }

    private void triggerConnectionReconnectFailedEvent(JMSException jmse) {
        this.connection.triggerConnectionReconnectFailedEvent(jmse);
    }

    private int getNextStartIndex(boolean isReconnect, int currentIndex) {
        int nextStart = currentIndex;
        nextStart = this.reconnectRetries > 0 ? currentIndex : (isReconnect ? (this.connection.failoverEnabled ? (currentIndex + 1) % this.addrList.size() : currentIndex) : (currentIndex + 1) % this.addrList.size());
        return nextStart;
    }

    public MQAddress getMqAddress() throws JMSException {
        MQAddress addr = null;
        if (this.addrList != null && this.addrList.size() > 0) {
            addr = (MQAddress)this.addrList.get(0);
        }
        return addr;
    }
}

