/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.jms.IllegalStateException;
import com.tongtech.log.JDKLogger;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.AdministeredObject;
import com.tongtech.tmqi.jmsclient.ConnectionConsumerImpl;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.Consumer;
import com.tongtech.tmqi.jmsclient.ExceptionHandler;
import com.tongtech.tmqi.jmsclient.MessageProducerImpl;
import com.tongtech.tmqi.jmsclient.SessionImpl;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import javax.jms.JMSException;

public class ConnectionRecover
implements Runnable {
    static Logger logger = LoggerFactory.getLogger(ConnectionRecover.class);
    protected ConnectionImpl connection = null;
    protected static final String iConnectionRecover = "iConnectionRecover-";
    protected static final int RECOVER_INACTIVE = 0;
    protected static final int RECOVER_STOPPED = 1;
    protected static final int RECOVER_STARTED = 2;
    protected static final int RECOVER_IN_PROCESS = 3;
    protected static final int TRANSPORT_CONNECTED = 4;
    protected static final int RECOVER_SUCCEEDED = 5;
    protected static final int RECOVER_FAILED = 6;
    public static final int RECOVER_ABORTED = 7;
    protected static final String[] STATES = new String[]{"RECOVER_INACTIVE", "RECOVER_STOPPED", "RECOVER_STARTED", "RECOVER_IN_PROCESS", "RECOVER_TRANSPORT_CONNECTED", "RECOVER_SUCCEEDED", "RECOVER_FAILED", "RECOVER_ABORTED"};
    private int recoverState = 0;
    private int maxRetries = 100;
    private int failedCount = 0;
    protected Thread recoverThread = null;
    private static final int WAIT_TIME = 3000;
    private static final int MAX_WAIT_COUNT = 200;
    public int recoverDelay = 3000;
    private JDKLogger connLogger = ConnectionImpl.connectionLogger;
    private boolean enableCCReconnect = true;

    public ConnectionRecover(ConnectionImpl connection) {
        boolean flag;
        this.connection = connection;
        String prop = connection.getTrimmedProperty("tmqi.recover.maxRetries");
        if (prop != null) {
            this.maxRetries = Integer.parseInt(prop);
        }
        if ((prop = connection.getTrimmedProperty("tmqi.recover.delay")) != null) {
            this.recoverDelay = Integer.parseInt(prop);
            if (connection.isConnectedToHABroker && this.recoverDelay < 3000) {
                this.recoverDelay = 3000;
            }
        }
        if ((prop = connection.getTrimmedProperty("tmqi.recover.connectionConsumer")) != null && !(flag = Boolean.getBoolean(prop))) {
            this.enableCCReconnect = false;
        }
        this.logRecoverState(0);
    }

    public void init() throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("*** in ConnectionRecover.init() ...");
        }
        if (this.connection.isConnectedToHABroker) {
            if (this.recoverDelay < 3000) {
                this.recoverDelay = 3000;
            }
            this.sleep(this.recoverDelay);
        }
        this.closeProtocolHandler();
        this.connection.protocolHandler.init(true);
        this.logRecoverState(4);
    }

    public void start() {
        this.recoverThread = new Thread(this);
        if (this.connection.hasDaemonThreads()) {
            this.recoverThread.setDaemon(true);
        }
        this.recoverThread.setName("iConnectionRecover--" + this.connection.getLocalID() + "-" + this.connection.getConnectionID());
        this.setRecoverState(2);
        this.recoverThread.start();
    }

    @Override
    public void run() {
        if (logger.isTraceEnabled()) {
            logger.trace("ConnectionRecover begin ");
        }
        this.connection.protocolHandler.setRecoverThread(Thread.currentThread());
        try {
            this.setRecoverState(3);
            this.recover();
            this.setRecoverState(5);
            this.failedCount = 0;
        }
        catch (JMSException jmse) {
            this.setRecoverState(6);
            this.connLogger.log(Level.WARNING, jmse.toString(), (Object)jmse);
            this.connection.triggerConnectionReconnectFailedEvent(jmse);
            this.checkForMaxRetries();
            this.closeProtocolHandler();
        }
        finally {
            if (this.recoverState == 5) {
                this.connection.triggerConnectionReconnectedEvent();
            }
            this.connection.protocolHandler.setRecoverThread(null);
            this.setRecoverState(0);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("ConnectionRecover end ");
        }
    }

    protected void recover() throws JMSException {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("BEGIN ConnectionRecover.recover()...");
            }
            if (this.connection.isCloseCalled) {
                this.connection.setReconnecting(false);
                return;
            }
            this.checkConnectionConsumers();
            this.resetConnectionConsumers();
            this.resetSessions();
            this.connection.hello(true);
            this.connection.protocolHandler.resetClientID();
            this.addSessions();
            this.addConsumers();
            this.addProducers();
            if (!this.connection.isStopped && this.connection.eventListener == null) {
                this.connection.protocolHandler.start();
            }
            logger.info("ConnectionRecover.recover() SUCCESS!!!");
        }
        catch (JMSException e) {
            if (logger.isTraceEnabled()) {
                logger.trace("ConnectionRecover failed.");
            }
            logger.warn("", e);
            throw e;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace("END ConnectionRecover.recover()!!!");
            }
        }
    }

    private void resetConnectionConsumers() {
        try {
            int size = this.connection.connectionConsumerTable.size();
            for (int i = 0; i < size; ++i) {
                ConnectionConsumerImpl ccImpl = (ConnectionConsumerImpl)this.connection.connectionConsumerTable.get(i);
                ccImpl.getReadQueue().clear();
            }
        }
        catch (Exception e) {
            this.connLogger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    protected void checkConnectionConsumers() throws JMSException {
        if (this.enableCCReconnect) {
            return;
        }
        if (this.connection.connectionConsumerTable.size() > 0) {
            String errorString = AdministeredObject.cr.getKString("C4061");
            IllegalStateException jmse = new IllegalStateException(errorString, "C4061");
            ExceptionHandler.throwJMSException((JMSException)((Object)jmse));
        }
    }

    protected void resetSessions() throws JMSException {
        Enumeration enum2 = this.connection.sessionTable.elements();
        while (enum2.hasMoreElements()) {
            SessionImpl session = (SessionImpl)enum2.nextElement();
            if (!this.enableCCReconnect && session.getMessageListener() != null) {
                String errorString = AdministeredObject.cr.getKString("C4061");
                IllegalStateException jmse = new IllegalStateException(errorString, "C4061");
                ExceptionHandler.throwJMSException((JMSException)((Object)jmse));
            }
            session.reset();
        }
    }

    protected void addSessions() throws JMSException {
        Enumeration enum2 = this.connection.sessionTable.elements();
        while (enum2.hasMoreElements()) {
            SessionImpl session = (SessionImpl)enum2.nextElement();
            session.recreateSession();
        }
    }

    protected void addConsumers() throws JMSException {
        Object[] tmp = this.connection.interestTable.toArray();
        Vector<Object> v = new Vector<Object>();
        for (int i = 0; i < tmp.length; ++i) {
            if (!((Consumer)tmp[i]).isClosed) {
                this.connection.protocolHandler.addInterest((Consumer)tmp[i]);
                continue;
            }
            v.add(tmp[i]);
        }
        while (!v.isEmpty()) {
            Object o = v.firstElement();
            this.connection.interestTable.remove((Consumer)o);
            v.remove(o);
        }
    }

    protected void addProducers() throws JMSException {
        Enumeration enum2 = this.connection.sessionTable.elements();
        while (enum2.hasMoreElements()) {
            SessionImpl session = (SessionImpl)enum2.nextElement();
            this.addSessionProducers(session);
        }
    }

    protected void addSessionProducers(SessionImpl session) throws JMSException {
        Enumeration enum2 = session.producers.elements();
        while (enum2.hasMoreElements()) {
            MessageProducerImpl producer = (MessageProducerImpl)enum2.nextElement();
            producer.recreateProducer();
        }
    }

    protected synchronized void setRecoverState(int state) {
        if (this.recoverState != 7) {
            this.recoverState = state;
            this.logRecoverState(state);
        } else {
            this.logRecoverState(7);
        }
        this.notifyAll();
    }

    public synchronized int getRecoverState() {
        return this.recoverState;
    }

    private void closeProtocolHandler() {
        try {
            this.connection.protocolHandler.close();
        }
        catch (Exception e) {
            logger.warn("", e);
        }
    }

    private void checkForMaxRetries() {
        ++this.failedCount;
        if (this.maxRetries == -1) {
            return;
        }
        if (this.failedCount > this.maxRetries) {
            this.setRecoverState(7);
            if (logger.isTraceEnabled()) {
                logger.trace("*** reached max internal retry count: " + this.maxRetries);
            }
            String msg = AdministeredObject.cr.getKString("I113", this.connection.getBrokerAddressList(), new Integer(this.maxRetries));
            this.connLogger.log(Level.SEVERE, msg);
        }
    }

    public synchronized void waitUntilInactive() throws JMSException {
        JMSException jmse;
        int wcounter = 0;
        int lctr = 0;
        if (this.recoverState == 7) {
            jmse = new JMSException("ConnectionRecover aborted!");
            ExceptionHandler.throwJMSException(jmse);
        }
        while (this.recoverState != 0 && this.recoverState != 7) {
            try {
                this.wait(3000L);
                if (++lctr == 5) {
                    String msg = AdministeredObject.cr.getKString("I107", STATES[this.getRecoverState()], this.connection.getLastContactedBrokerAddress());
                    this.connLogger.log(Level.INFO, msg);
                    lctr = 0;
                }
            }
            catch (Exception e) {
                this.connLogger.log(Level.WARNING, e.toString(), e);
            }
            if (this.connection.isCloseCalled) {
                this.setRecoverState(7);
                return;
            }
            this.connection.readChannel.closeIOAndNotify();
            if (++wcounter <= 200) continue;
            this.setRecoverState(7);
            jmse = new JMSException("Timeout on ConnectionRecover object.  Broker: " + this.connection.getLastContactedBrokerAddress());
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    private void sleep(int sleepTime) {
        try {
            int count = sleepTime / 3000;
            for (int i = 0; i < count; ++i) {
                if (logger.isTraceEnabled()) {
                    logger.trace("*** ConnectionRecover, sleeping {}, milli secs", 3000 * (i + 1));
                }
                Thread.sleep(3000L);
                if (!this.connection.isCloseCalled) continue;
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void logRecoverState(int state) {
        if (this.connLogger.isLoggable(Level.INFO)) {
            String addr = this.connection.getLastContactedBrokerAddress();
            String msg = AdministeredObject.cr.getKString("I107", STATES[state], addr);
            this.connLogger.log(Level.INFO, msg);
        }
    }
}

