/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.io.ReadOnlyPacket;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.ProtocolHandler;
import com.tongtech.tmqi.jmsclient.SessionQueue;
import com.tongtech.tmqi.jmsclient.Traceable;
import java.io.IOException;
import java.io.PrintStream;
import javax.jms.JMSException;

public abstract class ConsumerReader
implements Runnable,
Traceable {
    static Logger logger = LoggerFactory.getLogger(ConsumerReader.class);
    protected Thread sessionThread = null;
    protected ProtocolHandler protocolHandler = null;
    protected ConnectionImpl connection = null;
    protected SessionQueue sessionQueue = null;
    protected boolean isSuspended = false;
    protected boolean isAlive = false;
    protected boolean isPaused = false;
    protected static int nextReaderID = 0;
    protected int readerID = 0;
    protected static final String tmqiConsumerReader = "tmqiConsumerReader-";
    protected long timeout = 0L;

    public ConsumerReader(ConnectionImpl connection, SessionQueue readQueue) {
        this.connection = connection;
        this.sessionQueue = readQueue;
        this.readerID = ConsumerReader.getNextReaderID();
        this.init();
    }

    protected static synchronized int getNextReaderID() {
        return nextReaderID++;
    }

    protected void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void init() {
        this.protocolHandler = this.connection.getProtocolHandler();
    }

    public synchronized void start() {
        if (this.sessionThread == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("starting new sessionThread ...");
            }
            this.sessionThread = new Thread(this);
            if (this.connection.hasDaemonThreads()) {
                this.sessionThread.setDaemon(true);
            }
            this.sessionThread.setName(tmqiConsumerReader + this.connection.getLocalID() + "-" + this.connection.getConnectionID() + "-" + this.readerID);
            this.setIsAlive(true);
            this.setIsSuspended(false);
            this.sessionThread.start();
        } else {
            if (logger.isTraceEnabled()) {
                logger.trace("sessionThread was started already ...");
            }
            this.resume();
        }
    }

    public void handleDeliver(ReadOnlyPacket packet) {
        try {
            if (this.connection.isBroken()) {
                logger.trace("sessionThread received pkt connection.isBroken()", this.connection);
                this.sessionThread = null;
                this.sessionQueue.close();
            } else if (packet != null) {
                logger.trace("ConsumerReader.handleDeliver, received pkt, msgid={}", (Object)packet.getMessageID());
                if (this.getIsAlive()) {
                    this.deliver(packet);
                } else {
                    logger.debug("ConsumerReader.handleDeliver, getIsAlive:false");
                }
            } else {
                logger.trace("sessionThread received pkt is NULL");
                this.deliver();
            }
        }
        catch (Exception e) {
            if (this.connection.isBroken()) {
                this.sessionThread = null;
                this.sessionQueue.close();
            } else if (this.connection.getRecoverInProcess()) {
                this.sessionQueue.clear();
            } else {
                logger.warn("", e);
            }
        }
        catch (Error err) {
            logger.warn("catch a error ,set fatal error :" + err.getMessage());
            this.connection.readChannel.setFatalError(err);
            return;
        }
    }

    @Override
    public void run() {
        ReadOnlyPacket packet = null;
        Thread currentThread = Thread.currentThread();
        if (logger.isTraceEnabled()) {
            logger.trace("**** Consumer Reader wait timeout: " + this.timeout);
        }
        while (this.sessionThread == currentThread) {
            if (logger.isTraceEnabled()) {
                logger.trace("ConsumerReader.run, before  " + this.sessionQueue);
            }
            packet = (ReadOnlyPacket)this.sessionQueue.dequeueWait(this.timeout);
            this.handleDeliver(packet);
            if (!logger.isTraceEnabled()) continue;
            logger.trace("ConsumerReader.run, after");
        }
        if (logger.isTraceEnabled()) {
            logger.trace("sessionReader closed ...");
        }
    }

    protected abstract void deliver(ReadOnlyPacket var1) throws IOException, JMSException;

    protected abstract void deliver() throws IOException, JMSException;

    protected synchronized void stop() {
        if (logger.isTraceEnabled()) {
            logger.trace("session reader stopped ...");
        }
        this.setIsSuspended(true);
    }

    protected synchronized void suspend() {
        if (logger.isTraceEnabled()) {
            logger.trace("session reader suspended ...");
        }
        this.setIsSuspended(true);
    }

    protected synchronized void resume() {
        if (logger.isTraceEnabled()) {
            logger.trace("session reader resumed ...");
        }
        this.setIsSuspended(false);
        this.notifyAll();
    }

    protected synchronized void close() {
        this.setIsAlive(false);
        this.setIsSuspended(false);
        this.sessionThread = null;
        this.sessionQueue.close();
    }

    protected synchronized boolean getIsSuspended() {
        return this.isSuspended;
    }

    protected synchronized boolean getIsAlive() {
        return this.isAlive;
    }

    protected synchronized void setIsSuspended(boolean state) {
        this.isSuspended = state;
    }

    protected synchronized void setIsAlive(boolean state) {
        this.isAlive = state;
    }

    protected synchronized void setIsPaused(boolean state) {
        this.isPaused = state;
    }

    protected synchronized boolean getIsPaused() {
        return this.isPaused;
    }

    @Override
    public void dump(PrintStream ps) {
    }
}

