/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.jms.JMSException;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.AdministeredObject;
import com.tongtech.tmqi.jmsclient.logging.Loggable;

public class ExceptionHandler {
    static Logger logger = LoggerFactory.getLogger(ExceptionHandler.class);
    private static final String cname = "com.tongtech.tmqi.jmsclient.ExceptionHandler";

    public static void handleConnectException(Exception source, String host, int port) throws javax.jms.JMSException {
        String info = "[" + host + ":" + port + "]";
        ExceptionHandler.throwConnectionException(source, info);
    }

    public static void handleConnectException(Exception source, String url) throws javax.jms.JMSException {
        String info = "[" + url + "]";
        ExceptionHandler.throwConnectionException(source, info);
    }

    private static void throwConnectionException(Exception source, String info) throws javax.jms.JMSException {
        if (source instanceof javax.jms.JMSException && ((javax.jms.JMSException)((Object)source)).getErrorCode() != null) {
            ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)source));
        }
        String errorString0 = AdministeredObject.cr.getKString("C4003", info);
        String errorString = AdministeredObject.cr.getString("C4038", errorString0, source.toString());
        JMSException jmse = new JMSException(errorString, "C4003");
        if (ExceptionHandler.shouldLog(jmse)) {
            logger.warn(errorString);
        }
        jmse.setLinkedException(source);
        ExceptionHandler.throwJMSException(jmse);
    }

    public static void handleException(Exception source, String errorCode) throws javax.jms.JMSException {
        ExceptionHandler.handleException(source, errorCode, true);
    }

    public static void handleException(Exception source, String errorCode, boolean format) throws javax.jms.JMSException {
        if (source instanceof javax.jms.JMSException && ((javax.jms.JMSException)((Object)source)).getErrorCode() != null) {
            ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)source));
        }
        ExceptionHandler.handleException(source, ExceptionHandler.getJMSException(source, errorCode, format));
    }

    public static void handleException(Exception source, javax.jms.JMSException target) throws javax.jms.JMSException {
        target.setLinkedException(source);
        if (logger.isTraceEnabled()) {
            logger.trace("", source);
        }
        ExceptionHandler.throwJMSException(target);
    }

    public static void printStackTrace(Exception e) {
        logger.warn("", e);
    }

    public static javax.jms.JMSException getJMSException(Exception source, String errorCode, boolean format) {
        String errorString = null;
        errorString = source == null ? AdministeredObject.cr.getKString(errorCode) : ExceptionHandler.getExceptionMessage(source, errorCode);
        return new JMSException(errorString, errorCode);
    }

    public static String getExceptionMessage(Exception source, String errorCode) {
        String errorString = null;
        if (errorCode == null) {
            errorCode = "C4038";
        }
        if (errorCode == "C4038") {
            errorString = "[" + "C4038" + "]: " + source.toString();
        } else {
            String errorString0 = AdministeredObject.cr.getKString(errorCode);
            errorString = AdministeredObject.cr.getString("C4038", errorString0, source.toString());
        }
        return errorString;
    }

    public static void throwJMSException(javax.jms.JMSException jmse) throws javax.jms.JMSException {
        try {
            if (ExceptionHandler.shouldLog(jmse)) {
                Exception source = jmse.getLinkedException();
                if (source != null) {
                    ExceptionHandler.logCaughtException(source);
                }
                if (jmse.getMessage().indexOf("no space in") >= 0) {
                    logger.warn("Throw JMS Exception: " + jmse.getMessage());
                } else {
                    logger.error("Throw JMS Exception: ", jmse);
                }
            }
        }
        catch (Exception e) {
            logger.error("", e);
        }
        throw jmse;
    }

    private static boolean shouldLog(javax.jms.JMSException jmse) {
        boolean isLoggable = true;
        if (jmse instanceof Loggable) {
            if (((Loggable)((Object)jmse)).getLogState()) {
                isLoggable = false;
            } else {
                ((Loggable)((Object)jmse)).setLogState(true);
            }
        }
        return isLoggable;
    }

    public static void logCaughtException(Throwable source) {
        if (source != null) {
            String msg = AdministeredObject.cr.getKString("I500", source.toString());
            logger.warn(msg);
        }
    }

    public static void logError(Throwable thrown) {
        if (thrown != null) {
            String msg = thrown.toString();
            logger.error(msg, thrown);
        }
    }

    public static void throwRemoteAcknowledgeException(javax.jms.JMSException source, String errorCode) throws javax.jms.JMSException {
        String errorString = AdministeredObject.cr.getKString(errorCode);
        JMSException newjmse = new JMSException(errorString, errorCode);
        if (source != null) {
            newjmse.setLinkedException((Exception)((Object)source));
        }
        ExceptionHandler.throwJMSException(newjmse);
    }
}

