/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.log.JDKLogger;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.jmsclient.ConnectionFlowControlEntry;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.Consumer;
import com.tongtech.tmqi.jmsclient.ConsumerFlowControlEntry;
import com.tongtech.tmqi.jmsclient.ExceptionHandler;
import com.tongtech.tmqi.jmsclient.FlowControlEntry;
import com.tongtech.tmqi.jmsclient.ProtocolHandler;
import com.tongtech.tmqi.jmsclient.Traceable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.jms.JMSException;

public class FlowControl
implements Runnable,
Traceable {
    Logger logger = LoggerFactory.getLogger(FlowControl.class);
    protected ProtocolHandler protocolHandler = null;
    protected ConnectionImpl connection = null;
    protected boolean isClosed = false;
    protected static final String tmqiFlowControl = "tmqiConnectionFlowControl-";
    private Hashtable flowControlTable = null;
    private Hashtable readyQueue = null;
    private static boolean FLOWCONTROL_DEBUG = Boolean.getBoolean("tmqi.flowcontrol.debug");
    private static String FLOWCONTROL_LOG = System.getProperty("tmqi.flowcontrol.log");
    private static PrintStream fdbg = null;
    private long pingInterval = 30000L;
    private static final JDKLogger connLogger = ConnectionImpl.connectionLogger;

    private static void initFlowControlDebug() {
        if (!FLOWCONTROL_DEBUG || fdbg != null) {
            return;
        }
        if (FLOWCONTROL_LOG == null) {
            FLOWCONTROL_LOG = "stderr";
        }
        if (FLOWCONTROL_LOG.equals("stdout")) {
            fdbg = System.out;
        } else if (FLOWCONTROL_LOG.equals("stderr")) {
            fdbg = System.err;
        } else {
            try {
                FileOutputStream fos = new FileOutputStream(FLOWCONTROL_LOG, true);
                fdbg = new PrintStream(fos);
            }
            catch (IOException e) {
                fdbg = System.err;
            }
        }
    }

    public FlowControl(ConnectionImpl conn) {
        this.connection = conn;
        this.pingInterval = conn.getPingInterval();
        this.protocolHandler = this.connection.getProtocolHandler();
        this.readyQueue = new Hashtable();
        this.flowControlTable = new Hashtable();
        FlowControl.initFlowControlDebug();
        this.addConnectionFlowControl(conn);
    }

    private void addConnectionFlowControl(ConnectionImpl connection) {
        ConnectionFlowControlEntry fce = new ConnectionFlowControlEntry(this, connection.getProtocolHandler(), connection.protectMode, connection.flowControlMsgSize, connection.flowControlWaterMark);
        this.flowControlTable.put(connection, fce);
        if (FLOWCONTROL_DEBUG) {
            fdbg.println("Added connection flow control entry : " + connection);
        }
    }

    public void requestConnectionFlowResume() {
        this.requestResume(this.connection);
    }

    public void messageReceived() {
        this.messageReceived(this.connection);
    }

    public void messageDelivered() {
        this.messageDelivered(this.connection);
    }

    public void addConsumerFlowControl(Consumer consumer) {
        ConsumerFlowControlEntry fce = new ConsumerFlowControlEntry(this, consumer.getConnection().getProtocolHandler(), consumer);
        this.flowControlTable.put(consumer, fce);
        if (FLOWCONTROL_DEBUG) {
            fdbg.println("Added flow control entry : " + fce);
        }
    }

    public void removeConsumerFlowControl(Consumer consumer) {
        FlowControlEntry fce = (FlowControlEntry)this.flowControlTable.remove(consumer);
        if (FLOWCONTROL_DEBUG) {
            fdbg.println("Removed flow control entry :" + fce);
        }
    }

    public void requestResume(Object key) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("**** In requestResume. key = {}", key);
        }
        FlowControlEntry fce = this.getFlowControlEntry(key);
        if (FLOWCONTROL_DEBUG) {
            fdbg.println("PAUSED MESSAGE DELIVERY FOR : " + fce);
        }
        if (connLogger.isLoggable(Level.FINEST)) {
            connLogger.log(Level.FINEST, "I103", fce);
        }
        fce.setResumeRequested(true);
    }

    public void messageReceived(Object key) {
        FlowControlEntry fce = this.findFlowControlEntry(key);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("message received: fce: {}, key {}", fce, key);
        }
        if (fce != null) {
            fce.messageReceived();
        }
    }

    public void messageDelivered(Object key) {
        FlowControlEntry fce = this.findFlowControlEntry(key);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("message delivered, fce: {}, key {}", fce, key);
        }
        if (fce != null) {
            fce.messageDelivered();
        }
    }

    public void resetFlowControl(Object key, int count) {
        FlowControlEntry fce = this.findFlowControlEntry(key);
        if (fce != null) {
            fce.resetFlowControl(count);
        }
    }

    public Hashtable getDebugState(Object key) {
        FlowControlEntry fce = this.findFlowControlEntry(key);
        if (fce != null) {
            return fce.getDebugState();
        }
        return null;
    }

    public Object TEST_GetAttribute(String name, Object key) {
        FlowControlEntry fce = this.findFlowControlEntry(key);
        return fce.TEST_GetAttribute(name);
    }

    private FlowControlEntry getFlowControlEntry(Object key) {
        FlowControlEntry fce = (FlowControlEntry)this.flowControlTable.get(key);
        if (fce == null) {
            if (!(key instanceof Consumer) && !(key instanceof ConnectionImpl)) {
                throw new IllegalArgumentException("getFlowControlEntry: Bad key type. key = " + key);
            }
            throw new IllegalStateException("FlowControlEntry not found. key = " + key);
        }
        return fce;
    }

    private FlowControlEntry findFlowControlEntry(Object key) {
        if (key == null) {
            return null;
        }
        FlowControlEntry fce = (FlowControlEntry)this.flowControlTable.get(key);
        return fce;
    }

    public void start() {
        Thread thread = new Thread(this);
        if (this.connection.hasDaemonThreads()) {
            thread.setDaemon(true);
        }
        thread.setName(tmqiFlowControl + this.connection.getLocalID());
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long lastDump = 0L;
        block8: while (true) {
            FlowControlEntry[] rqCopy = null;
            FlowControl flowControl = this;
            synchronized (flowControl) {
                while (!this.isClosed && this.readyQueue.size() == 0) {
                    block18: {
                        try {
                            this.wait(this.pingInterval);
                            if (!this.isClosed && this.readyQueue.size() == 0) {
                                if (this.protocolHandler.getTimeToPing()) {
                                    this.pingBroker();
                                }
                                this.protocolHandler.setTimeToPing(true);
                            }
                        }
                        catch (InterruptedException e) {
                            if (!this.logger.isTraceEnabled()) break block18;
                            this.logger.trace("", e);
                        }
                    }
                    if (!FLOWCONTROL_DEBUG || System.currentTimeMillis() - lastDump <= this.pingInterval) continue;
                    this.status_report();
                    lastDump = System.currentTimeMillis();
                }
                if (this.isClosed) {
                    break;
                }
                rqCopy = this.readyQueue.values().toArray(new FlowControlEntry[0]);
            }
            try {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("flowControl sendResumeFlow ");
                }
                int i = 0;
                while (true) {
                    if (i >= rqCopy.length) continue block8;
                    rqCopy[i].sendResumeFlow();
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("SENDING RESUME_FLOW FOR : " + rqCopy[i]);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                if (this.connection.isClosed) {
                    this.isClosed = true;
                    break;
                }
                if (!this.logger.isTraceEnabled()) continue;
                this.logger.trace("", e);
                continue;
            }
            catch (Error e) {
                e.printStackTrace();
                ExceptionHandler.logError(e);
                continue;
            }
            break;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("FlowControl exit 4...");
        }
    }

    private void pingBroker() {
        block2: {
            try {
                this.protocolHandler.ping();
            }
            catch (JMSException e) {
                if (!this.logger.isTraceEnabled()) break block2;
                this.logger.trace("", e);
            }
        }
    }

    private void status_report() {
        fdbg.println("debug_interval = " + this.pingInterval);
        fdbg.println("\n-------------------------------- " + this + " : " + new Date());
        Enumeration enum2 = this.flowControlTable.elements();
        while (enum2.hasMoreElements()) {
            FlowControlEntry fce = (FlowControlEntry)enum2.nextElement();
            fce.status_report(fdbg);
        }
    }

    protected synchronized void addToReadyQueue(FlowControlEntry fce) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("In addToReadyQueue : " + fce);
        }
        this.readyQueue.put(fce, fce);
        this.notifyAll();
    }

    protected synchronized void removeFromReadyQueue(FlowControlEntry fce) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("In removeFromReadyQueue : " + fce);
        }
        this.readyQueue.remove(fce);
    }

    public synchronized void close() {
        this.isClosed = true;
        this.notifyAll();
    }

    @Override
    public void dump(PrintStream ps) {
    }
}

