/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.jms.spi.xa.JMSXAConnection;
import com.tongtech.jms.spi.xa.JMSXAConnectionFactory;
import com.tongtech.jms.spi.xa.JMSXAQueueConnection;
import com.tongtech.jms.spi.xa.JMSXAQueueConnectionFactory;
import com.tongtech.jms.spi.xa.JMSXASession;
import com.tongtech.jms.spi.xa.JMSXATopicConnection;
import com.tongtech.jms.spi.xa.JMSXATopicConnectionFactory;
import com.tongtech.tmqi.AdministeredObject;
import com.tongtech.tmqi.jmsclient.JMSXAWrappedConnectionFactoryImpl;
import com.tongtech.tmqi.jmsclient.JMSXAWrappedTransactionListener;
import com.tongtech.tmqi.jmsclient.XAResourceImpl;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class JMSXAWrappedXAResourceImpl
implements XAResource {
    private static final boolean debug = JMSXAWrappedConnectionFactoryImpl.debug;
    private XAResource xar;
    private JMSXAConnectionFactory cf = null;
    private boolean isQueue;
    private String username = null;
    private String password = null;
    private boolean closed = false;
    private JMSXAWrappedTransactionListener listener = null;

    public JMSXAWrappedXAResourceImpl(XAResource xar, boolean isQueue, JMSXAConnectionFactory cf, String username, String password) {
        this.xar = xar;
        this.cf = cf;
        this.isQueue = isQueue;
        this.username = username;
        this.password = password;
    }

    protected void setTransactionListener(JMSXAWrappedTransactionListener l) {
        this.listener = l;
    }

    protected void close() {
        this.closed = true;
    }

    @Override
    public void commit(Xid foreignXid, boolean onePhase) throws XAException {
        if (!this.closed || this.xar instanceof XAResourceImpl) {
            JMSXAWrappedXAResourceImpl.dlog("commit(Xid=" + foreignXid + " onePhase=" + onePhase + "), closed=" + this.closed);
            boolean completed = false;
            try {
                if (this.listener != null) {
                    this.listener.beforeTransactionComplete();
                }
                this.xar.commit(foreignXid, onePhase);
                completed = true;
            }
            catch (XAException e) {
                switch (e.errorCode) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        completed = false;
                        break;
                    }
                    case 4: {
                        completed = false;
                        break;
                    }
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: {
                        completed = true;
                        break;
                    }
                    default: {
                        completed = true;
                    }
                }
                throw e;
            }
            finally {
                if (this.listener != null) {
                    this.listener.afterTransactionComplete(foreignXid, completed);
                }
            }
        }
        JMSXAConnection c = null;
        try {
            JMSXAWrappedXAResourceImpl.dlog("closed commit() ...");
            c = this.getConnection();
            XAResource r = this.getXAResource(c);
            JMSXAWrappedXAResourceImpl.dlog("closed commit(Xid=" + foreignXid + " onePhase=" + onePhase + ")");
            r.commit(foreignXid, onePhase);
        }
        catch (JMSException e) {
            JMSXAWrappedXAResourceImpl.log("Error:", (Exception)((Object)e));
            throw new XAException(-7);
        }
        finally {
            if (c != null) {
                try {
                    c.close();
                }
                catch (Exception e) {
                    JMSXAWrappedXAResourceImpl.log(AdministeredObject.cr.getKString("W2002"), "commit():Connection.close(): " + e.getMessage());
                }
            }
        }
    }

    @Override
    public void end(Xid foreignXid, int flags) throws XAException {
        boolean completed = false;
        try {
            if (this.listener != null) {
                this.listener.beforeTransactionComplete();
            }
            this.xar.end(foreignXid, flags);
        }
        catch (XAException e) {
            switch (e.errorCode) {
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    completed = false;
                    break;
                }
                default: {
                    completed = true;
                }
            }
            throw e;
        }
        finally {
            if (this.listener != null) {
                this.listener.afterTransactionComplete(foreignXid, completed);
            }
        }
    }

    @Override
    public void forget(Xid foreignXid) throws XAException {
        if (!this.closed || this.xar instanceof XAResourceImpl) {
            JMSXAWrappedXAResourceImpl.dlog("forget(Xid=" + foreignXid + "), closed=" + this.closed);
            boolean completed = false;
            try {
                if (this.listener != null) {
                    this.listener.beforeTransactionComplete();
                }
                this.xar.forget(foreignXid);
                completed = true;
            }
            finally {
                if (this.listener != null) {
                    this.listener.afterTransactionComplete(foreignXid, completed);
                }
            }
        }
        JMSXAConnection c = null;
        try {
            JMSXAWrappedXAResourceImpl.dlog("closed forget(Xid=" + foreignXid + ")");
            c = this.getConnection();
            XAResource r = this.getXAResource(c);
            r.forget(foreignXid);
        }
        catch (JMSException e) {
            JMSXAWrappedXAResourceImpl.log("Error:", (Exception)((Object)e));
            throw new XAException(-7);
        }
        finally {
            if (c != null) {
                try {
                    c.close();
                }
                catch (Exception e) {
                    JMSXAWrappedXAResourceImpl.log(AdministeredObject.cr.getKString("W2002"), "forget():Connection.close(): " + e.getMessage());
                }
            }
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.xar.getTransactionTimeout();
    }

    @Override
    public boolean isSameRM(XAResource foreignXaRes) throws XAException {
        JMSXAWrappedXAResourceImpl.dlog(this.xar.getClass().getName() + ".isSameRM(" + foreignXaRes.getClass().getName() + ")");
        return this.xar.isSameRM(foreignXaRes);
    }

    @Override
    public int prepare(Xid foreignXid) throws XAException {
        if (!this.closed || this.xar instanceof XAResourceImpl) {
            JMSXAWrappedXAResourceImpl.dlog("prepare(Xid=" + foreignXid + "), closed=" + this.closed);
            boolean completed = false;
            int ret = 0;
            try {
                if (this.listener != null) {
                    this.listener.beforeTransactionComplete();
                }
                if ((ret = this.xar.prepare(foreignXid)) == 3) {
                    completed = true;
                }
                int n = ret;
                return n;
            }
            catch (XAException e) {
                switch (e.errorCode) {
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: {
                        completed = true;
                        break;
                    }
                    default: {
                        completed = true;
                    }
                }
                throw e;
            }
            finally {
                if (this.listener != null) {
                    this.listener.afterTransactionComplete(foreignXid, completed);
                }
            }
        }
        JMSXAConnection c = null;
        try {
            JMSXAWrappedXAResourceImpl.dlog("closed prepare(Xid=" + foreignXid + ")");
            c = this.getConnection();
            XAResource r = this.getXAResource(c);
            int n = r.prepare(foreignXid);
            return n;
        }
        catch (JMSException e) {
            JMSXAWrappedXAResourceImpl.log("Error:", (Exception)((Object)e));
            throw new XAException(-7);
        }
        finally {
            if (c != null) {
                try {
                    c.close();
                }
                catch (Exception e) {
                    JMSXAWrappedXAResourceImpl.log(AdministeredObject.cr.getKString("W2002"), "prepare():Connection.close():" + e.getMessage());
                }
            }
        }
    }

    @Override
    public Xid[] recover(int flags) throws XAException {
        return this.xar.recover(flags);
    }

    @Override
    public void rollback(Xid foreignXid) throws XAException {
        if (!this.closed || this.xar instanceof XAResourceImpl) {
            JMSXAWrappedXAResourceImpl.dlog("rollback(Xid=" + foreignXid + "), closed=" + this.closed);
            boolean completed = false;
            try {
                if (this.listener != null) {
                    this.listener.beforeTransactionComplete();
                }
                this.xar.rollback(foreignXid);
                completed = true;
            }
            catch (XAException e) {
                switch (e.errorCode) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        completed = false;
                        break;
                    }
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: {
                        completed = true;
                        break;
                    }
                    default: {
                        completed = true;
                    }
                }
                throw e;
            }
            finally {
                if (this.listener != null) {
                    this.listener.afterTransactionComplete(foreignXid, completed);
                }
            }
        }
        JMSXAConnection c = null;
        try {
            JMSXAWrappedXAResourceImpl.dlog("closed rollback() ...");
            c = this.getConnection();
            XAResource r = this.getXAResource(c);
            JMSXAWrappedXAResourceImpl.dlog("closed rollback(Xid=" + foreignXid + ")");
            r.rollback(foreignXid);
        }
        catch (JMSException e) {
            JMSXAWrappedXAResourceImpl.log("Error:", (Exception)((Object)e));
            throw new XAException(-7);
        }
        finally {
            if (c != null) {
                try {
                    c.close();
                }
                catch (Exception e) {
                    JMSXAWrappedXAResourceImpl.log(AdministeredObject.cr.getKString("W2002"), "rollback():Connection.close():" + e.getMessage());
                }
            }
        }
    }

    @Override
    public boolean setTransactionTimeout(int transactionTimeout) throws XAException {
        return this.xar.setTransactionTimeout(transactionTimeout);
    }

    @Override
    public void start(Xid foreignXid, int flags) throws XAException {
        boolean started = false;
        try {
            if (this.listener != null) {
                this.listener.beforeTransactionStart();
            }
            this.xar.start(foreignXid, flags);
            if (flags == 0) {
                started = true;
            }
        }
        catch (JMSException e) {
            JMSXAWrappedXAResourceImpl.log("Error:", (Exception)((Object)e));
            throw new XAException(-7);
        }
        catch (XAException e) {
            switch (e.errorCode) {
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    started = false;
                    break;
                }
                default: {
                    started = false;
                }
            }
            throw e;
        }
        finally {
            if (this.listener != null) {
                this.listener.afterTransactionStart(foreignXid, started);
            }
        }
    }

    private JMSXAConnection getConnection() throws JMSException {
        JMSXAConnection c = null;
        c = this.isQueue ? (this.username == null ? ((JMSXAQueueConnectionFactory)this.cf).createXAQueueConnection() : ((JMSXAQueueConnectionFactory)this.cf).createXAQueueConnection(this.username, this.password)) : (this.username == null ? ((JMSXATopicConnectionFactory)this.cf).createXATopicConnection() : ((JMSXATopicConnectionFactory)this.cf).createXATopicConnection(this.username, this.password));
        return c;
    }

    public XAResource getDelegatedXAResource() {
        return this.xar;
    }

    private XAResource getXAResource(JMSXAConnection c) throws JMSException, XAException {
        JMSXASession s = this.isQueue ? ((JMSXAQueueConnection)c).createXAQueueSession(true, 1) : ((JMSXATopicConnection)c).createXATopicSession(true, 1);
        XAResource r = s.getXAResource();
        String rc = null;
        rc = r instanceof JMSXAWrappedXAResourceImpl ? ((JMSXAWrappedXAResourceImpl)r).getDelegatedXAResource().getClass().getName() : r.getClass().getName();
        boolean skip = JMSXAWrappedXAResourceImpl.isSystemPropertySetFor("skipIsSameRMCheckForExternalJMSXAResource", rc);
        if (r.isSameRM(this.xar)) {
            JMSXAWrappedXAResourceImpl.dlog("isSameRM() true - " + this.xar.getClass().getName());
            try {
                int t = this.xar.getTransactionTimeout();
                if (t >= 0) {
                    r.setTransactionTimeout(t);
                }
            }
            catch (Exception e) {
                JMSXAWrappedXAResourceImpl.log(AdministeredObject.cr.getKString("W2002"), "get/setTransactionTimeout(): " + e.getMessage());
            }
        } else {
            if (!skip) {
                JMSXAWrappedXAResourceImpl.log("Error:", "isSameRM() false - " + this.xar.getClass().getName());
                throw new XAException(-7);
            }
            JMSXAWrappedXAResourceImpl.log(AdministeredObject.cr.getKString("W2002"), "isSameRM() false, ignore.  - " + this.xar.getClass().getName());
        }
        return r;
    }

    public static boolean isSystemPropertySetFor(String propName, String propValue) {
        boolean isSet = false;
        String values = System.getProperty(propName);
        if (values == null) {
            return false;
        }
        StringTokenizer token = new StringTokenizer(values, ",");
        try {
            while (token.hasMoreTokens()) {
                if (!propValue.equals(token.nextToken().trim())) continue;
                isSet = true;
                break;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return isSet;
    }

    private static final void dlog(String msg) {
        if (debug) {
            JMSXAWrappedXAResourceImpl.log("Info:", msg);
        }
    }

    private static final void dlogStack(Exception e) {
        if (debug) {
            e.printStackTrace();
        }
    }

    private static final void log(String level, Exception e) {
        JMSXAWrappedXAResourceImpl.log(level, e.getMessage());
        e.printStackTrace();
    }

    private static final void log(String level, String msg) {
        System.out.println(level + " " + "JMSXAWrappedXAResource: " + msg);
    }
}

