/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.AdministeredObject;
import com.tongtech.tmqi.jmsclient.BrowserConsumer;
import com.tongtech.tmqi.jmsclient.MessageImpl;
import com.tongtech.tmqi.jmsclient.QueueBrowserImpl;
import com.tongtech.tmqi.jmsclient.ReceiveQueue;
import java.util.List;
import java.util.NoSuchElementException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;

public class LocalBrowserConsumer
extends BrowserConsumer {
    static Logger logger = LoggerFactory.getLogger(LocalBrowserConsumer.class);
    private List messageIDList;

    public LocalBrowserConsumer(QueueBrowserImpl browser, Destination dest, String messageSelector) throws JMSException {
        super(browser, dest, messageSelector);
    }

    @Override
    protected void init() throws JMSException {
        this.receiveQueue = new ReceiveQueue();
        this.messageIDs = this.session.getMessageIdSet(this);
        this.cursorEnd = this.messageIDs.length - 1;
        this.cursor = 0;
        this.addInterest();
        this.waitCounter = 0;
        this.moreMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMoreElements() {
        if (this.receiveQueue.getIsClosed()) {
            String errorString = AdministeredObject.cr.getKString("C4046");
            throw new NoSuchElementException(errorString);
        }
        LocalBrowserConsumer localBrowserConsumer = this;
        synchronized (localBrowserConsumer) {
            return this.waitCounter != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object nextElement() {
        Message message = null;
        LocalBrowserConsumer localBrowserConsumer = this;
        synchronized (localBrowserConsumer) {
            if (!this.hasMoreElements()) {
                String errorString = AdministeredObject.cr.getKString("C4045");
                throw new NoSuchElementException(errorString);
            }
            try {
                message = this.receive(this.browseTimeout);
                if (message != null && this.isLast((MessageImpl)message)) {
                    --this.waitCounter;
                    this.moreMessage();
                }
            }
            catch (JMSException e) {
                this.close();
                throw new NoSuchElementException(e.getMessage());
            }
        }
        if (message == null) {
            String errorString;
            if (this.receiveQueue.getIsClosed()) {
                errorString = AdministeredObject.cr.getKString("C4046");
                throw new NoSuchElementException(errorString);
            }
            this.close();
            errorString = AdministeredObject.cr.getKString("C4044");
            throw new NoSuchElementException(errorString);
        }
        return message;
    }
}

