/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.tmqi.jmsclient.BytesMessageImpl;
import com.tongtech.tmqi.jmsclient.ExceptionHandler;
import com.tongtech.tmqi.jmsclient.MapMessageImpl;
import com.tongtech.tmqi.jmsclient.MessageImpl;
import com.tongtech.tmqi.jmsclient.ObjectMessageImpl;
import com.tongtech.tmqi.jmsclient.StreamMessageImpl;
import com.tongtech.tmqi.jmsclient.TextMessageImpl;
import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;

public class MessageConvert {
    protected static final MessageConvert messageConvert = new MessageConvert();

    public static synchronized MessageConvert getInstance() {
        return messageConvert;
    }

    protected Message convertJMSMessage(Message foreignMessage, int protocolType) throws JMSException {
        Object message = null;
        message = foreignMessage instanceof TextMessage ? this.convertTextMessage((TextMessage)foreignMessage, protocolType) : (foreignMessage instanceof MapMessage ? this.convertMapMessage((MapMessage)foreignMessage, protocolType) : (foreignMessage instanceof BytesMessage ? this.convertBytesMessage((BytesMessage)foreignMessage, protocolType) : (foreignMessage instanceof ObjectMessage ? this.convertObjectMessage((ObjectMessage)foreignMessage, protocolType) : (foreignMessage instanceof StreamMessage ? this.convertStreamMessage((StreamMessage)foreignMessage, protocolType) : new MessageImpl(protocolType)))));
        this.convertJMSHeader((Message)message, foreignMessage);
        this.convertJMSProperties((Message)message, foreignMessage);
        return message;
    }

    protected void convertJMSHeader(Message message, Message foreignMessage) throws JMSException {
        message.setJMSCorrelationID(foreignMessage.getJMSCorrelationID());
        message.setJMSType(message.getJMSType());
    }

    protected void resetForeignMessageHeader(Message message, Message foreignMessage) throws JMSException {
        foreignMessage.setJMSDeliveryMode(message.getJMSDeliveryMode());
        foreignMessage.setJMSExpiration(message.getJMSExpiration());
        foreignMessage.setJMSMessageID(message.getJMSMessageID());
        foreignMessage.setJMSPriority(message.getJMSPriority());
        foreignMessage.setJMSTimestamp(message.getJMSTimestamp());
        foreignMessage.setJMSDestination(message.getJMSDestination());
    }

    protected void convertJMSProperties(Message message, Message foreignMessage) throws JMSException {
        Enumeration keys = foreignMessage.getPropertyNames();
        String key = null;
        Object value = null;
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            value = foreignMessage.getObjectProperty(key);
            message.setObjectProperty(key, value);
        }
    }

    protected Message convertTextMessage(TextMessage foreignMessage, int protocolType) throws JMSException {
        TextMessageImpl message = new TextMessageImpl(protocolType);
        message.setText(foreignMessage.getText());
        return message;
    }

    protected Message convertMapMessage(MapMessage foreignMessage, int protocolType) throws JMSException {
        MapMessageImpl message = new MapMessageImpl(protocolType);
        String key = null;
        Enumeration keys = foreignMessage.getMapNames();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            message.setObject(key, foreignMessage.getObject(key));
        }
        return message;
    }

    protected Message convertBytesMessage(BytesMessage foreignMessage, int protocolType) throws JMSException {
        BytesMessageImpl message = new BytesMessageImpl(true, protocolType);
        byte b = 0;
        foreignMessage.reset();
        try {
            while (true) {
                b = foreignMessage.readByte();
                message.writeByte(b);
            }
        }
        catch (MessageEOFException messageEOFException) {
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4070");
        }
        return message;
    }

    protected Message convertObjectMessage(ObjectMessage foreignMessage, int protocolType) throws JMSException {
        ObjectMessageImpl message = new ObjectMessageImpl(protocolType);
        message.setObject(foreignMessage.getObject());
        return message;
    }

    protected Message convertStreamMessage(StreamMessage foreignMessage, int protocolType) throws JMSException {
        StreamMessageImpl message = new StreamMessageImpl(true, protocolType);
        Object obj = null;
        foreignMessage.reset();
        try {
            while (true) {
                obj = foreignMessage.readObject();
                message.writeObject(obj);
            }
        }
        catch (MessageEOFException messageEOFException) {
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4070");
        }
        return message;
    }
}

