/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.jms.Message;
import com.tongtech.jms.util.InjectorUtil;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tlq.gmssl.GmSSL;
import com.tongtech.tmqi.AdministeredObject;
import com.tongtech.tmqi.BasicQueue;
import com.tongtech.tmqi.BasicTopic;
import com.tongtech.tmqi.Destination;
import com.tongtech.tmqi.io.JMQByteArrayOutputStream;
import com.tongtech.tmqi.io.ReadWritePacket;
import com.tongtech.tmqi.io.SysMessageID;
import com.tongtech.tmqi.jmsclient.ExceptionHandler;
import com.tongtech.tmqi.jmsclient.SessionImpl;
import com.tongtech.tmqi.jmsclient.TemporaryQueueImpl;
import com.tongtech.tmqi.jmsclient.TemporaryTopicImpl;
import com.tongtech.tmqi.jmsclient.Traceable;
import com.tongtech.tmqi.jmsclient.ValueConvert;
import com.tongtech.tmqi.jmsclient.zip.Compressor;
import com.tongtech.tmqi.jmsclient.zip.Decompressor;
import com.tongtech.tmqi.util.Hex;
import com.tongtech.tmqi.util.TupleOutput;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;

public class MessageImpl
implements javax.jms.Message,
Message,
Traceable {
    public static final String ENCODER_PREFIX = "__TONGTECH__";
    public static final String ENCODER_POSTFIX = "__:ID:__";
    public static final String UTF8 = "UTF8";
    static Logger logger = LoggerFactory.getLogger(MessageImpl.class);
    protected Hashtable properties = null;
    protected ReadWritePacket pkt = null;
    protected boolean readMode = false;
    protected boolean propReadMode = false;
    protected SessionImpl session = null;
    protected SysMessageID messageID = null;
    protected String msgId = null;
    protected String fixedMessageID = null;
    protected long seqId;
    protected long interestID = 0L;
    protected long producerID = 0L;
    protected boolean isOnAckList = false;
    protected boolean isQBrowserMsg = false;
    protected boolean doAcknowledge = true;
    protected boolean consumerInRA = false;
    protected javax.jms.Destination destination = null;
    protected javax.jms.Destination replyTo = null;
    protected boolean jmsMessageIDSet = false;
    protected String jmsMessageID = null;
    public boolean shouldCompress = false;
    public static final String JMS_TONG_COMPRESS = "JMS_TONG_COMPRESS";
    public static final String JMS_TONG_UNCOMPRESSED_SIZE = "JMS_TONG_UNCOMPRESSED_SIZE";
    public static final String JMS_TONG_COMPRESSED_SIZE = "JMS_TONG_COMPRESSED_SIZE";
    private TupleOutput realAckMsgInfo = null;
    public static final String JMS_TONG_SM4_ID = "JMS_TONG_SM4_ID";
    public static final String JMS_TONG_SM4_LEN = "JMS_TONG_SM4_LEN";
    private static String sm4cihper = "SMS4-CBC";
    private static byte[] iv = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8};

    public void setSession(SessionImpl session) {
        this.session = session;
        if (session.setJMSXConsumerTXID && session.transaction != null) {
            if (this.properties == null) {
                this.properties = new Hashtable();
            }
            this.properties.put("JMSXConsumerTXID", String.valueOf(session.transaction.getTransactionID()));
        }
    }

    public Hashtable getMessageProperties() {
        return this.properties;
    }

    public SessionImpl _getSession() {
        return this.session;
    }

    public void setPacket(ReadWritePacket pkt) {
        this.pkt = pkt;
    }

    public ReadWritePacket getPacket() {
        return this.pkt;
    }

    public void setMessageBodyToPacket() throws JMSException {
    }

    public void getMessageBodyFromPacket() throws JMSException {
    }

    public void setPropertiesToPacket() throws JMSException {
        try {
            this.pkt.setProperties(this.properties);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4006", true);
        }
    }

    public void getPropertiesFromPacket() throws JMSException {
        try {
            this.properties = this.pkt.getProperties();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4005", true);
        }
    }

    protected void setMessageBody(byte[] messageBody) {
        this.pkt.setMessageBody(messageBody);
    }

    protected InputStream getMessageBodyStream() {
        return this.pkt.getMessageBodyStream();
    }

    protected byte[] getMessageBody() throws JMSException {
        if (this.pkt.getFlag(1024)) {
            this.decompress();
        }
        byte[] body = this.pkt.getMessageBody();
        this.pkt.setMessageBody(null);
        return body;
    }

    public void compress() throws JMSException {
        try {
            byte[] body = this.pkt.getMessageBody();
            int offset = this.pkt.getMessageBodyOffset();
            int unzipSize = this.pkt.getMessageBodyLength();
            if (body == null) {
                this.setProperty(JMS_TONG_UNCOMPRESSED_SIZE, new Integer(0));
                this.setProperty(JMS_TONG_COMPRESSED_SIZE, new Integer(0));
                return;
            }
            JMQByteArrayOutputStream baos = new JMQByteArrayOutputStream(new byte[32]);
            Compressor compressor = Compressor.getInstance();
            compressor.compress(body, offset, unzipSize, baos);
            baos.flush();
            byte[] zipbody = baos.getBuf();
            int zipSize = baos.getCount();
            baos.close();
            this.pkt.setMessageBody(zipbody, 0, zipSize);
            this.setProperty(JMS_TONG_UNCOMPRESSED_SIZE, new Integer(unzipSize));
            this.setProperty(JMS_TONG_COMPRESSED_SIZE, new Integer(zipSize));
            this.pkt.setFlag(1024, true);
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            JMSException jmse = new JMSException(ioe.toString());
            jmse.setLinkedException(ioe);
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    protected void decompress() throws JMSException {
        Decompressor decomp = Decompressor.getInstance();
        byte[] zipBody = this.pkt.getMessageBody();
        int unzipSize = this.getIntProperty(JMS_TONG_UNCOMPRESSED_SIZE);
        byte[] unzipBody = new byte[unzipSize];
        decomp.decompress(zipBody, unzipBody);
        this.pkt.setMessageBody(unzipBody, 0, unzipSize);
        this.pkt.setFlag(1024, false);
        this.shouldCompress = true;
    }

    private void checkValidPropertyName(String name) throws JMSException {
        char[] namechars;
        if ("NULL".equalsIgnoreCase(name) || "TRUE".equalsIgnoreCase(name) || "FALSE".equalsIgnoreCase(name) || "NOT".equalsIgnoreCase(name) || "AND".equalsIgnoreCase(name) || "OR".equalsIgnoreCase(name) || "BETWEEN".equalsIgnoreCase(name) || "LIKE".equalsIgnoreCase(name) || "IN".equalsIgnoreCase(name) || "IS".equalsIgnoreCase(name) || "ESCAPE".equalsIgnoreCase(name)) {
            String errorString = AdministeredObject.cr.getKString("C4041", name);
            JMSException jmse = new JMSException(errorString, "C4041");
            ExceptionHandler.throwJMSException(jmse);
        }
        if (Character.isJavaIdentifierStart((namechars = name.toCharArray())[0])) {
            for (int i = 1; i < namechars.length; ++i) {
                if (Character.isJavaIdentifierPart(namechars[i])) continue;
                String errorString = AdministeredObject.cr.getKString("C4043", String.valueOf(namechars[i]));
                JMSException jmse = new JMSException(errorString, "C4043");
                ExceptionHandler.throwJMSException(jmse);
            }
        } else {
            String errorString = AdministeredObject.cr.getKString("C4042", String.valueOf(namechars[0]));
            JMSException jmse = new JMSException(errorString, "C4042");
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    protected void checkAndSetProperty(String name, Object value) throws JMSException {
        MessageNotWriteableException jmse;
        String errorString;
        if (name == null || "".equals(name)) {
            String errorString2 = AdministeredObject.cr.getKString("C4072");
            throw new IllegalArgumentException("C4072" + errorString2);
        }
        if (this.propReadMode) {
            errorString = AdministeredObject.cr.getKString("C4011");
            jmse = new MessageNotWriteableException(errorString, "C4011");
            ExceptionHandler.throwJMSException((JMSException)jmse);
        }
        if (value == null) {
            value = "";
        }
        if (!(value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String)) {
            errorString = AdministeredObject.cr.getKString("C4040");
            errorString = errorString + ", " + name + ", " + value;
            jmse = new MessageFormatException(errorString, "C4040");
            ExceptionHandler.throwJMSException((JMSException)jmse);
        }
        this.checkValidPropertyName(name);
        this.setProperty(name, value);
    }

    private void setProperty(String name, Object value) {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put(name, value);
    }

    protected void checkMessageAccess() throws JMSException {
        if (this.readMode) {
            String errorString = AdministeredObject.cr.getKString("C4008");
            MessageNotWriteableException jmse = new MessageNotWriteableException(errorString, "C4008");
            ExceptionHandler.throwJMSException((JMSException)jmse);
        }
    }

    protected void checkReadAccess() throws JMSException {
        if (!this.readMode) {
            String errorString = AdministeredObject.cr.getKString("C4009");
            MessageNotReadableException jmse = new MessageNotReadableException(errorString, "C4009");
            ExceptionHandler.throwJMSException((JMSException)jmse);
        }
    }

    public void setMessageReadMode(boolean state) {
        this.readMode = state;
    }

    public void setPropertiesReadMode(boolean state) {
        this.propReadMode = state;
    }

    protected void setIsOnAckList(boolean state) {
        this.isOnAckList = state;
    }

    protected boolean getIsOnAckList() {
        return this.isOnAckList;
    }

    public static byte[] fixKey(byte[] key) {
        byte[] out = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8};
        if (key == null) {
            return out;
        }
        if (key.length >= out.length) {
            System.arraycopy(key, 0, out, 0, out.length);
        } else {
            System.arraycopy(key, 0, out, 0, key.length);
        }
        return out;
    }

    public byte[] getKeyById(String id) {
        String key = GmSSL.keychains.get(id);
        if (key == null) {
            return null;
        }
        return MessageImpl.fixKey(key.getBytes());
    }

    public byte[] sm4crypt(byte[] in, String id) throws JMSException {
        byte[] key = this.getKeyById(id);
        if (key == null) {
            throw new JMSException("SM4 get password by id error");
        }
        byte[] out = null;
        if (key != null && (out = GmSSL.symmetricEncrypt(sm4cihper, in, key, iv)) == null) {
            String[] errors = GmSSL.getErrorStrings();
            if (errors != null) {
                throw new JMSException("SM4 encrypt :" + errors[0]);
            }
            throw new JMSException("SM4 encrypt error");
        }
        return out;
    }

    public byte[] sm4cryptWithKey(byte[] in, String password) throws JMSException {
        byte[] key = MessageImpl.fixKey(password.getBytes());
        if (key == null) {
            throw new JMSException("SM4 get password error");
        }
        byte[] out = null;
        if (key != null && (out = GmSSL.symmetricEncrypt(sm4cihper, in, key, iv)) == null) {
            String[] errors = GmSSL.getErrorStrings();
            if (errors != null) {
                throw new JMSException("SM4 encrypt :" + errors[0]);
            }
            throw new JMSException("SM4 encrypt error");
        }
        return out;
    }

    public byte[] sm4decrypt(byte[] in, String id) throws JMSException {
        byte[] key = this.getKeyById(id);
        if (key == null) {
            throw new JMSException("SM4 get password by id error");
        }
        byte[] out = null;
        if (key != null && (out = GmSSL.symmetricDecrypt(sm4cihper, in, key, iv)) == null) {
            String[] errors = GmSSL.getErrorStrings();
            if (errors != null) {
                throw new JMSException("SM4 encrypt :" + errors[0]);
            }
            throw new JMSException("SM4 encrypt error");
        }
        return out;
    }

    private MessageImpl() throws JMSException {
    }

    public MessageImpl(int protocolType) throws JMSException {
        this.init(protocolType);
    }

    public void setMessageID(SysMessageID mID) {
        this.messageID = (SysMessageID)mID.clone();
    }

    public SysMessageID getMessageID() {
        return this.messageID;
    }

    public long getInterestID() {
        return this.interestID;
    }

    public void setInterestID(long id) {
        this.interestID = id;
    }

    protected javax.jms.Destination getJMQDestination(String destName) throws JMSException {
        Destination dest = null;
        boolean isQ = this.pkt.getIsQueue();
        dest = destName.startsWith("t_d__q_") ? new TemporaryQueueImpl(destName) : (destName.startsWith("t_d__t_") ? new TemporaryTopicImpl(destName) : (isQ ? new BasicQueue(destName) : new BasicTopic(destName)));
        return dest;
    }

    private void init(int protocolType) throws JMSException {
        InjectorUtil.init();
        this.pkt = InjectorUtil.createReadWritePacket(protocolType);
        this.setJMSDeliveryMode(2);
        this.setJMSPriority(4);
        this.setJMSExpiration(0L);
        this.setPacketType(6);
    }

    protected void setPacketType(int type) {
        this.pkt.setPacketType(type);
    }

    public boolean getSendAcknowledge() {
        return this.pkt.getSendAcknowledge();
    }

    public String getJMSMessageID() throws JMSException {
        if (this.jmsMessageIDSet) {
            return this.jmsMessageID;
        }
        String s = this.pkt.getMessageID();
        if (s == null || s.equals("")) {
            return "";
        }
        if (s.startsWith(ENCODER_PREFIX) && s.endsWith(ENCODER_POSTFIX)) {
            String encoderStr = s.substring(ENCODER_PREFIX.length(), s.length() - ENCODER_POSTFIX.length());
            if (logger.isDebugEnabled()) {
                logger.debug("IBMMQ getJMSMessageID: {}", (Object)encoderStr);
            }
            String str = null;
            try {
                str = new String(Hex.decodeHex(encoderStr.toCharArray()), "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                logger.error("", ex);
            }
            Object obj = this.properties.get("tlqmsgidlen");
            if (obj == null) {
                return str;
            }
            int len = (Integer)obj;
            return str.substring(0, len);
        }
        if (s.startsWith("ID:")) {
            return s;
        }
        return "ID:" + s;
    }

    public void setJMSMessageID(String id) throws JMSException {
        this.jmsMessageID = id;
        this.jmsMessageIDSet = true;
    }

    public void resetJMSMessageID() {
        this.jmsMessageIDSet = false;
    }

    public long getJMSTimestamp() throws JMSException {
        return this.pkt.getTimestamp();
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.pkt.setTimestamp(timestamp);
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        byte[] ret = null;
        try {
            ret = this.pkt.getCorrelationID().getBytes(UTF8);
        }
        catch (Exception e) {
            logger.trace(e.toString());
            throw new com.tongtech.jms.JMSException("getJMSCorrelationIDAsBytes", "", e);
        }
        return ret;
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        try {
            String id = new String(correlationID, UTF8);
            this.pkt.setCorrelationID(id);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4038");
        }
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        this.pkt.setCorrelationID(correlationID);
    }

    public String getJMSCorrelationID() throws JMSException {
        return this.pkt.getCorrelationID();
    }

    public javax.jms.Destination getJMSReplyTo() throws JMSException {
        String destName = null;
        String className = null;
        if (this.replyTo == null && this.messageID != null) {
            if (this.pkt.getReplyTo() == null) {
                return null;
            }
            try {
                destName = this.pkt.getReplyTo();
                className = this.pkt.getReplyToClass();
                this.replyTo = (Destination)Class.forName(className).newInstance();
                ((Destination)this.replyTo).setProperty("tmqiDestinationName", destName);
            }
            catch (Exception e) {
                this.replyTo = this.getJMQDestination(destName);
            }
        }
        return this.replyTo;
    }

    public void setJMSReplyTo(javax.jms.Destination replyTo) throws JMSException {
        this.replyTo = replyTo;
    }

    public javax.jms.Destination getJMSDestination() throws JMSException {
        String destName = null;
        String className = null;
        if (this.destination == null && this.messageID != null) {
            try {
                destName = this.pkt.getDestination();
                className = this.pkt.getDestinationClass();
                this.destination = (Destination)Class.forName(className).newInstance();
                ((Destination)this.destination).setProperty("tmqiDestinationName", destName);
            }
            catch (Exception e) {
                this.destination = this.getJMQDestination(destName);
            }
        }
        return this.destination;
    }

    public void setJMSDestination(javax.jms.Destination destination) throws JMSException {
        this.destination = destination;
    }

    public int getJMSDeliveryMode() throws JMSException {
        if (this.pkt.getPersistent()) {
            return 2;
        }
        return 1;
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        if (deliveryMode != 1 && deliveryMode != 2) {
            String errorString = AdministeredObject.cr.getKString("C4051", "DeliveryMode", String.valueOf(deliveryMode));
            JMSException jmse = new JMSException(errorString, "C4051");
            ExceptionHandler.throwJMSException(jmse);
        }
        if (deliveryMode == 2) {
            this.pkt.setPersistent(true);
        } else {
            this.pkt.setPersistent(false);
        }
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this.pkt.getRedelivered();
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        this.pkt.setRedelivered(redelivered);
    }

    public String getJMSType() throws JMSException {
        return this.pkt.getMessageType();
    }

    public void setJMSType(String type) throws JMSException {
        this.pkt.setMessageType(type);
    }

    public long getJMSExpiration() throws JMSException {
        return this.pkt.getExpiration();
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        this.pkt.setExpiration(expiration);
        this.pkt.setTimeToLive(expiration);
    }

    public int getJMSPriority() throws JMSException {
        return this.pkt.getPriority();
    }

    public void setJMSPriority(int priority) throws JMSException {
        if (priority < 0 || priority > 9) {
            String errorString = AdministeredObject.cr.getKString("C4051", "DeliveryPriority", String.valueOf(priority));
            JMSException jmse = new JMSException(errorString, "C4051");
            ExceptionHandler.throwJMSException(jmse);
        }
        this.pkt.setPriority(priority);
    }

    public void clearProperties() throws JMSException {
        if (this.properties != null) {
            this.properties.clear();
        }
        this.setPropertiesReadMode(false);
        this.shouldCompress = false;
    }

    public boolean propertyExists(String name) throws JMSException {
        if (this.properties == null) {
            return false;
        }
        try {
            return this.properties.containsKey(name);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4038");
            return false;
        }
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        Object obj = null;
        if (this.properties != null) {
            obj = this.properties.get(name);
        }
        return ValueConvert.toBoolean(obj);
    }

    public byte getByteProperty(String name) throws JMSException {
        Object obj = null;
        if (this.properties != null) {
            obj = this.properties.get(name);
        }
        return ValueConvert.toByte(obj);
    }

    public short getShortProperty(String name) throws JMSException {
        Object obj = null;
        if (this.properties != null) {
            obj = this.properties.get(name);
        }
        return ValueConvert.toShort(obj);
    }

    public int getIntProperty(String name) throws JMSException {
        Object obj = null;
        if (this.properties != null) {
            obj = this.properties.get(name);
        }
        return ValueConvert.toInt(obj);
    }

    public long getLongProperty(String name) throws JMSException {
        Object obj = null;
        if (this.properties != null) {
            obj = this.properties.get(name);
        }
        return ValueConvert.toLong(obj);
    }

    public float getFloatProperty(String name) throws JMSException {
        Object obj = null;
        if (this.properties != null) {
            obj = this.properties.get(name);
        }
        return ValueConvert.toFloat(obj);
    }

    public double getDoubleProperty(String name) throws JMSException {
        Object obj = null;
        if (this.properties != null) {
            obj = this.properties.get(name);
        }
        return ValueConvert.toDouble(obj);
    }

    public String getStringProperty(String name) throws JMSException {
        Object obj;
        if (name != null && name.equals("JMSMessageID") && this.jmsMessageID != null) {
            return this.jmsMessageID;
        }
        if (name != null && name.equals("JMSCorrelationID") && this.pkt.getCorrelationID() != null) {
            return this.pkt.getCorrelationID();
        }
        if (this.properties == null || (obj = this.properties.get(name)) == null) {
            return null;
        }
        return ValueConvert.toString(obj);
    }

    public Object getObjectProperty(String name) throws JMSException {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public Enumeration getPropertyNames() throws JMSException {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        return this.properties.keys();
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.checkAndSetProperty(name, value);
        if (JMS_TONG_COMPRESS.equals(name)) {
            this.shouldCompress = value;
        }
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        this.checkAndSetProperty(name, new Byte(value));
    }

    public void setShortProperty(String name, short value) throws JMSException {
        this.checkAndSetProperty(name, new Short(value));
    }

    public void setIntProperty(String name, int value) throws JMSException {
        this.checkAndSetProperty(name, new Integer(value));
    }

    public void setLongProperty(String name, long value) throws JMSException {
        this.checkAndSetProperty(name, new Long(value));
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        this.checkAndSetProperty(name, new Float(value));
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        this.checkAndSetProperty(name, new Double(value));
    }

    public void setStringProperty(String name, String value) throws JMSException {
        this.checkAndSetProperty(name, value);
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        this.checkAndSetProperty(name, value);
    }

    public void acknowledge() throws JMSException {
        if (this.session != null && this.session.acknowledgeMode == 2 && !this.isQBrowserMsg) {
            this.session.clientAcknowledge(this);
        }
    }

    @Override
    public void acknowledgeThisMessage() throws JMSException {
        if (this.session != null && this.session.acknowledgeMode == 2 && !this.isQBrowserMsg) {
            this.session.clientAcknowledgeThisMessage(this);
        }
    }

    @Override
    public void acknowledgeUpThroughThisMessage() throws JMSException {
        if (this.session != null && this.session.acknowledgeMode == 2 && !this.isQBrowserMsg) {
            this.session.clientAcknowledgeUpThroughThisMessage(this);
        }
    }

    public void clearBody() throws JMSException {
    }

    public boolean _getPersistent() {
        return this.pkt.getPersistent();
    }

    public boolean _getSendAcknowledge() {
        return this.pkt.getSendAcknowledge();
    }

    public void _setConsumerInRA() {
        this.consumerInRA = true;
    }

    protected void setIsBrowserMsg(boolean flag) {
        this.isQBrowserMsg = flag;
    }

    protected boolean isBrowserMessage() {
        return this.isQBrowserMsg;
    }

    @Override
    public void dump(PrintStream ps) {
    }

    public String toString() {
        String temp = null;
        try {
            temp = new StringBuffer().append("\nClass:\t\t\t").append(this.getClass().getName()).append("\ngetJMSMessageID():\t").append(this.getJMSMessageID()).append("\ngetJMSTimestamp():\t").append(Long.toString(this.getJMSTimestamp())).append("\ngetJMSCorrelationID():\t").append(this.getJMSCorrelationID()).append("\nJMSReplyTo:\t\t").append(this.getJMSReplyTo() != null ? ((Destination)this.getJMSReplyTo()).getName() : "null").append("\nJMSDestination:\t\t").append(this.getJMSDestination() != null ? ((Destination)this.getJMSDestination()).getName() : "null").append("\ngetJMSDeliveryMode():\t").append(this.getJMSDeliveryMode() == 2 ? "PERSISTENT" : "NON PERSISTENT").append("\ngetJMSRedelivered():\t").append(Boolean.toString(this.getJMSRedelivered())).append("\ngetJMSType():\t\t").append(this.getJMSType()).append("\ngetJMSExpiration():\t").append(Long.toString(this.getJMSExpiration())).append("\ngetJMSPriority():\t").append(Integer.toString(this.getJMSPriority())).append("\nProperties:\t\t").append(this.properties == null ? "null" : this.properties.toString()).toString();
        }
        catch (JMSException ex) {
            ex.printStackTrace();
        }
        return temp;
    }

    public long getProducerID() {
        return this.producerID;
    }

    public void setProducerID(long id) {
        this.producerID = id;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    public String getFixedMessageID() {
        return this.fixedMessageID;
    }

    public void setFixedMessageID(String fixedMessageID) {
        this.fixedMessageID = fixedMessageID;
    }

    public TupleOutput getRealAckMsgInfo() {
        return this.realAckMsgInfo;
    }

    public void setRealAckMsgInfo(TupleOutput realAckMsgInfo) {
        this.realAckMsgInfo = realAckMsgInfo;
    }

    public long getSeqId() {
        return this.seqId;
    }

    public void setSeqId(long seqId) {
        this.seqId = seqId;
    }
}

