/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.backport.java.util.concurrent.atomic.AtomicLong;
import com.tongtech.jms.protocol.TlqRemoteProtocolHandler;
import com.tongtech.log.JDKLogger;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.remote.protocol.command.MessageId;
import com.tongtech.tmqi.AdministeredObject;
import com.tongtech.tmqi.Destination;
import com.tongtech.tmqi.io.PacketType;
import com.tongtech.tmqi.io.ReadWritePacket;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.ExceptionHandler;
import com.tongtech.tmqi.jmsclient.FileMessageStatus;
import com.tongtech.tmqi.jmsclient.FileSendingController;
import com.tongtech.tmqi.jmsclient.MessageConvert;
import com.tongtech.tmqi.jmsclient.MessageImpl;
import com.tongtech.tmqi.jmsclient.SessionImpl;
import com.tongtech.tmqi.jmsclient.TemporaryDestination;
import com.tongtech.tmqi.usage.MemoryUsage;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;

public class MessageProducerImpl
implements MessageProducer,
FileSendingController,
FileMessageStatus {
    static Logger logger = LoggerFactory.getLogger(MessageProducerImpl.class);
    protected boolean isClosed = false;
    protected boolean disableMessageId = false;
    protected boolean disableMessageTimestamp = false;
    protected int deliveryMode = 2;
    protected int priority = 4;
    protected long timeToLive = 0L;
    protected javax.jms.Destination destination = null;
    protected SessionImpl session = null;
    protected MessageConvert messageConvert = null;
    public javax.jms.Destination addProducerDest = null;
    protected Hashtable destinations = new Hashtable();
    public Hashtable producerStates = new Hashtable();
    public AtomicLong messageSequence = new AtomicLong(0L);
    private volatile FileMessageStatus progressSnapshot;
    private volatile MessageId wantRemoveMessageId;
    private static final JDKLogger sessionLogger = SessionImpl.sessionLogger;

    public MessageProducerImpl(SessionImpl session, javax.jms.Destination destination) throws JMSException {
        try {
            this.session = session;
            this.destination = destination;
            if (destination != null) {
                session.getProtocolHandler().createMessageProducer(this);
            }
            session.addMessageProducer(this);
            if (sessionLogger.isLoggable(Level.FINE)) {
                this.logLifeCycle("I400");
            }
        }
        catch (JMSException jmse) {
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    public void recreateProducer() throws JMSException {
        if (this.destination != null) {
            this.session.getProtocolHandler().createMessageProducer(this);
        } else {
            Enumeration enum2 = this.destinations.elements();
            while (enum2.hasMoreElements()) {
                ProducerState ps = (ProducerState)enum2.nextElement();
                this.session.connection.removeMessageProducer(new Long(ps.getProducerID()));
            }
            this.destinations.clear();
            this.producerStates.clear();
        }
    }

    protected Message checkJMQMessage(Message message) throws JMSException {
        if (message instanceof MessageImpl) {
            return message;
        }
        if (this.messageConvert == null) {
            this.messageConvert = MessageConvert.getInstance();
        }
        return this.messageConvert.convertJMSMessage(message, this.session.getConnection().getProtocolType());
    }

    protected void checkState() throws JMSException {
        if (this.isClosed) {
            String errorString = AdministeredObject.cr.getKString("C4064");
            IllegalStateException jmse = new IllegalStateException(errorString, "C4064");
            ExceptionHandler.throwJMSException((JMSException)jmse);
        }
    }

    protected void resetForeignMessageHeader(Message message, Message foreignMessage) throws JMSException {
        this.messageConvert.resetForeignMessageHeader(message, foreignMessage);
    }

    protected void writeJMSMessage(Message message) throws JMSException {
        this.writeJMSMessage(this.destination, message);
    }

    protected void writeJMSMessage(javax.jms.Destination dest, Message message) throws JMSException {
        this.session.connection.checkReconnecting(null);
        String dn = ((Destination)dest).getName();
        ProducerState ps = (ProducerState)this.destinations.get(dn);
        long producerId = ps.getProducerID();
        MessageImpl jmsMessage = (MessageImpl)message;
        jmsMessage.setProducerID(producerId);
        try {
            this.session.writeJMSMessage(jmsMessage);
            if (sessionLogger.isLoggable(Level.FINER)) {
                this.logMessageProduced(dest, jmsMessage);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4038");
        }
    }

    private void logMessageProduced(javax.jms.Destination dest, Message message) throws JMSException {
        if (sessionLogger.isLoggable(Level.FINER)) {
            Destination mqDest = (Destination)dest;
            String domain = mqDest.isQueue() ? "Queue" : "Topic";
            String pktType = PacketType.getString(((MessageImpl)message).getPacket().getPacketType());
            ProducerState ps = (ProducerState)this.destinations.get(mqDest.getName());
            long pid = ps.getProducerID();
            Hashtable messageProperties = ((MessageImpl)message).getMessageProperties();
            String param = "MQTrace=MessageProducer, ThreadID=" + Thread.currentThread().getName() + ", ClientID=" + this.session.connection.getClientID() + ", ConnectionID=" + this.session.connection.getConnectionID() + ", SessionID=" + this.session.getBrokerSessionID() + ", ProducerID=" + pid + ", Destination=" + mqDest.getName() + ", Domain=" + domain + ", MessageID=" + message.getJMSMessageID() + ", MessageType=" + pktType + ", properties=" + (messageProperties == null ? "null" : messageProperties.toString());
            logger.trace("Message=" + param);
        }
    }

    public javax.jms.Destination getDestination() throws JMSException {
        this.checkState();
        return this.destination;
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.checkState();
        this.disableMessageId = value;
    }

    public boolean getDisableMessageID() throws JMSException {
        this.checkState();
        return this.disableMessageId;
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.checkState();
        this.disableMessageTimestamp = value;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        this.checkState();
        return this.disableMessageTimestamp;
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.checkState();
        if (deliveryMode != 1 && deliveryMode != 2) {
            String errorString = AdministeredObject.cr.getKString("C4051", "DeliveryMode", String.valueOf(deliveryMode));
            ExceptionHandler.throwJMSException(new JMSException(errorString, "C4051"));
        }
        this.deliveryMode = deliveryMode;
    }

    public int getDeliveryMode() throws JMSException {
        this.checkState();
        return this.deliveryMode;
    }

    public void setPriority(int defaultPriority) throws JMSException {
        this.checkState();
        if (defaultPriority < 0 || defaultPriority > 9) {
            String errorString = AdministeredObject.cr.getKString("C4051", "DeliveryPriority", String.valueOf(defaultPriority));
            ExceptionHandler.throwJMSException(new JMSException(errorString, "C4051"));
        }
        this.priority = defaultPriority;
    }

    public int getPriority() throws JMSException {
        this.checkState();
        return this.priority;
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.checkState();
        if (timeToLive < 0L) {
            String errorString = AdministeredObject.cr.getKString("C4051", "TimeToLive", String.valueOf(timeToLive));
            ExceptionHandler.throwJMSException(new JMSException(errorString, "C4051"));
        }
        this.timeToLive = timeToLive;
    }

    public long getTimeToLive() throws JMSException {
        this.checkState();
        return this.timeToLive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        try {
            ProducerState ps;
            Enumeration enum2 = this.producerStates.elements();
            while (enum2.hasMoreElements()) {
                ps = (ProducerState)enum2.nextElement();
                ps.close();
            }
            if (this.session.connection.getBrokerProtocolLevel() >= 350 && this.session.getProtocolHandler() != null) {
                enum2 = this.producerStates.elements();
                while (enum2.hasMoreElements()) {
                    ps = (ProducerState)enum2.nextElement();
                    MessageProducerImpl producer = this.session.connection.findMessageProducer(new Long(ps.getProducerID()));
                    this.session.connection.removeMessageProducer(new Long(ps.getProducerID()));
                    if (this.session.connection.isBroken()) continue;
                    this.session.getProtocolHandler().removeProducer(producer, ps.getProducerID());
                }
            }
            this.session.removeMessageProducer(this);
            this.destinations.clear();
            this.producerStates.clear();
        }
        finally {
            this.isClosed = true;
            if (SessionImpl.sessionLogger.isLoggable(Level.FINE)) {
                this.logLifeCycle("I401");
            }
        }
    }

    public void send(Message message) throws JMSException {
        try {
            Message foreignMessage = null;
            this.checkState();
            if (this.destination == null) {
                throw new UnsupportedOperationException();
            }
            this.checkTemporaryDestination(this.destination);
            if (!(message instanceof MessageImpl)) {
                foreignMessage = message;
            }
            message = this.checkJMQMessage(message);
            message.setJMSDestination(this.destination);
            message.setJMSDeliveryMode(this.getDeliveryMode());
            message.setJMSPriority(this.getPriority());
            message.setJMSExpiration(this.getTimeToLive());
            if (this.session.connection.jmqOverrideJMSMsgHeaders) {
                javax.jms.Destination d = message.getJMSDestination();
                if (this.session.connection.jmqOverrideMsgsToTempDests || !(d instanceof TemporaryQueue) && !(d instanceof TemporaryTopic)) {
                    if (this.session.connection.jmqOverrideJMSDeliveryMode) {
                        message.setJMSDeliveryMode(this.session.connection.jmqJMSDeliveryMode);
                    }
                    if (this.session.connection.jmqOverrideJMSPriority) {
                        message.setJMSPriority(this.session.connection.jmqJMSPriority);
                    }
                    if (this.session.connection.jmqOverrideJMSExpiration) {
                        message.setJMSExpiration(this.session.connection.jmqJMSExpiration);
                    }
                }
            }
            this.writeJMSMessage(message);
            if (foreignMessage != null) {
                this.resetForeignMessageHeader(message, foreignMessage);
            }
        }
        catch (Error e) {
            e.printStackTrace();
            ExceptionHandler.logError(e);
        }
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        Message foreignMessage = null;
        this.checkState();
        if (this.destination == null) {
            throw new UnsupportedOperationException();
        }
        this.checkTemporaryDestination(this.destination);
        if (!(message instanceof MessageImpl)) {
            foreignMessage = message;
        }
        message = this.checkJMQMessage(message);
        message.setJMSDestination(this.destination);
        message.setJMSDeliveryMode(deliveryMode);
        message.setJMSPriority(priority);
        message.setJMSExpiration(timeToLive);
        if (this.session.connection.jmqOverrideJMSMsgHeaders) {
            javax.jms.Destination d = message.getJMSDestination();
            if (this.session.connection.jmqOverrideMsgsToTempDests || !(d instanceof TemporaryQueue) && !(d instanceof TemporaryTopic)) {
                if (this.session.connection.jmqOverrideJMSDeliveryMode) {
                    message.setJMSDeliveryMode(this.session.connection.jmqJMSDeliveryMode);
                }
                if (this.session.connection.jmqOverrideJMSPriority) {
                    message.setJMSPriority(this.session.connection.jmqJMSPriority);
                }
                if (this.session.connection.jmqOverrideJMSExpiration) {
                    message.setJMSExpiration(this.session.connection.jmqJMSExpiration);
                }
            }
        }
        MessageImpl jmsMessage = (MessageImpl)message;
        this.writeJMSMessage(message);
        if (foreignMessage != null) {
            this.resetForeignMessageHeader(message, foreignMessage);
        }
    }

    public void send(javax.jms.Destination destination, Message message) throws JMSException {
        Message foreignMessage = null;
        this.checkState();
        if (destination == null) {
            String errorString = AdministeredObject.cr.getKString("C4019", "null");
            ExceptionHandler.throwJMSException((JMSException)new InvalidDestinationException(errorString, "C4019"));
        }
        if (this.destination != null) {
            throw new UnsupportedOperationException();
        }
        this.checkTemporaryDestination(destination);
        if (!(message instanceof MessageImpl)) {
            foreignMessage = message;
        }
        this.checkForUnspecifiedProducer(destination);
        message = this.checkJMQMessage(message);
        message.setJMSDestination(destination);
        message.setJMSDeliveryMode(this.getDeliveryMode());
        message.setJMSPriority(this.getPriority());
        message.setJMSExpiration(this.getTimeToLive());
        if (this.session.connection.jmqOverrideJMSMsgHeaders) {
            javax.jms.Destination d = message.getJMSDestination();
            if (this.session.connection.jmqOverrideMsgsToTempDests || !(d instanceof TemporaryQueue) && !(d instanceof TemporaryTopic)) {
                if (this.session.connection.jmqOverrideJMSDeliveryMode) {
                    message.setJMSDeliveryMode(this.session.connection.jmqJMSDeliveryMode);
                }
                if (this.session.connection.jmqOverrideJMSPriority) {
                    message.setJMSPriority(this.session.connection.jmqJMSPriority);
                }
                if (this.session.connection.jmqOverrideJMSExpiration) {
                    message.setJMSExpiration(this.session.connection.jmqJMSExpiration);
                }
            }
        }
        this.writeJMSMessage(destination, message);
        if (foreignMessage != null) {
            this.resetForeignMessageHeader(message, foreignMessage);
        }
    }

    public void send(javax.jms.Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        Message foreignMessage = null;
        this.checkState();
        if (destination == null) {
            String errorString = AdministeredObject.cr.getKString("C4019", "null");
            ExceptionHandler.throwJMSException((JMSException)new InvalidDestinationException(errorString, "C4019"));
        }
        if (this.destination != null) {
            throw new UnsupportedOperationException();
        }
        this.checkTemporaryDestination(destination);
        if (!(message instanceof MessageImpl)) {
            foreignMessage = message;
        }
        this.checkForUnspecifiedProducer(destination);
        message = this.checkJMQMessage(message);
        message.setJMSDestination(destination);
        message.setJMSDeliveryMode(deliveryMode);
        message.setJMSPriority(priority);
        message.setJMSExpiration(timeToLive);
        if (this.session.connection.jmqOverrideJMSMsgHeaders) {
            javax.jms.Destination d = message.getJMSDestination();
            if (this.session.connection.jmqOverrideMsgsToTempDests || !(d instanceof TemporaryQueue)) {
                if (this.session.connection.jmqOverrideJMSDeliveryMode) {
                    message.setJMSDeliveryMode(this.session.connection.jmqJMSDeliveryMode);
                }
                if (this.session.connection.jmqOverrideJMSPriority) {
                    message.setJMSPriority(this.session.connection.jmqJMSPriority);
                }
                if (this.session.connection.jmqOverrideJMSExpiration) {
                    message.setJMSExpiration(this.session.connection.jmqJMSExpiration);
                }
            }
        }
        this.writeJMSMessage(destination, message);
        if (foreignMessage != null) {
            this.resetForeignMessageHeader(message, foreignMessage);
        }
    }

    public void setProducerID(javax.jms.Destination dest, long producerID) {
        String dn = ((Destination)dest).getName();
        ProducerState ps = (ProducerState)this.destinations.get(dn);
        if (ps == null) {
            ps = new ProducerState();
            this.destinations.put(dn, ps);
        } else {
            if (logger.isTraceEnabled()) {
                logger.trace("Replacing ProducerID. old = {}, , new = {}", new Long(ps.getProducerID()), (Object)new Long(producerID));
            }
            this.producerStates.remove(new Long(ps.getProducerID()));
            this.session.connection.removeMessageProducer(new Long(ps.getProducerID()));
        }
        ps.setProducerID(producerID);
        this.producerStates.put(new Long(producerID), ps);
        this.session.connection.addMessageProducer(new Long(producerID), this);
    }

    public void setFlowLimit(long producerID, int flowLimit) {
        if (logger.isTraceEnabled()) {
            logger.trace("Setting flowLimit = {} for producerID = {}", new Long(flowLimit), (Object)new Long(producerID));
        }
        ProducerState ps = (ProducerState)this.producerStates.get(new Long(producerID));
        ps.setFlowLimit(flowLimit);
    }

    public void setFlowBytesLimit(long producerID, long flowBytesLimit) {
        if (logger.isTraceEnabled()) {
            logger.trace("Setting flowBytesLimit = {} for producerID = {}", new Long(flowBytesLimit), (Object)new Long(producerID));
        }
        ProducerState ps = (ProducerState)this.producerStates.get(new Long(producerID));
        ps.setFlowBytesLimit(flowBytesLimit);
    }

    private void checkFlowControl(javax.jms.Destination dest, Message message) {
        String dn = ((Destination)dest).getName();
        ProducerState ps = (ProducerState)this.destinations.get(dn);
        if (ps != null) {
            ps.checkFlowControl(message);
        }
    }

    public void waitForSpace(long producerID) throws JMSException {
        ProducerState ps = (ProducerState)this.producerStates.get(new Long(producerID));
        logger.trace("before waitForSpace producerid :{} Usage: {}", new Long(producerID), (Object)ps.getProducerWindow());
        ps.waitForSpace();
        logger.trace("after waitForSpace producerid :{} Usage: {}", new Long(producerID), (Object)ps.getProducerWindow());
    }

    public void decreaseUsage(long producerID, long value) {
        ProducerState ps = (ProducerState)this.producerStates.get(new Long(producerID));
        ps.decreaseUsage(value);
        logger.trace("after decreaseUsage producerid :{} Usage: {}", new Long(producerID), (Object)ps.getProducerWindow());
    }

    public void increaseUsage(long producerID, long value) {
        ProducerState ps = (ProducerState)this.producerStates.get(new Long(producerID));
        if (ps != null) {
            ps.increaseUsage(value);
        }
        logger.trace("after increaseUsage producerid :{} Usage: {}", new Long(producerID), (Object)ps.getProducerWindow());
    }

    public SessionImpl getSession() {
        return this.session;
    }

    public String toString() {
        String destName = null;
        long pid = -1L;
        try {
            ProducerState ps;
            if (this.destination != null && (ps = (ProducerState)this.destinations.get(destName = ((Destination)this.destination).getName())) != null) {
                pid = ps.getProducerID();
            }
        }
        catch (Exception e) {
            logger.warn("", e);
        }
        return this.session.toString() + ", ProducerID=" + pid + ", DestName=" + destName;
    }

    protected void checkForUnspecifiedProducer(javax.jms.Destination dest) throws JMSException {
        Destination d = (Destination)dest;
        String dn = d.getName();
        if (this.destinations.get(dn) == null) {
            this.session.getProtocolHandler().createMessageProducer(this, d);
        }
    }

    protected void checkTemporaryDestination(javax.jms.Destination dest) throws JMSException {
        ConnectionImpl connection;
        if (dest instanceof TemporaryDestination && (connection = ((TemporaryDestination)dest).connection) != null && connection.isClosed) {
            String errorString = AdministeredObject.cr.getKString("C4020", ((TemporaryDestination)dest).getName());
            ExceptionHandler.throwJMSException((JMSException)new InvalidDestinationException(errorString, "C4020"));
        }
    }

    public void logLifeCycle(String key) {
        if (sessionLogger.isLoggable(Level.FINE)) {
            sessionLogger.log(Level.FINE, key, this);
        }
    }

    private String getDestInfo(javax.jms.Destination destination) {
        long pid = -1L;
        String info = null;
        try {
            if (destination != null) {
                String destName = ((Destination)destination).getName();
                ProducerState ps = (ProducerState)this.destinations.get(destName);
                pid = ps.getProducerID();
                info = ", destName=" + destName + ", producerID=" + pid;
            }
        }
        catch (Exception e) {
            logger.warn("", e);
        }
        return info;
    }

    protected Hashtable getDebugState(boolean verbose) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("isClosed", String.valueOf(this.isClosed));
        ht.put("deliveryMode", String.valueOf(this.deliveryMode));
        ht.put("priority", String.valueOf(this.priority));
        ht.put("timeToLive", String.valueOf(this.timeToLive));
        ht.put("disableMessageId", String.valueOf(this.disableMessageId));
        ht.put("disableTimestamp", String.valueOf(this.disableMessageTimestamp));
        if (this.destination != null) {
            ht.put("Destination Class", this.destination.getClass().getName());
            if (this.destination instanceof Destination) {
                ht.put("Destination", ((Destination)this.destination).getName());
            }
            Enumeration enum2 = this.producerStates.elements();
            while (enum2.hasMoreElements()) {
                ProducerState ps = (ProducerState)enum2.nextElement();
                ht.putAll(ps.getDebugState(verbose));
            }
        } else {
            ht.put("isBound", "false");
            ht.put("# Destinations", String.valueOf(this.destinations.size()));
            int n = 0;
            Enumeration enum2 = this.destinations.keys();
            while (enum2.hasMoreElements()) {
                String dn = (String)enum2.nextElement();
                ProducerState ps = (ProducerState)this.destinations.get(dn);
                Hashtable tmp = ps.getDebugState(verbose);
                tmp.put("Destination", dn);
                ht.put("ProducerState[" + n + "]", tmp);
                ++n;
            }
        }
        return ht;
    }

    public void setFileProgressSnapshot(FileMessageStatus progressSnapshot) {
        this.progressSnapshot = progressSnapshot;
    }

    @Override
    public int getFileProgressPercentage() {
        if (this.progressSnapshot != null) {
            return this.progressSnapshot.getFileProgressPercentage();
        }
        return 0;
    }

    public FileMessageStatus getFileProgress() {
        return this.progressSnapshot;
    }

    @Override
    public void interruptFileSending(MessageId messageId) {
        this.wantRemoveMessageId = messageId;
    }

    @Override
    public MessageId getWantInterruptMessage() {
        return this.wantRemoveMessageId;
    }

    @Override
    public MessageId getMessageId() {
        if (this.progressSnapshot != null) {
            return this.progressSnapshot.getMessageId();
        }
        return null;
    }

    private boolean checkFilemessageIsSending(MessageId messageId) {
        return Arrays.equals(messageId.getByteValue(), this.progressSnapshot.getMessageId().getByteValue()) && this.progressSnapshot.isFileTransporting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFilemessage(MessageId messageId, boolean force) throws JMSException {
        if (this.checkFilemessageIsSending(messageId)) {
            this.interruptFileSending(messageId);
            FileMessageStatus fileMessageStatus = this.progressSnapshot;
            synchronized (fileMessageStatus) {
                try {
                    this.progressSnapshot.wait(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.checkFilemessageIsSending(messageId)) {
            throw new JMSException("message was transporting .. ");
        }
        ((TlqRemoteProtocolHandler)this.session.getProtocolHandler()).removeFilemessage(messageId.getByteValue(), messageId.getProducerId(), force);
    }

    @Override
    public void cleanInterrupted() {
        this.wantRemoveMessageId = null;
    }

    @Override
    public boolean isFileTransporting() {
        return this.progressSnapshot.isFileTransporting();
    }

    public class ProducerState {
        private long flowBytesLimit;
        private int flowLimit;
        private long producerID;
        private boolean blocked = false;
        private int TEST_minResume = Integer.MAX_VALUE;
        private int TEST_maxResume = -1;
        private int TEST_resumeCount = 0;
        private int TEST_pauseCount = 0;
        private int TEST_forcePauseCount = 0;
        private MemoryUsage producerWindow;

        public MemoryUsage getProducerWindow() {
            return this.producerWindow;
        }

        public void increaseUsage(long value) {
            this.producerWindow.increaseUsage(value);
        }

        public void decreaseUsage(long value) {
            this.producerWindow.decreaseUsage(value);
        }

        public void waitForSpace() {
            try {
                this.producerWindow.waitForSpace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public void setProducerWindow(MemoryUsage producerWindow) {
            this.producerWindow = producerWindow;
        }

        protected long getFlowBytesLimit() {
            return this.flowBytesLimit;
        }

        protected synchronized void setFlowBytesLimit(long flowBytesLimit) {
            this.flowBytesLimit = flowBytesLimit;
            if (this.producerWindow != null) {
                this.producerWindow.setLimit(this.flowBytesLimit);
            }
        }

        protected int getFlowLimit() {
            return this.flowLimit;
        }

        protected synchronized void setFlowLimit(int flowLimit) {
            this.flowLimit = flowLimit;
            if (flowLimit < this.TEST_minResume) {
                this.TEST_minResume = flowLimit;
            }
            if (flowLimit > this.TEST_maxResume) {
                this.TEST_maxResume = flowLimit;
            }
            if (flowLimit != 0) {
                ++this.TEST_resumeCount;
            } else {
                ++this.TEST_forcePauseCount;
            }
            this.notifyAll();
        }

        protected long getProducerID() {
            return this.producerID;
        }

        protected void setProducerID(long producerID) {
            this.producerID = producerID;
            this.producerWindow = new MemoryUsage("Producer Window: " + producerID);
            this.producerWindow.start();
        }

        protected synchronized void close() {
            this.notifyAll();
        }

        private synchronized void checkFlowControl(Message message) {
            while (this.flowLimit == 0 && !MessageProducerImpl.this.isClosed) {
                try {
                    this.blocked = true;
                    this.wait();
                    this.blocked = false;
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.flowLimit > 0) {
                --this.flowLimit;
            }
            if (this.flowLimit == 0) {
                ++this.TEST_pauseCount;
            }
            ReadWritePacket pkt = ((MessageImpl)message).getPacket();
            pkt.setProducerID(this.producerID);
            pkt.setConsumerFlow(this.flowLimit == 0);
        }

        protected Hashtable getDebugState(boolean verbose) {
            Hashtable<String, String> ht = new Hashtable<String, String>();
            ht.put("producerID", String.valueOf(this.producerID));
            ht.put("flowLimit", String.valueOf(this.flowLimit));
            ht.put("flowBytesLimit", String.valueOf(this.flowBytesLimit));
            ht.put("blocked", String.valueOf(this.blocked));
            ht.put("pauseCount", String.valueOf(this.TEST_pauseCount));
            ht.put("resumeCount", String.valueOf(this.TEST_resumeCount));
            ht.put("maxResume", String.valueOf(this.TEST_maxResume));
            ht.put("minResume", String.valueOf(this.TEST_minResume));
            ht.put("forcedPauses", String.valueOf(this.TEST_forcePauseCount));
            return ht;
        }
    }
}

