/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.jms.JMSException;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.AdministeredObject;
import com.tongtech.tmqi.Version;
import com.tongtech.tmqi.io.MQAddress;
import com.tongtech.tmqi.io.PortMapperEntry;
import com.tongtech.tmqi.io.PortMapperTable;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.ExceptionHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Map;

public class PortMapperClient {
    static Logger logger = LoggerFactory.getLogger(PortMapperClient.class);
    protected ConnectionImpl connection = null;
    protected PortMapperTable portMapperTable = null;
    protected boolean useMQAddress = false;
    protected MQAddress addr = null;
    private static final Version version = ConnectionImpl.version;

    public PortMapperClient(ConnectionImpl connection) throws javax.jms.JMSException {
        this.connection = connection;
        this.init();
    }

    public PortMapperClient(MQAddress addr, ConnectionImpl connection) throws javax.jms.JMSException {
        this.addr = addr;
        this.useMQAddress = true;
        this.connection = connection;
        this.init();
    }

    public int getPortForProtocol(String protocol) {
        String type = this.connection.getConnectionType();
        return this.getPort(protocol, type, null);
    }

    public int getPortForService(String protocol, String service) throws javax.jms.JMSException {
        String type = this.connection.getConnectionType();
        int port = this.getPort(protocol, type, service);
        if (port == -1) {
            String errorString = AdministeredObject.cr.getKString("C4098", service);
            JMSException jmse = new JMSException(errorString, "C4098");
            ExceptionHandler.throwJMSException(jmse);
        }
        return port;
    }

    private int getPort(String protocol, String type, String servicename) {
        int port = -1;
        Map table = this.portMapperTable.getServices();
        PortMapperEntry pme2 = null;
        for (PortMapperEntry pme2 : table.values()) {
            if (!pme2.getProtocol().equals(protocol) || !pme2.getType().equals(type)) continue;
            if (servicename == null) {
                port = pme2.getPort();
                break;
            }
            if (!pme2.getName().equals(servicename)) continue;
            port = pme2.getPort();
            break;
        }
        return port;
    }

    protected void init() throws javax.jms.JMSException {
        try {
            this.readBrokerPorts();
            this.checkBrokerVersion();
        }
        catch (javax.jms.JMSException jmse) {
            String str = this.getHostName() + ":" + this.getHostPort();
            this.connection.setLastContactedBrokerAddress(str);
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    protected void checkBrokerVersion() throws javax.jms.JMSException {
        String bkrversion = this.portMapperTable.getBrokerVersion();
        String clientMVersion = version.getImplementationVersion();
        bkrversion = "3.5";
        if (Version.compareVersions(bkrversion, "3.0") < 0) {
            String errorString = AdministeredObject.cr.getKString("C4065", clientMVersion, bkrversion);
            JMSException jmse = new JMSException(errorString, "C4065");
            ExceptionHandler.throwJMSException(jmse);
        }
        if (Version.compareVersions(bkrversion, "3.0.1", false) < 0) {
            throw new RuntimeException("Not implements......");
        }
    }

    private String getHostName() {
        if (this.useMQAddress) {
            return this.addr.getHostName();
        }
        return this.connection.getProperty("tmqiBrokerHostName");
    }

    public int getHostPort() {
        if (this.useMQAddress) {
            return this.addr.getPort();
        }
        String prop = this.connection.getProperty("tmqiBrokerHostPort");
        return Integer.parseInt(prop);
    }

    protected void readBrokerPorts() throws javax.jms.JMSException {
        String host = this.getHostName();
        int port = this.getHostPort();
        if (logger.isTraceEnabled()) {
            logger.trace("PortMapper connecting to host: {},  port: {}", (Object)host, (Object)new Integer(port));
        }
        try {
            String version = String.valueOf(101) + "\n";
            Socket socket = new Socket(host, port);
            InputStream is = socket.getInputStream();
            OutputStream os = socket.getOutputStream();
            try {
                os.write(version.getBytes());
                os.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.portMapperTable = new PortMapperTable();
            this.portMapperTable.read(is);
            is.close();
            socket.close();
        }
        catch (Exception e) {
            this.connection.getExceptionHandler();
            ExceptionHandler.handleConnectException(e, host, port);
        }
    }

    public static void main(String[] args) {
        try {
            PortMapperClient pmc = new PortMapperClient(null);
            String protocol = "tcp";
            String prop = System.getProperty("protocol");
            if (prop != null) {
                protocol = prop;
            }
            int port = pmc.getPortForProtocol(protocol);
            if (logger.isTraceEnabled()) {
                logger.trace("port = {}", port);
            }
        }
        catch (Exception e) {
            logger.warn("", e);
        }
    }
}

