/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.jmsclient.SessionQueue;
import com.tongtech.tmqi.jmsclient.Traceable;
import java.io.PrintStream;

class ReceiveQueue
extends SessionQueue
implements Traceable {
    static Logger logger = LoggerFactory.getLogger(ReceiveQueue.class);
    private boolean receiveInProcess = false;

    public ReceiveQueue() {
    }

    public ReceiveQueue(boolean useSequential, int size) {
        super(useSequential, size);
    }

    @Override
    protected synchronized Object dequeueWait() {
        return this.dequeueWait(0L);
    }

    @Override
    protected synchronized Object dequeueWait(long timeout) {
        if (logger.isTraceEnabled()) {
            logger.trace("waiting for receive message timeout:{}", timeout);
        }
        long waitTime = timeout;
        boolean expired = false;
        while (this.isEmpty() || this.isLocked) {
            if (this.isClosed || expired) {
                return null;
            }
            try {
                long elapsed;
                if (timeout == 0L) {
                    this.wait(0L);
                    continue;
                }
                long st = System.currentTimeMillis();
                this.wait(waitTime);
                if (!this.isEmpty() && !this.isLocked || (waitTime -= (elapsed = System.currentTimeMillis() - st)) > 0L) continue;
                expired = true;
            }
            catch (InterruptedException interruptedException) {}
        }
        if (logger.isTraceEnabled()) {
            logger.trace("waiting for receive message expired {},timeout:{}", new Boolean(expired), (Object)new Long(timeout));
        }
        if (this.isClosed) {
            return null;
        }
        this.receiveInProcess = true;
        return this.dequeue();
    }

    protected synchronized void setReceiveInProcess(boolean state) {
        this.receiveInProcess = state;
        this.notifyAll();
    }

    protected synchronized void stop() {
        this.isLocked = true;
        this.waitUntilReceiveIsDone();
        if (logger.isTraceEnabled()) {
            logger.trace("receive queue 'stop' called ...");
        }
    }

    protected synchronized void stopNoWait() {
        this.isLocked = true;
    }

    @Override
    protected synchronized void start() {
        if (!this.isEmpty()) {
            this.setIsLocked(false);
        } else {
            this.isLocked = false;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("receive queue 'start' called ...");
        }
    }

    protected synchronized void waitUntilReceiveIsDone() {
        try {
            while (this.isLocked && this.receiveInProcess) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void dump(PrintStream ps) {
    }
}

