/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.backport.java.util.concurrent.atomic.AtomicInteger;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.jmsclient.MessageQueue;
import com.tongtech.tmqi.jmsclient.PriorityQueue;
import com.tongtech.tmqi.jmsclient.SequentialQueue;
import com.tongtech.tmqi.jmsclient.Traceable;
import java.io.PrintStream;

public class SessionQueue
implements Traceable {
    static Logger logger = LoggerFactory.getLogger(SessionQueue.class);
    private MessageQueue queue = null;
    protected boolean isLocked = false;
    private boolean sessionIsStopped = false;
    protected boolean isClosed = false;
    protected boolean listenerIsSetLate = false;
    protected AtomicInteger listenerCount = new AtomicInteger(0);
    private long constructTime = 0L;
    private static String USE_SEQUENTIAL = System.getProperty("tmqi.useSequentialQueue");

    public synchronized void enqueueNotify(Object pkt) {
        this.enqueue(pkt);
        this.notifyAll();
    }

    public SessionQueue() {
        this.queue = USE_SEQUENTIAL == null ? new PriorityQueue() : new SequentialQueue();
    }

    public SessionQueue(boolean useSequential, int size) {
        this.queue = useSequential ? new SequentialQueue(size) : new PriorityQueue();
    }

    protected synchronized void validateQueue() {
        if (this.constructTime == 0L) {
            this.constructTime = System.currentTimeMillis();
        }
        if (this.queue == null) {
            long diff = System.currentTimeMillis() - this.constructTime;
            throw new Error("JVM Error. Message Queue is null. Create time: " + this.constructTime + " duration: " + diff);
        }
    }

    protected int size() {
        return this.queue.size();
    }

    public boolean isEmpty() {
        if (this.queue == null) {
            this.validateQueue();
        }
        return this.queue.isEmpty();
    }

    protected void clear() {
        this.queue.clear();
    }

    protected Object[] toArray() {
        return this.queue.toArray();
    }

    protected boolean remove(Object obj) {
        return this.queue.remove(obj);
    }

    protected void enqueue(Object nobj) {
        this.queue.enqueue(nobj);
        if (logger.isTraceEnabled()) {
            logger.trace("put to consumer queue {} {}", this.queue, (Object)this);
        }
    }

    protected Object dequeue() {
        Object obj = null;
        if (!this.queue.isEmpty()) {
            obj = this.queue.dequeue();
        }
        return obj;
    }

    protected synchronized Object dequeueWait(long timeout) {
        while (this.isEmpty() || this.isLocked) {
            if (this.isClosed) {
                return null;
            }
            if (this.isLocked) {
                this.setSessionIsStopped(true);
            }
            if (this.listenerCount.get() > 0) {
                return null;
            }
            try {
                this.wait(timeout);
                if (!this.isEmpty() || this.isLocked || timeout <= 0L) continue;
                return null;
            }
            catch (InterruptedException e) {
                logger.warn("", e);
            }
        }
        return this.dequeue();
    }

    protected synchronized Object dequeueWait() {
        return this.dequeueWait(0L);
    }

    protected synchronized void setIsLocked(boolean state) {
        this.isLocked = state;
        this.notifyAll();
    }

    protected synchronized boolean getIsLocked() {
        return this.isLocked;
    }

    protected synchronized void setSessionIsStopped(boolean state) {
        if (logger.isTraceEnabled()) {
            logger.trace("session reader is stopped: {}", new Boolean(state));
        }
        this.sessionIsStopped = state;
        this.notifyAll();
    }

    protected synchronized void waitUntilSessionStopped() {
        try {
            while (!this.isClosed && this.isLocked && !this.sessionIsStopped) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected synchronized void stop(boolean doWait) {
        this.setIsLocked(true);
        if (doWait) {
            this.waitUntilSessionStopped();
        } else {
            this.sessionIsStopped = true;
        }
    }

    protected synchronized void start() {
        this.setIsLocked(false);
        this.setSessionIsStopped(false);
    }

    protected synchronized void close() {
        this.isClosed = true;
        this.setIsLocked(false);
        if (logger.isTraceEnabled()) {
            logger.trace("Session queue closed ...");
        }
    }

    protected boolean getIsClosed() {
        return this.isClosed;
    }

    protected synchronized void setListenerLateNotify() {
        this.listenerCount.incrementAndGet();
        this.notifyAll();
    }

    protected synchronized void setListenerLate(boolean state) {
        this.listenerIsSetLate = state;
    }

    protected synchronized boolean isListenerSetLate() {
        return this.listenerIsSetLate;
    }

    @Override
    public void dump(PrintStream ps) {
    }
}

