/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.AdministeredObject;
import com.tongtech.tmqi.io.ReadOnlyPacket;
import com.tongtech.tmqi.jmsclient.Consumer;
import com.tongtech.tmqi.jmsclient.ConsumerReader;
import com.tongtech.tmqi.jmsclient.MessageConsumerImpl;
import com.tongtech.tmqi.jmsclient.MessageImpl;
import com.tongtech.tmqi.jmsclient.SessionImpl;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import javax.jms.JMSException;

public class SessionReader
extends ConsumerReader {
    static Logger logger = LoggerFactory.getLogger(SessionReader.class);
    protected SessionImpl session = null;
    protected volatile MessageImpl currentMessage = null;

    public SessionReader(SessionImpl session) {
        super(session.getConnection(), session.getSessionQueue());
        this.session = session;
        if (session.acknowledgeMode == 3 && session.dupsOkAckOnTimeout) {
            if (logger.isTraceEnabled()) {
                logger.trace("**** setting dupsOkAckTimeout: " + session.dupsOkAckTimeout);
            }
            this.setTimeout(session.dupsOkAckTimeout);
        }
        this.init();
    }

    protected void setCurrentMessage(MessageImpl cm) {
        this.currentMessage = cm;
    }

    @Override
    protected void deliver(ReadOnlyPacket packet) throws IOException, JMSException {
        long interestId = 0L;
        Consumer consumer = null;
        this.currentMessage = this.getJMSMessage(packet);
        interestId = this.currentMessage.getInterestID();
        if (logger.isTraceEnabled()) {
            logger.trace("SessionReader.deliver, msgid={}, interestId={}", this.currentMessage.getMessageID(), (Object)new Long(interestId));
        }
        if ((consumer = this.session.getMessageConsumer(new Long(interestId))) == null) {
            consumer = this.session.getBrowserConsumer(new Long(interestId));
        }
        if (logger.isTraceEnabled()) {
            logger.trace("consumer={}", consumer);
        }
        if (consumer != null) {
            ((Consumer)consumer).onMessage(this.currentMessage);
        } else {
            String errorString = AdministeredObject.cr.getKString("C4021");
            if (logger.isTraceEnabled()) {
                logger.trace("", (Object)errorString);
            }
            packet.dump(logger);
        }
    }

    @Override
    protected void deliver() throws IOException, JMSException {
        logger.trace("sessionThread received pkt ...devlier()");
        if (!this.sessionQueue.getIsClosed()) {
            if (this.session.dupsOkAckOnTimeout) {
                if (logger.isTraceEnabled()) {
                    logger.trace("*** Calling dups ok commit from timeout thread");
                }
                this.session.syncedDupsOkCommitAcknowledge();
            }
            if (this.sessionQueue.listenerCount.get() > 0) {
                this.onMessageToLateListeners();
                this.sessionQueue.setListenerLate(false);
            }
        }
    }

    protected void onMessageToLateListeners() throws JMSException {
        MessageConsumerImpl consumer = null;
        Enumeration enum2 = this.session.consumers.elements();
        while (enum2.hasMoreElements()) {
            consumer = (MessageConsumerImpl)enum2.nextElement();
            if (consumer.getSyncReadFlag()) continue;
            consumer.onMessageToListenerFromReceiveQueue();
        }
    }

    protected MessageImpl getJMSMessage(ReadOnlyPacket pkt) throws JMSException {
        MessageImpl msg = this.protocolHandler.getJMSMessage(pkt);
        msg.setSession(this.session);
        return msg;
    }

    @Override
    public void dump(PrintStream ps) {
    }
}

