/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.AdministeredObject;
import com.tongtech.tmqi.Destination;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.Consumer;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;

public abstract class TemporaryDestination
extends Destination {
    protected ConnectionImpl connection = null;
    private boolean isDeleted = false;
    static Logger logger = LoggerFactory.getLogger(TemporaryDestination.class);
    public static final String temporaryPrefix = "J_";

    protected TemporaryDestination(ConnectionImpl connection, String destination_type) throws JMSException {
        super(temporaryPrefix + connection.getProtocolHandler().getConnectinId() + "_" + "t_d__" + destination_type + connection.getLocalIP() + "_" + connection.getLocalPort() + "_" + connection.getTempDestSequence());
        this.connection = connection;
        connection.protocolHandler.createDestination(this);
        connection.addTempDest(this);
    }

    protected TemporaryDestination(String name) throws JMSException {
        super(name);
    }

    protected TemporaryDestination() throws JMSException {
    }

    @Override
    public boolean isTemporary() {
        return true;
    }

    public void delete() throws JMSException {
        if (this.isDeleted) {
            return;
        }
        if (this.connection == null) {
            String errorString = AdministeredObject.cr.getKString("C4039");
            throw new JMSException(errorString, "C4039");
        }
        this.checkConsumer();
        this.connection.decreaseTempDestCounter();
        this.isDeleted = true;
        this.connection.getProtocolHandler().deleteDestination(this);
    }

    public static void checkTemporaryDestinationConsumerAllowed(ConnectionImpl connection, javax.jms.Destination dest) throws JMSException {
        String name = null;
        String prefix = null;
        String conn_id = null;
        if (dest instanceof TemporaryQueue) {
            name = ((Queue)dest).getQueueName();
            prefix = temporaryPrefix + connection.getProtocolHandler().getConnectinId() + "_" + "t_d__" + "q_";
        } else if (dest instanceof TemporaryTopic) {
            name = ((Topic)dest).getTopicName();
            prefix = temporaryPrefix + connection.getProtocolHandler().getConnectinId() + "_" + "t_d__" + "t_";
        }
        if (name != null) {
            conn_id = connection.getLocalIP() + "_" + connection.getLocalPort() + "_";
            if (!name.startsWith(prefix + conn_id)) {
                String errorString = AdministeredObject.cr.getKString("C4020", name);
                throw new JMSException(errorString, "C4020");
            }
        }
    }

    protected void checkConsumer() throws JMSException {
        boolean foundConsumer = false;
        String myName = this.getName();
        Object[] consumers = this.connection.interestTable.toArray();
        Consumer consumer = null;
        String destName = null;
        Destination dest = null;
        for (int index = 0; index < consumers.length; ++index) {
            consumer = (Consumer)consumers[index];
            dest = (Destination)consumer.getDestination();
            destName = dest.getName();
            if (!myName.equals(destName)) continue;
            foundConsumer = true;
            break;
        }
        if (foundConsumer) {
            String errorString = AdministeredObject.cr.getKString("C4039");
            throw new JMSException(errorString, "C4039");
        }
    }

    public boolean checkSendCreateDest(javax.jms.Destination dest, ConnectionImpl con) {
        try {
            TemporaryDestination.checkTemporaryDestinationConsumerAllowed(con, dest);
        }
        catch (JMSException jmsEx) {
            return false;
        }
        return true;
    }
}

