/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.jms.InvalidDestinationException;
import com.tongtech.jms.Session;
import com.tongtech.jms.ra.ManagedConnectionIF;
import com.tongtech.tmqi.AdministeredObject;
import com.tongtech.tmqi.BasicQueue;
import com.tongtech.tmqi.BasicTopic;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.MessageConsumerImpl;
import com.tongtech.tmqi.jmsclient.MessageProducerImpl;
import com.tongtech.tmqi.jmsclient.QueueBrowserImpl;
import com.tongtech.tmqi.jmsclient.QueueReceiverImpl;
import com.tongtech.tmqi.jmsclient.QueueSenderImpl;
import com.tongtech.tmqi.jmsclient.SessionImpl;
import com.tongtech.tmqi.jmsclient.TemporaryQueueImpl;
import com.tongtech.tmqi.jmsclient.TemporaryTopicImpl;
import com.tongtech.tmqi.jmsclient.TopicPublisherImpl;
import com.tongtech.tmqi.jmsclient.TopicSubscriberImpl;
import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSubscriber;

public class UnifiedSessionImpl
extends SessionImpl
implements Session {
    public UnifiedSessionImpl(ConnectionImpl connection, boolean transacted, int ackMode) throws JMSException {
        super(connection, transacted, ackMode);
    }

    public UnifiedSessionImpl(ConnectionImpl connection, boolean transacted, int ackMode, ManagedConnectionIF mc) throws JMSException {
        super(connection, transacted, ackMode, mc);
    }

    public UnifiedSessionImpl(ConnectionImpl connection, int ackMode) throws JMSException {
        super(connection, ackMode);
    }

    public Queue createQueue(String queueName) throws JMSException {
        this.checkSessionState();
        return new BasicQueue(queueName);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        this.checkSessionState();
        return new QueueReceiverImpl((SessionImpl)this, queue);
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        this.checkSessionState();
        return new QueueReceiverImpl(this, queue, messageSelector);
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        this.checkSessionState();
        return new QueueSenderImpl((SessionImpl)this, queue);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        this.checkSessionState();
        return new QueueBrowserImpl(this, queue);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        this.checkSessionState();
        return new QueueBrowserImpl(this, queue, messageSelector);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        this.checkSessionState();
        return new TemporaryQueueImpl(this.connection);
    }

    public Topic createTopic(String topicName) throws JMSException {
        this.checkSessionState();
        return new BasicTopic(topicName);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        this.checkSessionState();
        return this.createSubscriber(topic, null, false);
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        this.checkSessionState();
        return new TopicSubscriberImpl((SessionImpl)this, topic, messageSelector, noLocal);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        this.checkSessionState();
        this.checkTemporaryDestination(topic);
        this.checkClientIDWithBroker();
        return new TopicSubscriberImpl(this, topic, name);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        this.checkSessionState();
        this.checkTemporaryDestination(topic);
        this.checkClientIDWithBroker();
        return new TopicSubscriberImpl(this, topic, name, messageSelector, noLocal);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        this.checkSessionState();
        return new TopicPublisherImpl((SessionImpl)this, topic);
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        this.checkSessionState();
        return new TemporaryTopicImpl(this.connection);
    }

    public void unsubscribe(String name) throws JMSException {
        if (name == null || name.equals("")) {
            throw new InvalidDestinationException("subscribe name can not be null");
        }
        MessageConsumerImpl consumer = null;
        boolean deregistered = false;
        this.checkSessionState();
        Enumeration enum2 = this.consumers.elements();
        while (enum2.hasMoreElements()) {
            consumer = (MessageConsumerImpl)enum2.nextElement();
            if (!consumer.getDurable() || !consumer.getDurableName().equals(name)) continue;
            String errorString = AdministeredObject.cr.getKString("C4007", consumer.getDurableName());
            throw new JMSException(errorString, "C4007");
        }
        this.checkClientIDWithBroker();
        this.connection.unsubscribe(name);
        deregistered = true;
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        if (destination == null) {
            return new MessageProducerImpl(this, destination);
        }
        if (destination instanceof Queue) {
            return this.createSender((Queue)destination);
        }
        if (destination instanceof Topic) {
            return this.createPublisher((Topic)destination);
        }
        String errorString = AdministeredObject.cr.getKString("C4068", destination.getClass().getName());
        throw new JMSException(errorString, "C4068");
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.createConsumer(destination, null, false);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return this.createConsumer(destination, messageSelector, false);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean NoLocal) throws JMSException {
        if (destination == null) {
            String errorString = AdministeredObject.cr.getKString("C4019", "null");
            throw new javax.jms.InvalidDestinationException(errorString, "C4019");
        }
        if (destination instanceof Queue) {
            return this.createReceiver((Queue)destination, messageSelector);
        }
        if (destination instanceof Topic) {
            return this.createSubscriber((Topic)destination, messageSelector, NoLocal);
        }
        String errorString = AdministeredObject.cr.getKString("C4068", destination.getClass().getName());
        throw new JMSException(errorString, "C4068");
    }

    protected void checkClientIDWithBroker() throws JMSException {
        String clientID = this.connection.getClientID();
        if (clientID == null) {
            String errorString = AdministeredObject.cr.getKString("C4053", "\"\"");
            throw new JMSException(errorString, "C4053");
        }
        if (!this.connection.getProtocolHandler().isClientIDsent()) {
            this.connection.getProtocolHandler().setClientID(clientID);
        }
    }

    protected void checkTemporaryDestination(Topic topic) throws JMSException {
        if (topic == null || topic instanceof TemporaryTopic) {
            String errorString = AdministeredObject.cr.getKString("C4050", topic == null ? "" : topic.getTopicName());
            throw new javax.jms.InvalidDestinationException(errorString, "C4050");
        }
    }
}

