/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.SessionImpl;
import com.tongtech.tmqi.jmsclient.Transaction;
import com.tongtech.tmqi.jmsclient.XAResourceForRA;
import com.tongtech.tmqi.util.JMQXid;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceImpl
implements XAResource {
    static Logger logger = LoggerFactory.getLogger(XAResourceImpl.class);
    private SessionImpl _session;
    private ConnectionImpl _connection;
    private Transaction _transaction = null;
    private long resourceManagerId = 0L;
    private int transactionTimeout = 0;
    protected static Hashtable xaTable = new Hashtable();
    public static final Integer XA_START = new Integer(0);
    public static final Integer XA_END = new Integer(1);
    public static final Integer XA_PREPARE = new Integer(2);
    public static final Integer XA_ROLLBACK_ONLY = new Integer(4);
    public static boolean turnOffXATracking = Boolean.getBoolean("tmqi.ra.turnOffXATracking");
    public static boolean XATracking = !turnOffXATracking;

    public XAResourceImpl(SessionImpl session) throws JMSException {
        this._session = session;
        this._connection = session.connection;
        this.resourceManagerId = this._connection.protocolHandler.generateUID();
        if (logger.isTraceEnabled()) {
            logger.trace("*=*=*=*=*=*=*=*=*=*=XAR:new:RMId=" + this.resourceManagerId);
        }
    }

    @Override
    public void commit(Xid foreignXid, boolean onePhase) throws XAException {
        JMQXid jmqXid = new JMQXid(foreignXid);
        if (logger.isTraceEnabled()) {
            logger.trace("*=*=*=*=*=*=*=*=*=*=XAR:commit:onePhase=" + onePhase + "\txid=\n" + jmqXid.toString());
        }
        if (this._session.isRollbackOnly) {
            if (logger.isTraceEnabled()) {
                logger.trace("*=*=*=*=*=*=*=*=*=*=XAR:prepare:forcing Rollback due to:" + this._session.rollbackCause.getMessage());
            }
            XAException xae = new XAException(-7);
            xae.initCause(this._session.rollbackCause);
            throw xae;
        }
        try {
            try {
                this._connection.openConnectionFromRA(true);
            }
            catch (Exception oce) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this._connection.openConnectionFromRA(true);
            }
            if (this._transaction != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("*=*=*=*=*=*=*=*=*=*=XAR:commit:using real txnID");
                }
                this._transaction.setProtocolHandler(this._connection.getProtocolHandler());
                if (!this._session.isClosed) {
                    this._session.setInSyncState();
                    this._session.receiveCommit();
                }
                if (this._connection.isConnectedToHABroker) {
                    this.HACommit(foreignXid, jmqXid, onePhase);
                } else if (this._session.transaction != null) {
                    this._transaction.commitXATransaction(jmqXid, onePhase);
                }
            }
            this._connection.closeConnectionFromRA();
        }
        catch (Exception jmse) {
            logger.warn("", jmse);
            XAException xae = new XAException(-7);
            xae.initCause(jmse);
            throw xae;
        }
        finally {
            this._session.releaseInSyncState();
            this._session.switchOffXATransaction();
        }
    }

    @Override
    public void end(Xid foreignXid, int flags) throws XAException {
        JMQXid jmqXid = new JMQXid(foreignXid);
        if (logger.isTraceEnabled()) {
            logger.trace("*=*=*=*=*=*=*=*=*=*=XAR:end:flags=" + flags + "\txid=\n" + jmqXid.toString());
        }
        try {
            if (this._session.transaction != null) {
                this._session.transaction.endXATransaction(flags, jmqXid);
            }
        }
        catch (JMSException jmse) {
            logger.warn("", jmse);
            XAException xae = new XAException(-7);
            xae.initCause(jmse);
            throw xae;
        }
    }

    @Override
    public void forget(Xid foreignXid) throws XAException {
        JMQXid jmqXid = new JMQXid(foreignXid);
        if (logger.isTraceEnabled()) {
            logger.trace("*=*=*=*=*=*=*=*=*=*=XAR:forget:txid=\n" + jmqXid.toString());
        }
        try {
            this._session.transaction.forgetXATransaction(jmqXid);
        }
        catch (JMSException jmse) {
            logger.warn("", jmse);
            XAException xae = new XAException(-7);
            xae.initCause(jmse);
            throw xae;
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.transactionTimeout;
    }

    @Override
    public boolean isSameRM(XAResource foreignXaRes) throws XAException {
        return this.getClass().isInstance(foreignXaRes) ? this.isSameJMQRM((XAResourceImpl)foreignXaRes) : false;
    }

    public boolean isSameJMQRM(XAResourceImpl xaResource) {
        if (this.resourceManagerId != 0L) {
            return this.resourceManagerId == xaResource.getResourceManagerId();
        }
        return false;
    }

    public int prepare(Xid foreignXid, boolean onePhase) throws XAException {
        int result = 0;
        JMQXid jmqXid = new JMQXid(foreignXid);
        if (logger.isTraceEnabled()) {
            logger.trace("*=*=*=*=*=*=*=*=*=*=XAR:prepare:txid=\n" + jmqXid.toString());
        }
        if (this._connection.getUserName().equals("xatest")) {
            throw new XAException(100);
        }
        if (this._session.isRollbackOnly) {
            if (logger.isTraceEnabled()) {
                logger.trace("*=*=*=*=*=*=*=*=*=*=XAR:prepare:forcing Rollback due to:" + this._session.rollbackCause.getMessage());
            }
            XAException xae = new XAException(-7);
            xae.initCause(this._session.rollbackCause);
            throw xae;
        }
        try {
            try {
                this._connection.openConnectionFromRA(true);
            }
            catch (Exception oce) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this._connection.openConnectionFromRA(true);
            }
            if (this._transaction == null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("*=*=*=*=*=*=*=*=*=*=XAR:prepare:using 0 as txnID");
                }
                this._connection.getProtocolHandler().prepare(0L, jmqXid, onePhase);
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("*=*=*=*=*=*=*=*=*=*=XAR:prepare:using real txnID");
                }
                this._transaction.setProtocolHandler(this._connection.getProtocolHandler());
                if (onePhase) {
                    this._connection.getProtocolHandler().prepare(0L, jmqXid, onePhase);
                } else {
                    this._transaction.prepareXATransaction(jmqXid);
                }
            }
            this._connection.closeConnectionFromRA();
        }
        catch (Exception jmse) {
            logger.warn("", jmse);
            XAException xae = new XAException(-7);
            xae.initCause(jmse);
            throw xae;
        }
        return result;
    }

    @Override
    public Xid[] recover(int flags) throws XAException {
        Xid[] result = null;
        if (logger.isTraceEnabled()) {
            logger.trace("*=*=*=*=*=*=*=*=*=*=XAR:recover:flags=" + flags);
        }
        try {
            try {
                this._connection.openConnectionFromRA(true);
            }
            catch (Exception oce) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this._connection.openConnectionFromRA(true);
            }
            result = this._connection.getProtocolHandler().recover(flags);
            this._connection.closeConnectionFromRA();
        }
        catch (Exception jmse) {
            logger.warn("", jmse);
            XAException xae = new XAException(-7);
            xae.initCause(jmse);
            throw xae;
        }
        return result;
    }

    @Override
    public void rollback(Xid foreignXid) throws XAException {
        JMQXid jmqXid = new JMQXid(foreignXid);
        if (logger.isTraceEnabled()) {
            logger.trace("*=*=*=*=*=*=*=*=*=*=XAR:rollback:txid=\n" + jmqXid.toString());
        }
        try {
            try {
                this._connection.openConnectionFromRA(true);
            }
            catch (Exception oce) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this._connection.openConnectionFromRA(true);
            }
            if (this._transaction != null) {
                this._transaction.setProtocolHandler(this._connection.getProtocolHandler());
                if (!this._session.isClosed) {
                    this._session.setInSyncState();
                    this._session.receiveRollback();
                }
                if (this._connection.isConnectedToHABroker) {
                    this.HARollback(jmqXid);
                } else if (this._session.transaction != null) {
                    this._transaction.rollbackXATransaction(jmqXid);
                }
            }
            this._connection.closeConnectionFromRA();
        }
        catch (JMSException jmse) {
            logger.warn("", jmse);
            XAException xae = new XAException(-7);
            xae.initCause(jmse);
            throw xae;
        }
        finally {
            this._session.failoverOccurred = false;
            this._session.releaseInSyncState();
            this._session.switchOffXATransaction();
            this._session.isRollbackOnly = false;
            this._session.rollbackCause = null;
        }
    }

    @Override
    public boolean setTransactionTimeout(int transactionTimeout) throws XAException {
        if (logger.isTraceEnabled()) {
            logger.trace("*=*=*=*=*=*=*=*=*=*=XAR:setTransactionTimeout:timeout=" + transactionTimeout);
        }
        return false;
    }

    @Override
    public void start(Xid foreignXid, int flags) throws XAException {
        JMQXid jmqXid = new JMQXid(foreignXid);
        if (logger.isTraceEnabled()) {
            logger.trace("*=*=*=*=*=*=*=*=*=*=XAR:start:flags=" + flags + "\txid=" + jmqXid.toString());
        }
        try {
            this._session.switchOnXATransaction();
            this._transaction = this._session.transaction;
            this._transaction.startXATransaction(flags, jmqXid);
        }
        catch (JMSException jmse) {
            logger.warn("", jmse);
            XAException xae = new XAException(-7);
            xae.initCause(jmse);
            throw xae;
        }
    }

    public long getResourceManagerId() {
        return this.resourceManagerId;
    }

    protected static synchronized void setState(Object key, Object value) {
        xaTable.put(key, value);
    }

    protected static synchronized Integer getState(Object key) {
        return (Integer)xaTable.get(key);
    }

    protected static synchronized Object removeXid(Object key) {
        return xaTable.remove(key);
    }

    protected static synchronized boolean isPrepared(Object key) {
        boolean st = false;
        Integer value = (Integer)xaTable.get(key);
        if (value != null && value.intValue() == XA_PREPARE.intValue()) {
            st = true;
        }
        return st;
    }

    protected static synchronized boolean isRollbackOnly(Object key) {
        boolean st = false;
        Integer value = (Integer)xaTable.get(key);
        if (value != null && value.intValue() == XA_ROLLBACK_ONLY.intValue()) {
            st = true;
        }
        return st;
    }

    @Override
    public synchronized int prepare(Xid foreignXid) throws XAException {
        int result = 0;
        JMQXid jmqXid = null;
        if (this._connection.isConnectedToHABroker) {
            jmqXid = new JMQXid(foreignXid);
        }
        try {
            this.prepare(foreignXid, false);
        }
        catch (XAException xae) {
            if (this._connection.isConnectedToHABroker) {
                this.checkPrepareStatus(xae, jmqXid);
            }
            throw xae;
        }
        if (this.isXATracking()) {
            xaTable.put(jmqXid, XA_PREPARE);
        }
        return result;
    }

    private boolean isXATracking() {
        return this._connection.isConnectedToHABroker() && XATracking;
    }

    private void checkPrepareStatus(XAException xae, JMQXid jmqXid) throws XAException {
        if (!this._connection.tmqiReconnect) {
            throw xae;
        }
        try {
            SessionImpl.yield();
            this._connection.checkReconnecting(null);
            if (this._connection.isCloseCalled || this._connection.connectionIsBroken) {
                throw xae;
            }
            this.verifyPrepare(jmqXid);
        }
        catch (XAException xae2) {
            throw xae2;
        }
        catch (Exception e) {
            XAException xae3 = new XAException(-7);
            xae3.initCause(e);
            throw xae3;
        }
    }

    private void verifyPrepare(JMQXid jmqXid) throws XAException, JMSException {
        SessionImpl.sessionLogger.log(Level.INFO, "XA verifyPrepare(), jmqXid: " + jmqXid);
        int state = this._connection.protocolHandler.verifyHATransaction(0L, 1, jmqXid);
        switch (state) {
            case 6: {
                SessionImpl.sessionLogger.log(Level.INFO, "transaction in prepared state: " + jmqXid);
                return;
            }
        }
        XAException xae = new XAException(100);
        throw xae;
    }

    private void HAOnePhaseCommit(Xid foreignXid, JMQXid jmqXid) throws JMSException, XAException {
        int tstate = 1;
        try {
            this.prepare(foreignXid, true);
            tstate = 2;
            if (this.isXATracking()) {
                xaTable.put(jmqXid, XAResourceForRA.XA_PREPARE);
            }
            this._connection.getProtocolHandler().commit(0L, 0, jmqXid, true);
        }
        catch (Exception jmse) {
            this.checkCommitStatus(jmse, tstate, jmqXid, true);
        }
        XAResourceImpl.removeXid(jmqXid);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void HATwoPhaseCommit(JMQXid jmqXid) throws JMSException, XAException {
        block2: {
            try {
                this._connection.getProtocolHandler().commit(0L, 0, jmqXid);
            }
            catch (JMSException jmse) {
                if (!this.isXATracking()) throw jmse;
                Integer ts = (Integer)xaTable.get(jmqXid);
                if (ts == null || ts != 2) break block2;
                this.checkCommitStatus((Exception)((Object)jmse), 2, jmqXid, false);
            }
        }
        XAResourceImpl.removeXid(jmqXid);
    }

    private void checkCommitStatus(Exception cause, int tstate, JMQXid jmqXid, boolean onePhase) throws JMSException, XAException {
        try {
            this.doCheckCommitStatus(cause, tstate, jmqXid, onePhase);
        }
        catch (Exception ex) {
            if (ex instanceof JMSException) {
                throw (JMSException)((Object)ex);
            }
            if (ex instanceof XAException) {
                throw (XAException)ex;
            }
            XAException xae = new XAException(-7);
            xae.initCause(ex);
            throw xae;
        }
    }

    private void doCheckCommitStatus(Exception cause, int tstate, JMQXid jmqXid, boolean onePhase) throws Exception {
        if (!this._connection.tmqiReconnect) {
            throw cause;
        }
        SessionImpl.yield();
        this._connection.checkReconnecting(null);
        if (this._connection.isCloseCalled || this._connection.connectionIsBroken) {
            throw cause;
        }
        this.verifyTransaction(tstate, jmqXid, onePhase);
    }

    private void verifyTransaction(int tstate, JMQXid jmqXid, boolean onePhase) throws JMSException, XAException {
        int state = this._connection.protocolHandler.verifyHATransaction(0L, tstate, jmqXid);
        switch (state) {
            case 7: {
                return;
            }
            case 6: {
                try {
                    SessionImpl.sessionLogger.log(Level.INFO, "XA verifyTransaction(): transaction is in prepred state, committing the transaction: " + jmqXid);
                    this._connection.getProtocolHandler().commit(0L, 0, jmqXid, onePhase);
                    SessionImpl.sessionLogger.log(Level.INFO, "XA verifyTransaction(): prepared transaction committed successfully: " + jmqXid);
                    return;
                }
                catch (JMSException jmse) {
                    SessionImpl.yield();
                    this._connection.checkReconnecting(null);
                    throw jmse;
                }
            }
        }
        XAException xae = new XAException(100);
        throw xae;
    }

    private void HACommit(Xid foreignXid, JMQXid jmqXid, boolean onePhase) throws JMSException, XAException {
        if (onePhase) {
            this.HAOnePhaseCommit(foreignXid, jmqXid);
        } else {
            this.HATwoPhaseCommit(jmqXid);
        }
    }

    private void HARollback(JMQXid jmqXid) throws JMSException, XAException {
        try {
            this._connection.getProtocolHandler().rollback(0L, jmqXid, true);
        }
        catch (JMSException jmse) {
            SessionImpl.yield();
            this._connection.checkReconnecting(null);
            if (this._connection.isCloseCalled || this._connection.connectionIsBroken) {
                throw jmse;
            }
            this.retryRollBack(jmqXid);
        }
        finally {
            XAResourceImpl.removeXid(jmqXid);
        }
    }

    private void retryRollBack(JMQXid jmqXid) throws JMSException, XAException {
        try {
            this._connection.getProtocolHandler().rollback(0L, jmqXid, true, true);
        }
        catch (JMSException jmse) {
            if (this.isXATracking()) {
                Integer tstate = (Integer)xaTable.get(jmqXid);
                if (tstate != null && tstate != 2) {
                    ConnectionImpl.connectionLogger.log(Level.WARNING, jmse.toString());
                }
                throw jmse;
            }
            throw jmse;
        }
    }
}

