/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.jms.ra.ManagedConnectionIF;
import com.tongtech.tmqi.AdministeredObject;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.RemoteAcknowledgeException;
import com.tongtech.tmqi.jmsclient.UnifiedSessionImpl;
import com.tongtech.tmqi.jmsclient.XAResourceImpl;
import java.util.logging.Level;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.TransactionInProgressException;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;

public class XASessionImpl
extends UnifiedSessionImpl
implements XASession {
    private static boolean tmqiRecreateConsumerEnabled = false;
    private volatile boolean raRemoteAckFailedFlag = false;
    private Object remoteAckSyncObj = new Object();
    private XAResourceImpl xar = new XAResourceImpl(this);

    public XASessionImpl(ConnectionImpl connection, boolean transacted, int ackMode) throws JMSException {
        super(connection, transacted, ackMode);
    }

    public XASessionImpl(ConnectionImpl connection, boolean transacted, int ackMode, ManagedConnectionIF mc) throws JMSException {
        super(connection, transacted, ackMode, mc);
    }

    public XAResource getXAResource() {
        return this.xar;
    }

    @Override
    public boolean getTransacted() throws JMSException {
        this.checkSessionState();
        if (this.xaTxnMode) {
            return true;
        }
        return this.isTransacted;
    }

    @Override
    public void commit() throws JMSException {
        if (this.xaTxnMode) {
            String error = AdministeredObject.cr.getKString("C4069");
            throw new TransactionInProgressException(error);
        }
        super.commit();
    }

    @Override
    public void rollback() throws JMSException {
        if (this.xaTxnMode) {
            String error = AdministeredObject.cr.getKString("C4069");
            throw new TransactionInProgressException(error);
        }
        super.rollback();
    }

    public Session getSession() throws JMSException {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recreateConsumerForRA() {
        Object object = this.remoteAckSyncObj;
        synchronized (object) {
            try {
                sessionLogger.log(Level.FINEST, "Re-create message consumer for RA starting ...");
                this.recreateConsumers();
                sessionLogger.log(Level.FINEST, "Re-create message consumer for RA finished ...");
                this.raRemoteAckFailedFlag = false;
            }
            catch (Exception jmse) {
                sessionLogger.log(Level.SEVERE, jmse.getMessage(), jmse);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRemoteAcknowledgeException(RemoteAcknowledgeException rae) {
        if (this.raRemoteAckFailedFlag) {
            return;
        }
        Object object = this.remoteAckSyncObj;
        synchronized (object) {
            if (this.raRemoteAckFailedFlag) {
                return;
            }
            boolean matched = this.matchConsumerIDs(rae);
            if (matched) {
                this.raRemoteAckFailedFlag = true;
            }
        }
    }

    public boolean isRemoteAckFailed() {
        return this.raRemoteAckFailedFlag;
    }

    @Override
    public void stopSession() throws JMSException {
        super.stopSession();
    }

    public void logException(Exception ex) {
        sessionLogger.log(Level.SEVERE, ex.getMessage(), ex);
    }
}

