/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient.logging;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.io.ReadOnlyPacket;
import java.util.Date;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class PacketFormatter
extends SimpleFormatter {
    static Logger logger = LoggerFactory.getLogger(PacketFormatter.class);

    @Override
    public synchronized String format(LogRecord record) {
        String str = PacketFormatter.doFormat(record);
        if (str == null) {
            str = super.format(record);
        }
        return str;
    }

    public static String doFormat(LogRecord record) {
        String lstring = null;
        ReadOnlyPacket pkt = PacketFormatter.getPacket(record);
        if (pkt != null) {
            long time = record.getMillis();
            Date date = new Date();
            date.setTime(time);
            lstring = date.toString() + "  " + record.getMessage() + "\n";
            lstring = lstring + PacketFormatter.formatPkt(pkt);
        }
        return lstring;
    }

    public static ReadOnlyPacket getPacket(LogRecord record) {
        ReadOnlyPacket pkt = null;
        Object[] obj = record.getParameters();
        if (obj != null) {
            for (int i = 0; i < obj.length; ++i) {
                if (!(obj[i] instanceof ReadOnlyPacket)) continue;
                pkt = (ReadOnlyPacket)obj[i];
                break;
            }
        }
        return pkt;
    }

    public static String formatPkt(ReadOnlyPacket pkt) {
        String out = null;
        try {
            pkt.dump(logger);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return out;
    }
}

