/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient.notification;

import com.tongtech.jms.notification.ConnectionClosedEvent;
import com.tongtech.jms.notification.ConnectionClosingEvent;
import com.tongtech.jms.notification.ConnectionReconnectFailedEvent;
import com.tongtech.jms.notification.ConnectionReconnectedEvent;
import com.tongtech.jms.notification.Event;
import com.tongtech.jms.notification.EventListener;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.SequentialQueue;
import com.tongtech.tmqi.jmsclient.notification.BrokerAddressListChangedEvent;
import com.tongtech.tmqi.jmsclient.notification.ConnectionExitEvent;
import com.tongtech.tmqi.jmsclient.resources.ClientResources;
import java.util.Date;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;

public class EventHandler
implements Runnable {
    static Logger logger = LoggerFactory.getLogger(EventHandler.class);
    private ConnectionImpl connection = null;
    private Thread handlerThread = null;
    protected static final String iEventHandler = "iEventHandler-";
    private SequentialQueue eventQueue = null;
    private boolean isClosed = false;
    private boolean closedEventdelivered = false;
    private ExceptionListener exlistener = null;
    public static final long WAIT_TIMEOUT = 120000L;
    private static boolean debugEvent = Boolean.getBoolean("tmqi.debug.notification");

    public EventHandler(ConnectionImpl conn) {
        this.connection = conn;
        this.init();
    }

    private void init() {
        this.eventQueue = new SequentialQueue(2);
    }

    private synchronized void onEvent(Event event) {
        if (logger.isTraceEnabled()) {
            logger.trace("{}-- event triggerred, code = {}, msg ={} ", new Object[]{new Date(), event.getEventCode(), event.getEventMessage()});
        }
        if (this.isClosed) {
            return;
        }
        this.eventQueue.enqueue(event);
        if (this.handlerThread == null) {
            this.createHandlerThread();
        }
        this.notifyAll();
    }

    public synchronized void close() {
        this.isClosed = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createHandlerThread() {
        EventHandler eventHandler = this;
        synchronized (eventHandler) {
            if (this.handlerThread == null) {
                this.handlerThread = new Thread(this);
                if (this.connection.hasDaemonThreads()) {
                    this.handlerThread.setDaemon(true);
                }
                this.handlerThread.setName(iEventHandler + this.connection.getLocalID());
                this.handlerThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean timeoutExit = false;
        boolean keepRunning = true;
        while (keepRunning) {
            if (logger.isTraceEnabled()) {
                logger.trace("EventHandler  before  ");
            }
            timeoutExit = false;
            EventHandler eventHandler = this;
            synchronized (eventHandler) {
                if (this.shouldWait()) {
                    try {
                        this.wait(120000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (this.isClosed) {
                return;
            }
            if (this.eventQueue.isEmpty()) {
                timeoutExit = true;
            } else {
                Event event = (Event)this.eventQueue.dequeue();
                if (event instanceof ConnectionExitEvent) {
                    this.deliverException(event);
                } else {
                    this.deliverEvent(event);
                }
            }
            keepRunning = this.shouldContinue(timeoutExit);
            if (!logger.isTraceEnabled()) continue;
            logger.trace("ConsumerReader  after  ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverException(Event event) {
        try {
            if (this.exlistener != null && !this.isClosed) {
                ConnectionExitEvent exitEvent = (ConnectionExitEvent)event;
                JMSException jmse = exitEvent.getJMSException();
                this.exlistener.onException(jmse);
                if (debugEvent && logger.isTraceEnabled()) {
                    logger.trace("{} Exception is delivered to the listener: {}", new Date(), (Object)jmse);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.isClosed = true;
        }
    }

    private boolean shouldWait() {
        return this.eventQueue.isEmpty() && this.connection.getEventListener() != null && !this.isClosed;
    }

    private synchronized boolean shouldContinue(boolean timeoutExit) {
        boolean keepRunning = true;
        if (this.isClosed || timeoutExit && this.eventQueue.isEmpty()) {
            this.handlerThread = null;
            keepRunning = false;
        }
        return keepRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverEvent(Event event) {
        EventListener listener = this.connection.getEventListener();
        try {
            if (this.shouldDeliver(listener, event)) {
                listener.onEvent(event);
                if (debugEvent && logger.isTraceEnabled()) {
                    logger.trace("{}*** Delivered event, code = {}, msg = {}", new Object[]{new Date(), event.getEventCode(), event.getEventMessage()});
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            this.postEventProcess(event);
        }
    }

    private boolean shouldDeliver(EventListener listener, Event event) {
        boolean canDeliver = true;
        if (listener == null || this.isClosed) {
            canDeliver = false;
        } else if (event instanceof ConnectionClosedEvent && this.closedEventdelivered) {
            canDeliver = false;
        }
        return canDeliver;
    }

    private void postEventProcess(Event event) {
        String eid = event.getEventCode();
        if (event instanceof ConnectionReconnectedEvent) {
            this.connection.setReconnecting(false);
            this.closedEventdelivered = false;
            this.startConnection();
        } else if (event instanceof ConnectionClosedEvent) {
            this.closedEventdelivered = true;
        }
    }

    private void startConnection() {
        try {
            if (!this.connection.getIsStopped()) {
                this.connection.getProtocolHandler().start();
            }
        }
        catch (Exception e) {
            logger.warn("", e);
        }
    }

    public void triggerConnectionClosedEvent(String evCode, JMSException jmse) {
        if (this.connection.getEventListener() == null) {
            return;
        }
        String evMessage = ClientResources.getResources().getKString(evCode, this.connection.getLastContactedBrokerAddress());
        if (evCode.equals("E207")) {
            evMessage = evMessage + ", " + "tmqiAckTimeout" + ": " + this.connection.getTimeout();
        }
        ConnectionClosedEvent event = new ConnectionClosedEvent(this.connection, evCode, evMessage, jmse);
        this.onEvent(event);
    }

    public void triggerConnectionClosingEvent(String evCode, long timePeriod) {
        if (this.connection.getEventListener() == null) {
            return;
        }
        String millisecs = String.valueOf(timePeriod);
        String secs = String.valueOf(timePeriod / 1000L);
        Object[] params = new Object[]{secs, millisecs, this.connection.getLastContactedBrokerAddress()};
        String evMessage = ClientResources.getResources().getKString(evCode, params);
        ConnectionClosingEvent event = new ConnectionClosingEvent(this.connection, evCode, evMessage, timePeriod);
        this.onEvent(event);
    }

    public void triggerConnectionReconnectFailedEvent(JMSException jmse, String brokerAddr) {
        if (this.connection.getEventListener() == null) {
            return;
        }
        String evCode = "E401";
        String evMessage = ClientResources.getResources().getKString(evCode, brokerAddr);
        ConnectionReconnectFailedEvent event = new ConnectionReconnectFailedEvent(this.connection, evCode, evMessage, jmse);
        this.onEvent(event);
    }

    public void triggerConnectionReconnectedEvent() {
        if (this.connection.getEventListener() == null) {
            return;
        }
        String brokerAddr = this.connection.getBrokerAddress();
        String evCode = "E301";
        String evMessage = ClientResources.getResources().getKString(evCode, brokerAddr);
        ConnectionReconnectedEvent event = new ConnectionReconnectedEvent(this.connection, evCode, evMessage);
        this.onEvent(event);
    }

    public void triggerConnectionExitEvent(JMSException jmse, ExceptionListener listener) {
        try {
            if (this.connection.getEventListener() == null) {
                return;
            }
            this.exlistener = listener;
            ConnectionExitEvent event = new ConnectionExitEvent(this.connection, "E500", jmse.getMessage(), jmse);
            this.onEvent(event);
        }
        catch (Exception ex) {
            logger.warn("", ex);
        }
    }

    public void triggerConnectionAddressListChangedEvent(String addrList) {
        if (this.connection.getEventListener() == null) {
            return;
        }
        String evCode = "E600";
        String evMessage = ClientResources.getResources().getKString(evCode, addrList);
        BrokerAddressListChangedEvent event = new BrokerAddressListChangedEvent(this.connection, evCode, evMessage, addrList);
        this.onEvent(event);
    }
}

