/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient.zip;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.jms.JMSException;

public class Decompressor {
    static Logger logger = LoggerFactory.getLogger(Decompressor.class);
    private Inflater inflater = new Inflater(false);
    private static Decompressor decompressor = new Decompressor();
    private boolean debug = Boolean.getBoolean("tmqi.zip.debug");

    private Decompressor() {
    }

    public static Decompressor getInstance() {
        return decompressor;
    }

    public synchronized void decompress(byte[] zipBody, byte[] unzipBody) throws JMSException {
        Inflater inf = this.getDefaultInflater();
        try {
            inf.setInput(zipBody);
            int uncompressedSize = inf.inflate(unzipBody);
            if (uncompressedSize != unzipBody.length) {
                throw new JMSException("Error occurred in decompression. unzip size: " + uncompressedSize + " expected size: " + unzipBody.length);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("*** decompressor zip size: {}", zipBody.length);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("*** decompressor unzip size: {}", uncompressedSize);
            }
        }
        catch (DataFormatException e) {
            JMSException jmse = new JMSException(e.toString());
            jmse.setLinkedException((Exception)e);
            throw jmse;
        }
        finally {
            inf.reset();
        }
    }

    private Inflater getDefaultInflater() {
        return this.inflater;
    }
}

