/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmscluster_v2;

import com.tongtech.backport.java.util.concurrent.ConcurrentHashMap;
import com.tongtech.backport.java.util.concurrent.CopyOnWriteArrayList;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.TopicConnectionFactory;
import com.tongtech.tmqi.jmscluster_v2.CheckClusConnThead;
import com.tongtech.tmqi.jmscluster_v2.ClusConnectionFactory;
import com.tongtech.tmqi.jmscluster_v2.ClusSession;
import com.tongtech.tmqi.jmscluster_v2.ConntionMemberKey;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;

public class ClusConnection
implements TopicConnection,
QueueConnection,
Connection {
    static Logger logger = LoggerFactory.getLogger(ClusConnection.class);
    private static final int CLUSTERCONNECTION_SEQ = 0;
    private int strategy = 1;
    static final int CLUSTERCONNECTION_STATE_INIT = 0;
    static final int CLUSTERCONNECTION_STATE_WORK = 1;
    static final int CLUSTERCONNECTION_STATE_WAITSTOP = 2;
    static final int CLUSTERCONNECTION_STATE_STOP = 3;
    static final int CLUSTERCONNECTION_STATE_CLOSE = 3;
    public final int RECONN_TIME_INTERVALE = 30000;
    static final String CLUSTERCONNECTION_MEMBER_STATE_CLOSED = "0";
    static final String CLUSTERCONNECTION_MEMBER_STATE_OK = "1";
    static final String CLUSTERCONNECTION_MEMBER_STATE_RECONN = "2";
    static final String CLUSTERCONNECTION_MEMBER_STATE_DEL = "3";
    private ConcurrentHashMap clusterConectionMembers = new ConcurrentHashMap();
    private ConcurrentHashMap clusterConectionMemberStates = new ConcurrentHashMap();
    private ConcurrentHashMap clusterSessions = new ConcurrentHashMap();
    private boolean stopped = false;
    private int sessionId = 0;
    private String clientID;
    private final CopyOnWriteArrayList connTempQueues = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList connTempTopics = new CopyOnWriteArrayList();
    private ClusConnectionFactory clusterFactory;
    private List jmsServerUrls = new CopyOnWriteArrayList();
    public int MaxreSendcount;
    private int maxConnsPerClusterMember;
    private boolean isXA = false;
    private CheckClusConnThead checkThread;
    private int clusterConnionState = 0;

    public synchronized int getNewSessionId() {
        return this.sessionId++;
    }

    public int getClusterConnionState() {
        return this.clusterConnionState;
    }

    public void setClusterConnionState(int clusterConnionState) {
        this.clusterConnionState = clusterConnionState;
    }

    public ClusConnection(ClusConnectionFactory cluConnectionFactory) {
        this.clusterFactory = cluConnectionFactory;
        this.maxConnsPerClusterMember = cluConnectionFactory.maxConnsPerClusterMember;
    }

    public ClusConnection newInstance() {
        return new ClusConnection(this.clusterFactory);
    }

    public void createConnsMembers(String connectionKey) throws JMSException {
        String url = null;
        if (connectionKey == null) {
            throw new JMSException("connectionKey is null");
        }
        try {
            url = ConntionMemberKey.GetUrlFromConnectionKey(connectionKey);
            if (url == null) {
                throw new JMSException("url is null");
            }
            Connection conn = this.clusterFactory.createConnectionMember(url, null, null);
            if (this.clientID != null) {
                conn.setClientID(this.clientID);
            }
            conn.start();
            this.clusterConectionMembers.put(connectionKey, conn);
            ClusConnection.setConntionMemberStateOK(this.clusterConectionMemberStates, connectionKey);
        }
        catch (JMSException e) {
            ClusConnection.setConntionMemberStateOK(this.clusterConectionMemberStates, connectionKey);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createConns() throws JMSException {
        this.assertNotClosed();
        ConntionMemberKey connkey = null;
        logger.trace("cluster connection start ctreate connection!!! ");
        if (this.getClusterConnionState() != 0) {
            throw new JMSException("conn has started!!");
        }
        if (this.jmsServerUrls == null) {
            throw new JMSException("jmsServerUrls is null, in ClusConnection!");
        }
        this.MaxreSendcount = this.jmsServerUrls.size() * this.clusterFactory.maxConnsPerClusterMember * 2;
        for (int i = 0; i < this.jmsServerUrls.size(); ++i) {
            String url = (String)this.jmsServerUrls.get(i);
            for (int j = 0; j < this.clusterFactory.getMaxConnsPerClusterMember(); ++j) {
                try {
                    connkey = new ConntionMemberKey(this.clusterConectionMemberStates, this.clientID, this.jmsServerUrls, this.maxConnsPerClusterMember);
                    Connection conn = this.clusterFactory.createConnectionMember(url, null, null);
                    this.clusterConectionMembers.put(connkey.getMyKey(url, j), conn);
                    ClusConnection.setConntionMemberStateOK(this.clusterConectionMemberStates, connkey.getMyKey(url, j));
                }
                catch (Exception e) {
                    ClusConnection.setConntionMemberStateRecon(this.clusterConectionMemberStates, connkey.getMyKey(url, j));
                    logger.error("cluster connection: ctreate connection[url:" + url + "] error:" + e);
                }
                continue;
            }
        }
        if (this.clusterConectionMembers.isEmpty()) {
            logger.error("cluster connection: conn to all server fail!");
            throw new JMSException("conn to all server fail!");
        }
        this.checkThread = new CheckClusConnThead(this);
        this.checkThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        ClusConnection clusConnection = this;
        synchronized (clusConnection) {
            this.setClusterConnionState(2);
            for (int looptime = 20; looptime > 0 && this.getClusterConnionState() != 3; --looptime) {
                try {
                    Thread.sleep(30L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.stopped = true;
            try {
                for (Object clusterSessionskey : this.clusterSessions.keySet()) {
                    ClusSession clusterSession = (ClusSession)this.clusterSessions.get(clusterSessionskey);
                    if (clusterSession != null) {
                        clusterSession.close();
                    }
                    this.clusterSessions.remove(clusterSessionskey);
                }
                for (Object connectionkey : this.clusterConectionMembers.keySet()) {
                    Connection connection = (Connection)this.clusterConectionMembers.get(connectionkey);
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    this.clusterConectionMembers.remove(connectionkey);
                }
            }
            catch (JMSException e) {
                throw e;
            }
            finally {
                this.setClusterConnionState(3);
            }
        }
    }

    public void start() throws JMSException {
        this.assertNotClosed();
        for (String connectionkey : this.clusterConectionMembers.keySet()) {
            Connection connection = (Connection)this.clusterConectionMembers.get(connectionkey);
            if (connection == null) continue;
            connection.start();
        }
    }

    public void stop() throws JMSException {
        this.stopped = true;
        for (String connectionkey : this.clusterConectionMembers.keySet()) {
            Connection connection = (Connection)this.clusterConectionMembers.get(connectionkey);
            if (connection == null) continue;
            connection.stop();
        }
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) throws JMSException {
        this.clientID = clientID;
        for (String connectionkey : this.clusterConectionMembers.keySet()) {
            Connection connection = (Connection)this.clusterConectionMembers.get(connectionkey);
            if (connection == null) continue;
            connection.setClientID(clientID);
        }
    }

    public QueueSession createQueueSession(boolean transacted, int ackMode) throws JMSException {
        return (QueueSession)this.mycreateSession(transacted, ackMode, ClusSession.CLU_SESSION__TYPE_QUEUEQUESESSION);
    }

    public TopicSession createTopicSession(boolean transacted, int ackMode) throws JMSException {
        if (!(this.getClusterFactory().getFac() instanceof TopicConnectionFactory)) {
            logger.error("cluster connection is not topicConntion,please check FactoryName[" + this.getClusterFactory().getFactoryName() + "] config on server !! ");
            throw new JMSException("cluster connection is not topicConntion,please check FactoryName[" + this.getClusterFactory().getFactoryName() + "] config on server !! ");
        }
        return (TopicSession)this.mycreateSession(transacted, ackMode, ClusSession.CLU_SESSION__TYPE_TOPICSESSION);
    }

    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        int newSessionid = this.getNewSessionId();
        ClusSession session = new ClusSession(this, newSessionid, transacted, ackMode);
        session.createClusterSession(this.isXA);
        this.clusterSessions.put(new Integer(newSessionid), session);
        return session;
    }

    public Session mycreateSession(boolean transacted, int ackMode, int sessionType) throws JMSException {
        int newSessionid = this.getNewSessionId();
        ClusSession session = new ClusSession(this, newSessionid, transacted, ackMode);
        session.setSessionType(sessionType);
        session.createClusterSession(this.isXA);
        this.clusterSessions.put(new Integer(newSessionid), session);
        return session;
    }

    protected void assertNotClosed() {
        if (this.getClusterConnionState() == 3) {
            throw new IllegalStateException();
        }
    }

    public String toString() {
        return "ClusConnection urls={ " + this.jmsServerUrls + " }";
    }

    protected void cleanupConnectionTemporaryDestinations() {
        for (TemporaryQueue tempQueue : this.connTempQueues) {
            try {
                tempQueue.delete();
            }
            catch (JMSException ex) {
                logger.info("failed to delete Temporary Queue \"" + tempQueue.toString() + "\" on closing pooled connection: " + ex.getMessage());
            }
        }
        this.connTempQueues.clear();
        for (TemporaryTopic tempTopic : this.connTempTopics) {
            try {
                tempTopic.delete();
            }
            catch (JMSException ex) {
                logger.error("failed to delete Temporary Topic \"" + tempTopic.toString() + "\" on closing pooled connection: " + ex.getMessage());
            }
        }
        this.connTempTopics.clear();
    }

    public ConcurrentHashMap getClusterConectionMembers() {
        return this.clusterConectionMembers;
    }

    public void setClusterConectionMembers(ConcurrentHashMap clusterConectionMembers) {
        this.clusterConectionMembers = clusterConectionMembers;
    }

    public int getStrategy() {
        return this.strategy;
    }

    public void setStrategy(int strategy) {
        this.strategy = strategy;
    }

    public int getMaxreSendcount() {
        return this.MaxreSendcount;
    }

    public void setMaxreSendcount(int maxreSendcount) {
        this.MaxreSendcount = maxreSendcount;
    }

    public ConnectionConsumer createConnectionConsumer(Topic arg0, String arg1, ServerSessionPool arg2, int arg3) throws JMSException {
        return null;
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic arg0, String arg1, String arg2, ServerSessionPool arg3, int arg4) throws JMSException {
        return null;
    }

    public ConnectionConsumer createConnectionConsumer(Destination arg0, String arg1, ServerSessionPool arg2, int arg3) throws JMSException {
        return null;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return null;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return null;
    }

    public void setExceptionListener(ExceptionListener arg0) throws JMSException {
    }

    public ConnectionConsumer createConnectionConsumer(Queue arg0, String arg1, ServerSessionPool arg2, int arg3) throws JMSException {
        return null;
    }

    public List getJmsServerUrls() {
        return this.jmsServerUrls;
    }

    public void setJmsServerUrls(List jmsServerUrls) {
        this.jmsServerUrls.clear();
        for (int i = 0; i < jmsServerUrls.size(); ++i) {
            this.jmsServerUrls.add(jmsServerUrls.get(i));
        }
    }

    public void AddJmsServerUrls(String url) {
        this.jmsServerUrls.add(url);
    }

    public void delJmsServerUrls(int index) {
        this.jmsServerUrls.remove(index);
    }

    public ConcurrentHashMap getClusterConectionMemberStates() {
        return this.clusterConectionMemberStates;
    }

    public void setClusterConectionMemberStates(ConcurrentHashMap clusterConectionMemberStates) {
        this.clusterConectionMemberStates = clusterConectionMemberStates;
    }

    public int getMaxConnsPerClusterMember() {
        return this.maxConnsPerClusterMember;
    }

    public void setMaxConnsPerClusterMember(int maxConnsPerClusterMember) {
        this.maxConnsPerClusterMember = maxConnsPerClusterMember;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkConntionMemberStateOK(ConcurrentHashMap clusterConectionMemberStates, String connkey) {
        ConcurrentHashMap concurrentHashMap = clusterConectionMemberStates;
        synchronized (concurrentHashMap) {
            String connmemstate = (String)clusterConectionMemberStates.get(connkey);
            return connmemstate != null && connmemstate.equals(CLUSTERCONNECTION_MEMBER_STATE_OK);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConntionMemberStateOK(ConcurrentHashMap clusterConectionMemberStates, String connkey) {
        ConcurrentHashMap concurrentHashMap = clusterConectionMemberStates;
        synchronized (concurrentHashMap) {
            clusterConectionMemberStates.put(connkey, CLUSTERCONNECTION_MEMBER_STATE_OK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConntionMemberStateRecon(ConcurrentHashMap clusterConectionMemberStates, String connkey) {
        ConcurrentHashMap concurrentHashMap = clusterConectionMemberStates;
        synchronized (concurrentHashMap) {
            clusterConectionMemberStates.put(connkey, CLUSTERCONNECTION_MEMBER_STATE_RECONN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConntionMemberStateDel(ConcurrentHashMap clusterConectionMemberStates, String connkey) {
        ConcurrentHashMap concurrentHashMap = clusterConectionMemberStates;
        synchronized (concurrentHashMap) {
            clusterConectionMemberStates.put(connkey, CLUSTERCONNECTION_MEMBER_STATE_DEL);
        }
    }

    public boolean isXA() {
        return this.isXA;
    }

    public void setXA(boolean isXA) {
        this.isXA = isXA;
    }

    public ClusConnectionFactory getClusterFactory() {
        return this.clusterFactory;
    }

    public void setClusterFactory(ClusConnectionFactory clusterFactory) {
        this.clusterFactory = clusterFactory;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    public ConcurrentHashMap getClusterSessions() {
        return this.clusterSessions;
    }

    public void setClusterSessions(ConcurrentHashMap clusterSessions) {
        this.clusterSessions = clusterSessions;
    }
}

