/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmscluster_v2;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.ConnectionFactory;
import com.tongtech.tmqi.QueueConnectionFactory;
import com.tongtech.tmqi.TopicConnectionFactory;
import com.tongtech.tmqi.XAConnectionFactory;
import com.tongtech.tmqi.XAQueueConnectionFactory;
import com.tongtech.tmqi.XATopicConnectionFactory;
import com.tongtech.tmqi.jmscluster_v2.ClusConnection;
import com.tongtech.tmqi.jmscluster_v2.XaClusConnection;
import java.util.List;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.TopicConnection;
import javax.jms.XAConnection;
import javax.jms.XATopicConnection;
import javax.transaction.TransactionManager;

public class ClusConnectionFactory
implements javax.jms.ConnectionFactory,
javax.jms.TopicConnectionFactory,
javax.jms.QueueConnectionFactory,
javax.jms.XAConnectionFactory {
    static Logger logger = LoggerFactory.getLogger(ClusConnectionFactory.class);
    public static final int STRATEGY_FAILOVER = 0;
    public static final int STRATEGY_LOADBALANCING = 1;
    public static final long STRATEGY_FAILOVER_SWITCH_MASTER = 60L;
    public int maxConnsPerClusterMember = 1;
    private int strategy = 1;
    private String jndiURLS;
    private String factoryName;
    private List urls;
    public ConnectionFactory fac;
    private TransactionManager transactionManager;
    private boolean isXA = false;

    public ClusConnectionFactory(ConnectionFactory fac) {
        this.fac = fac;
        if (fac instanceof XAConnectionFactory || fac instanceof XAQueueConnectionFactory || fac instanceof XATopicConnectionFactory) {
            this.isXA = true;
        }
    }

    public int getMaxConnsPerClusterMember() {
        return this.maxConnsPerClusterMember;
    }

    public void setMaxConnsPerClusterMember(int maxConnsPerClusterMember) {
        this.maxConnsPerClusterMember = maxConnsPerClusterMember;
    }

    public int getStrategy() {
        return this.strategy;
    }

    public void setStrategy(int strategy) {
        this.strategy = strategy;
    }

    public String getJndiURLS() {
        return this.jndiURLS;
    }

    public void setJndiURLS(String jndiURLS) {
        this.jndiURLS = jndiURLS;
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(null, null);
    }

    public synchronized Connection createConnection(String userName, String password) throws JMSException {
        ClusConnection clusconn = this.fac instanceof XAConnectionFactory || this.fac instanceof XAQueueConnectionFactory || this.fac instanceof XATopicConnectionFactory ? new XaClusConnection(this, null) : new ClusConnection(this);
        clusconn.setStrategy(this.getStrategy());
        clusconn.setJmsServerUrls(this.urls);
        clusconn.createConns();
        return clusconn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Connection createConnectionMember(String url, String userName, String password) throws JMSException {
        XATopicConnection conn = null;
        logger.debug("ClusConnectionFactory.createConnectionMember config=" + this.fac.getConfiguration().toString());
        Properties prop = this.fac.getConfiguration();
        prop.setProperty("tmqiAddressList", url);
        if (this.isXA) {
            if (this.fac instanceof XATopicConnectionFactory) {
                if (userName != null) return ((XATopicConnectionFactory)this.fac).createXATopicConnection(userName, password);
                if (password != null) return ((XATopicConnectionFactory)this.fac).createXATopicConnection(userName, password);
                return ((XATopicConnectionFactory)this.fac).createXATopicConnection();
            }
            if (this.fac instanceof XATopicConnectionFactory) {
                if (userName != null) return ((XATopicConnectionFactory)this.fac).createXAQueueConnection(userName, password);
                if (password != null) return ((XATopicConnectionFactory)this.fac).createXAQueueConnection(userName, password);
                return ((XATopicConnectionFactory)this.fac).createXAQueueConnection();
            }
            if (this.fac instanceof XAConnectionFactory) {
                if (userName != null) return ((XAConnectionFactory)this.fac).createXAConnection(userName, password);
                if (password != null) return ((XAConnectionFactory)this.fac).createXAConnection(userName, password);
                return ((XAConnectionFactory)this.fac).createXAConnection();
            }
            logger.error("cluster connection not suport this type ConnectionFactory={}.", this.fac);
            throw new JMSException("cluster connection not suport this type ConnectionFactory.");
        }
        if (this.fac instanceof TopicConnectionFactory) {
            if (userName != null) return ((TopicConnectionFactory)this.fac).createTopicConnection(userName, password);
            if (password != null) return ((TopicConnectionFactory)this.fac).createTopicConnection(userName, password);
            return ((TopicConnectionFactory)this.fac).createTopicConnection();
        }
        if (this.fac instanceof QueueConnectionFactory) {
            if (userName != null) return ((QueueConnectionFactory)this.fac).createQueueConnection(userName, password);
            if (password != null) return ((QueueConnectionFactory)this.fac).createQueueConnection(userName, password);
            return ((QueueConnectionFactory)this.fac).createQueueConnection();
        }
        if (this.fac instanceof ConnectionFactory) {
            if (userName != null) return this.fac.createConnection(userName, password);
            if (password != null) return this.fac.createConnection(userName, password);
            return this.fac.createConnection();
        }
        logger.error("cluster connection not suport this type ConnectionFactory={}.", this.fac);
        throw new JMSException("cluster connection not suport this type ConnectionFactory.");
    }

    public void close() throws com.tongtech.jms.JMSException {
    }

    public List getUrls() {
        return this.urls;
    }

    public void setUrls(List urls) {
        this.urls = urls;
    }

    public ConnectionFactory getFac() {
        return this.fac;
    }

    public void setFac(ConnectionFactory fac) {
        this.fac = fac;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public XAConnection createXAConnection() throws JMSException {
        return (XAConnection)this.createConnection();
    }

    public XAConnection createXAConnection(String arg0, String arg1) throws JMSException {
        return (XAConnection)this.createConnection(arg0, arg1);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return (TopicConnection)this.createConnection();
    }

    public TopicConnection createTopicConnection(String arg0, String arg1) throws JMSException {
        return (TopicConnection)this.createConnection(arg0, arg1);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return (QueueConnection)this.createConnection();
    }

    public QueueConnection createQueueConnection(String arg0, String arg1) throws JMSException {
        return (QueueConnection)this.createConnection(arg0, arg1);
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    public void setFactoryName(String factoryName) {
        this.factoryName = factoryName;
    }
}

