/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmscluster_v2;

import com.tongtech.backport.java.util.concurrent.ConcurrentHashMap;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.jmsclient.XAResourceImpl;
import com.tongtech.tmqi.jmscluster_v2.ClusSession;
import com.tongtech.tmqi.jmscluster_v2.ConntionMemberKey;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class ClusXAResourceImpl
implements XAResource {
    static Logger logger = LoggerFactory.getLogger(ClusXAResourceImpl.class);
    public ConcurrentHashMap xaResources = new ConcurrentHashMap();
    private ConntionMemberKey conntionMemberkey;
    private ClusSession clusSession;

    public ClusXAResourceImpl(ClusSession clusSession, ConntionMemberKey conntionMemberkey) throws JMSException {
        this.clusSession = clusSession;
        this.conntionMemberkey = conntionMemberkey;
    }

    @Override
    public void commit(Xid arg0, boolean arg1) throws XAException {
        String key = this.clusSession.getCurrentTransConntionKey();
        if (key == null) {
            throw new XAException("trans is not begain!");
        }
        logger.trace(" start  trans on connkey=" + key + " ok,xid=" + arg0);
        XAResourceImpl xar = (XAResourceImpl)this.xaResources.get(key);
        if (xar == null) {
            throw new XAException("current XAResourceImpl is notexit!");
        }
        xar.commit(arg0, arg1);
        this.clusSession.setCurrentTransConntionKey(null);
        this.clusSession.setHaveTransedNum(0);
        logger.trace(" end  trans on connkey=" + key + " ok,xid=" + arg0);
    }

    @Override
    public void end(Xid arg0, int arg1) throws XAException {
        String key = this.clusSession.getCurrentTransConntionKey();
        if (key == null) {
            throw new XAException("trans is not begain!");
        }
        XAResourceImpl xar = (XAResourceImpl)this.xaResources.get(key);
        if (xar == null) {
            throw new XAException("current XAResourceImpl is notexit!");
        }
        xar.end(arg0, arg1);
    }

    @Override
    public void forget(Xid arg0) throws XAException {
        String key = this.clusSession.getCurrentTransConntionKey();
        if (key == null) {
            throw new XAException("trans is not begain!");
        }
        XAResourceImpl xar = (XAResourceImpl)this.xaResources.get(key);
        if (xar == null) {
            throw new XAException("current XAResourceImpl is notexit!");
        }
        xar.forget(arg0);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        String key = this.clusSession.getCurrentTransConntionKey();
        if (key == null) {
            throw new XAException("trans is not begain!");
        }
        XAResourceImpl xar = (XAResourceImpl)this.xaResources.get(key);
        if (xar == null) {
            throw new XAException("current XAResourceImpl is notexit!");
        }
        return xar.getTransactionTimeout();
    }

    @Override
    public boolean isSameRM(XAResource arg0) throws XAException {
        String key = this.clusSession.getCurrentTransConntionKey();
        if (key == null) {
            throw new XAException("trans is not begain!");
        }
        XAResourceImpl xar = (XAResourceImpl)this.xaResources.get(key);
        if (xar == null) {
            throw new XAException("current XAResourceImpl is notexit!");
        }
        return xar.isSameRM(arg0);
    }

    @Override
    public int prepare(Xid arg0) throws XAException {
        String key = this.clusSession.getCurrentTransConntionKey();
        if (key == null) {
            throw new XAException("trans is not begain!");
        }
        XAResourceImpl xar = (XAResourceImpl)this.xaResources.get(key);
        if (xar == null) {
            throw new XAException("current XAResourceImpl is notexit!");
        }
        return xar.prepare(arg0);
    }

    @Override
    public Xid[] recover(int arg0) throws XAException {
        String key = this.clusSession.getCurrentTransConntionKey();
        if (key == null) {
            throw new XAException("trans is not begain!");
        }
        XAResourceImpl xar = (XAResourceImpl)this.xaResources.get(key);
        if (xar == null) {
            throw new XAException("current XAResourceImpl is notexit!");
        }
        return xar.recover(arg0);
    }

    @Override
    public void rollback(Xid arg0) throws XAException {
        String key = this.clusSession.getCurrentTransConntionKey();
        if (key == null) {
            throw new XAException("trans is not begain!");
        }
        XAResourceImpl xar = (XAResourceImpl)this.xaResources.get(key);
        if (xar == null) {
            throw new XAException("current XAResourceImpl is notexit!");
        }
        xar.rollback(arg0);
        this.clusSession.setCurrentTransConntionKey(null);
        this.clusSession.setHaveTransedNum(0);
        logger.trace("rollback end  trans on connkey=" + key + " ok");
    }

    @Override
    public boolean setTransactionTimeout(int arg0) throws XAException {
        String key = this.clusSession.getCurrentTransConntionKey();
        if (key == null) {
            throw new XAException("trans is not begain!");
        }
        XAResourceImpl xar = (XAResourceImpl)this.xaResources.get(key);
        if (xar == null) {
            throw new XAException("current XAResourceImpl is notexit!");
        }
        return xar.setTransactionTimeout(arg0);
    }

    @Override
    public void start(Xid arg0, int arg1) throws XAException {
        String connkey;
        if (this.clusSession.getCurrentTransConntionKey() != null) {
            connkey = this.clusSession.getCurrentTransConntionKey();
        } else {
            try {
                connkey = this.conntionMemberkey.getNextconnkey();
            }
            catch (JMSException e) {
                throw new XAException(e.getErrorCode());
            }
        }
        logger.trace("will start new trans on connkey=" + connkey);
        XAResourceImpl xar = (XAResourceImpl)this.xaResources.get(connkey);
        if (xar == null) {
            throw new XAException("current connkey{" + connkey + "} XAResourceImpl is notexit!");
        }
        xar.start(arg0, arg1);
        this.clusSession.setCurrentTransConntionKey(connkey);
        logger.trace("start new trans on connkey=" + connkey + " ok");
    }
}

