/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsservice;

import com.tongtech.tmqi.jmsservice.JMSPacketBody;
import com.tongtech.tmqi.jmsservice.JMSPacketProperties;
import com.tongtech.tmqi.jmsservice.ReverseEnumMap;
import java.util.Map;

public class JMSServiceReply {
    private JMSPacketProperties _replyProps = null;
    private JMSPacketBody _replyBody = null;
    private int _status;

    public JMSServiceReply(Map replyProps, JMSPacketBody replyBody) {
        this._replyProps = replyProps != null ? new JMSPacketProperties(replyProps) : new JMSPacketProperties();
        this._replyBody = replyBody;
        this.setStatus();
    }

    public int getStatus() {
        return this._status;
    }

    public JMSPacketProperties getProperties() {
        return this._replyProps;
    }

    public boolean getBooleanProp(String prop) throws NoSuchFieldException {
        String errMsg = "JMSServiceReply has no return property values";
        if (this._replyProps != null) {
            try {
                return (Boolean)this._replyProps.get(prop);
            }
            catch (Exception exception) {
                errMsg = "JMSServiceReply is missing boolean property -" + prop;
            }
        }
        throw new NoSuchFieldException(errMsg);
    }

    public int getIntProp(String prop) throws NoSuchFieldException {
        String errMsg = "JMSServiceReply has no return property values";
        if (this._replyProps != null) {
            try {
                return (Integer)this._replyProps.get(prop);
            }
            catch (Exception exception) {
                errMsg = "JMSServiceReply is missing int property -" + prop;
            }
        }
        throw new NoSuchFieldException(errMsg);
    }

    public long getLongProp(String prop) throws NoSuchFieldException {
        String errMsg = "JMSServiceReply has no return property values";
        if (this._replyProps != null) {
            try {
                Long _tmp = (Long)this._replyProps.get(prop);
                return _tmp;
            }
            catch (Exception exception) {
                errMsg = "JMSServiceReply is missing long property -" + prop;
            }
        }
        throw new NoSuchFieldException(errMsg);
    }

    public String getStringProp(String prop) throws NoSuchFieldException {
        String errMsg = "JMSServiceReply has no return property values";
        if (this._replyProps != null) {
            try {
                return (String)this._replyProps.get(prop);
            }
            catch (Exception exception) {
                errMsg = "JMSServiceReply is missing string property -" + prop;
            }
        }
        throw new NoSuchFieldException(errMsg);
    }

    public String getJMQVersion() throws NoSuchFieldException {
        return this.getStringProp("JMQVersion");
    }

    public long getJMQConnectionID() throws NoSuchFieldException {
        return this.getLongProp("JMQConnectionID");
    }

    public boolean getJMQHA() {
        boolean _JMQHA = false;
        try {
            _JMQHA = this.getBooleanProp("JMQHA");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return _JMQHA;
    }

    public String getJMQClusterID() {
        String _JMQClusterID = null;
        try {
            _JMQClusterID = this.getStringProp("JMQClusterID");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return _JMQClusterID;
    }

    public long getJMQMaxMsgBytes() throws NoSuchFieldException {
        return this.getLongProp("JMQMaxMsgBytes");
    }

    public String getJMQBrokerList() {
        String _JMQBrokerList = null;
        try {
            _JMQBrokerList = this.getStringProp("JMQBrokerList");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return _JMQBrokerList;
    }

    public long getJMQSessionID() throws NoSuchFieldException {
        return this.getLongProp("JMQSessionID");
    }

    public String getJMQDestination() {
        String _JMQDestination = null;
        try {
            _JMQDestination = this.getStringProp("JMQDestination");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return _JMQDestination;
    }

    public int getJMQDestType() throws NoSuchFieldException {
        int _DestinationType = this.getIntProp("JMQDestType");
        if (_DestinationType == 1) {
            return 0;
        }
        return 1;
    }

    public boolean getJMQCanCreate() {
        boolean _JMQCanCreate = false;
        try {
            _JMQCanCreate = this.getBooleanProp("JMQCanCreate");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return _JMQCanCreate;
    }

    public long getJMQProducerID() throws NoSuchFieldException {
        return this.getLongProp("JMQProducerID");
    }

    public long getJMQConsumerID() throws NoSuchFieldException {
        return this.getLongProp("JMQConsumerID");
    }

    public long getJMQTransactionID() throws NoSuchFieldException {
        return this.getLongProp("JMQTransactionID");
    }

    private void setStatus() {
        this._status = 999;
        try {
            if (this._replyProps != null) {
                try {
                    this._status = Integer.parseInt((String)this._replyProps.get("JMQStatus"));
                }
                catch (ClassCastException cce) {
                    int _replyCode;
                    Integer _tmp = (Integer)this._replyProps.get("JMQStatus");
                    this._status = _replyCode = _tmp.intValue();
                }
            }
        }
        catch (Exception e) {
            System.err.println("JMSServiceReply:setStatus:Exception:" + e.getMessage());
        }
    }

    public static class Status {
        public static final int OK = 200;
        public static final int CREATED = 201;
        public static final int MULTIPLE_CHOICES = 300;
        public static final int MOVED_PERMENANTLY = 301;
        public static final int NOT_MODIFIED = 304;
        public static final int BAD_REQUEST = 400;
        public static final int UNATUHORIZED = 401;
        public static final int PAYMENT_REQUIRED = 402;
        public static final int FORBIDDEN = 403;
        public static final int NOT_FOUND = 404;
        public static final int NOT_ALLOWED = 405;
        public static final int TIMEOUT = 408;
        public static final int CONFLICT = 409;
        public static final int PRECONDITION_FAILED = 412;
        public static final int INVALID_LOGIN = 413;
        public static final int RESOURCE_FULL = 414;
        public static final int ENTITY_TOO_LARGE = 423;
        public static final int RROR = 500;
        public static final int NOT_IMPLEMENTED = 501;
        public static final int UNAVAILABLE = 503;
        public static final int BAD_VERSION = 505;
        public static final int UNKNOWN = 999;
        private static ReverseEnumMap map = null;
        private final int _statusCode;

        Status(int statusCode) {
            this._statusCode = statusCode;
        }

        public int getStatusCode() {
            return this._statusCode;
        }

        public int convert() {
            return this._statusCode;
        }

        public Object convert(int val) {
            return map.get(val);
        }
    }
}

