/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.naming;

import com.tongtech.tmqi.AdministeredObject;
import com.tongtech.tmqi.naming.CorruptedConfigurationPropertiesException;
import com.tongtech.tmqi.naming.MissingVersionNumberException;
import com.tongtech.tmqi.naming.UnsupportedVersionNumberException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class AdministeredObjectFactory
implements ObjectFactory {
    protected static final String REF_VERSION = "version";
    protected static final String REF_READONLY = "readOnly";
    protected static final String AO_VERSION_STR = "3.0";
    protected static final String AO_VERSION_STR_JMQ3B = "2.1";
    protected static final String AO_VERSION_STR_JMQ2 = "2.0";
    protected static final String AO_VERSION_STR_JMQ1 = "1.1";

    public Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable env) throws Exception {
        if (obj instanceof Reference) {
            Reference ref = (Reference)obj;
            String version = null;
            boolean readOnly = false;
            Object newobj = Class.forName(ref.getClassName()).newInstance();
            RefAddr versionAddr = ref.get(REF_VERSION);
            if (versionAddr == null || !(newobj instanceof AdministeredObject)) {
                throw new MissingVersionNumberException();
            }
            version = (String)versionAddr.getContent();
            if (!(AO_VERSION_STR.equals(version) || AO_VERSION_STR_JMQ3B.equals(version) || AO_VERSION_STR_JMQ2.equals(version))) {
                throw new UnsupportedVersionNumberException(version);
            }
            if (ref.size() < 2) {
                throw new CorruptedConfigurationPropertiesException();
            }
            RefAddr readOnlyAddr = ref.get(REF_READONLY);
            if ("true".equals((String)readOnlyAddr.getContent())) {
                readOnly = true;
            }
            ((AdministeredObject)newobj).storedVersion = version;
            for (int i = 2; i < ref.size(); ++i) {
                RefAddr refaddr = ref.get(i);
                String refContent = (String)refaddr.getContent();
                if (refContent == null) {
                    refContent = "";
                }
                try {
                    ((AdministeredObject)newobj).setProperty(refaddr.getType(), refContent);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (readOnly) {
                ((AdministeredObject)newobj).setReadOnly();
            }
            return newobj;
        }
        return null;
    }
}

