/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.naming;

import com.tongtech.tmqi.ConnectionFactory;
import com.tongtech.tmqi.QueueConnectionFactory;
import com.tongtech.tmqi.TopicConnectionFactory;
import com.tongtech.tmqi.naming.AdministeredObjectFactory;
import com.tongtech.tmqi.naming.CorruptedConfigurationPropertiesException;
import com.tongtech.tmqi.naming.MissingVersionNumberException;
import com.tongtech.tmqi.naming.UnsupportedVersionNumberException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;

public abstract class CFObjectFactory
extends AdministeredObjectFactory {
    private static final String REF_SECURITYPORT = "securityPort";
    private static final String REF_JMSXUSERID = "JMSXUserID";
    private static final String REF_JMSXAPPID = "JMSXAppID";
    private static final String REF_JMSXPRODUCERTXID = "JMSXProducerTXID";
    private static final String REF_JMSXCONSUMERTXID = "JMSXConsumerTXID";
    private static final String REF_JMSXRCVTIMESTAMP = "JMSXRcvTimestamp";
    private static final String REF_PARM = "parm";
    private static final String REF_HOST = "host";
    private static final String REF_SUBNET = "subnet";
    private static final String REF_ACKTIMEOUT = "ackTimeout";
    private static final String REF_PARM_CONTENT = "--";
    private static final String JMSXUSERID = "JMSXUserID";
    private static final String JMSXAPPID = "JMSXAppID";
    private static final String JMSXPRODUCERTXID = "JMSXProducerTXID";
    private static final String JMSXCONSUMERTXID = "JMSXConsumerTXID";
    private static final String JMSXRCVTIMESTAMP = "JMSXRcvTimestamp";
    private static final String DEFAULT = "default";
    private static final String PREF_HOST = "-s";
    private static final String PREF_SUBNET = "-n";
    private static final String PREF_ACKTIMEOUT = "-t";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_SUBNET = 0;
    private static final int DEFAULT_SECURITYPORT = 22000;
    private static final int DEFAULT_ACKTIMEOUT = 30000;

    @Override
    public Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable env) throws Exception {
        if (obj instanceof Reference) {
            ConnectionFactory cf;
            Object parm = null;
            Object host = null;
            Object subnet = null;
            Object ackTimeout = null;
            Reference ref = (Reference)obj;
            String refClassName = ref.getClassName();
            if (refClassName.equals(QueueConnectionFactory.class.getName())) {
                cf = new QueueConnectionFactory();
            } else if (refClassName.equals(TopicConnectionFactory.class.getName())) {
                cf = new TopicConnectionFactory();
            } else {
                throw new MissingVersionNumberException();
            }
            RefAddr versionAddr = ref.get("version");
            if (versionAddr == null) {
                throw new MissingVersionNumberException();
            }
            String version = null;
            version = (String)versionAddr.getContent();
            if (!"1.1".equals(version)) {
                throw new UnsupportedVersionNumberException(version);
            }
            cf.storedVersion = version;
            String securityPort = DEFAULT;
            RefAddr securityPortAddr = ref.get(REF_SECURITYPORT);
            if (securityPortAddr == null) {
                throw new CorruptedConfigurationPropertiesException();
            }
            securityPort = (String)securityPortAddr.getContent();
            this.recreateConfigurationObject(cf, ref);
            this.setJMSXProperties(cf, ref);
            return cf;
        }
        return null;
    }

    private void recreateConfigurationObject(ConnectionFactory cf, Reference ref) throws Exception {
        String parm = null;
        String host = null;
        String subnet = null;
        String ackTimeout = null;
        try {
            parm = (String)ref.get(REF_PARM).getContent();
            host = (String)ref.get(REF_HOST).getContent();
            subnet = (String)ref.get(REF_SUBNET).getContent();
            ackTimeout = (String)ref.get(REF_ACKTIMEOUT).getContent();
        }
        catch (NullPointerException e) {
            throw new CorruptedConfigurationPropertiesException();
        }
        if (!REF_PARM_CONTENT.equals(parm)) {
            return;
        }
        int configSize = 1;
        if (!DEFAULT.equals(host)) {
            ++configSize;
        }
        if (!DEFAULT.equals(subnet)) {
            ++configSize;
        }
        if (!DEFAULT.equals(ackTimeout)) {
            ++configSize;
        }
        boolean hostSet = false;
        boolean subnetSet = false;
        boolean ackTimeoutSet = false;
        for (int i = 1; i < configSize; ++i) {
            if (!DEFAULT.equals(host) && !hostSet) {
                String hostString = host.substring(host.indexOf(PREF_HOST, 0) + 2, host.length()).trim();
                cf.setProperty("tmqiBrokerHostName", hostString);
                hostSet = true;
                continue;
            }
            if (!DEFAULT.equals(subnet) && !subnetSet) {
                subnetSet = true;
                continue;
            }
            if (DEFAULT.equals(ackTimeout) || ackTimeoutSet) continue;
            String atoString = ackTimeout.substring(ackTimeout.indexOf(PREF_ACKTIMEOUT, 0) + 2, ackTimeout.length()).trim();
            cf.setProperty("tmqiAckTimeout", atoString);
            ackTimeoutSet = true;
        }
    }

    private void setJMSXProperties(ConnectionFactory cf, Reference ref) throws Exception {
        RefAddr addr = null;
        addr = ref.get("JMSXUserID");
        if (addr != null && "true".equals((String)addr.getContent())) {
            cf.setProperty("tmqiSetJMSXUserID", "true");
        }
        if ((addr = ref.get("JMSXAppID")) != null && "true".equals((String)addr.getContent())) {
            cf.setProperty("tmqiSetJMSXAppID", "true");
        }
        if ((addr = ref.get("JMSXProducerTXID")) != null && "true".equals((String)addr.getContent())) {
            cf.setProperty("tmqiSetJMSXProducerTXID", "true");
        }
        if ((addr = ref.get("JMSXConsumerTXID")) != null && "true".equals((String)addr.getContent())) {
            cf.setProperty("tmqiSetJMSXConsumerTXID", "true");
        }
        if ((addr = ref.get("JMSXRcvTimestamp")) != null && "true".equals((String)addr.getContent())) {
            cf.setProperty("tmqiSetJMSXRcvTimestamp", "true");
        }
    }
}

