/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.naming;

import com.tongtech.tmqi.Destination;
import com.tongtech.tmqi.Queue;
import com.tongtech.tmqi.Topic;
import com.tongtech.tmqi.naming.AdministeredObjectFactory;
import com.tongtech.tmqi.naming.CorruptedConfigurationPropertiesException;
import com.tongtech.tmqi.naming.MissingVersionNumberException;
import com.tongtech.tmqi.naming.UnsupportedVersionNumberException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;

public abstract class DObjectFactory
extends AdministeredObjectFactory {
    private static final String REF_DESTNAME = "destName";

    @Override
    public Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable env) throws Exception {
        if (obj instanceof Reference) {
            Reference ref = (Reference)obj;
            String refClassName = ref.getClassName();
            Destination destObj = null;
            if (refClassName.equals(Queue.class.getName())) {
                destObj = new Queue();
            } else if (refClassName.equals(Topic.class.getName())) {
                destObj = new Topic();
            } else {
                throw new MissingVersionNumberException();
            }
            RefAddr versionAddr = ref.get("version");
            if (versionAddr == null) {
                throw new MissingVersionNumberException();
            }
            String version = null;
            version = (String)versionAddr.getContent();
            if (!"1.1".equals(version)) {
                throw new UnsupportedVersionNumberException(version);
            }
            destObj.storedVersion = version;
            RefAddr destAddr = ref.get(REF_DESTNAME);
            if (destAddr != null) {
                destObj.setProperty("tmqiDestinationName", (String)destAddr.getContent());
                return destObj;
            }
            throw new CorruptedConfigurationPropertiesException();
        }
        return null;
    }
}

