/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.naming;

import com.tongtech.backport.java.util.concurrent.ConcurrentHashMap;
import com.tongtech.jms.util.TongJMSConfig;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.ConnectionFactory;
import com.tongtech.tmqi.Queue;
import com.tongtech.tmqi.QueueConnectionFactory;
import com.tongtech.tmqi.Topic;
import com.tongtech.tmqi.TopicConnectionFactory;
import com.tongtech.tmqi.XAConnectionFactory;
import com.tongtech.tmqi.XAQueueConnectionFactory;
import com.tongtech.tmqi.XATopicConnectionFactory;
import com.tongtech.tmqi.naming.ReadOnlyContext;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;

public class TongJMSInitialContextFactory
implements InitialContextFactory {
    static Logger logger = LoggerFactory.getLogger(TongJMSInitialContextFactory.class);
    private static final String[] DEFAULT_CONNECTION_FACTORY_NAMES = new String[]{"ConnectionFactory", "QueueConnectionFactory", "TopicConnectionFactory"};
    private String connectionPrefix = "connection.";
    private String qcfPrefix = "qcf.";
    private String cfPrefix = "cf.";
    private String tcfPrefix = "tcf.";
    private String xaqcfPrefix = "xaqcf.";
    private String xacfPrefix = "xacf.";
    private String xatcfPrefix = "xatcf.";
    private String queuePrefix = "queue.";
    private String topicPrefix = "topic.";
    static Map data = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context getInitialContext(Hashtable environment) throws NamingException {
        Map map = data;
        synchronized (map) {
            TongJMSConfig conf = TongJMSConfig.getInstance();
            Properties props = conf.getProps();
            String connectionUrl = (String)environment.get("tmqiAddressList");
            if (connectionUrl == null) {
                connectionUrl = (String)props.get("tmqiAddressList");
            }
            if (connectionUrl == null) {
                String qcuName = null;
                try {
                    qcuName = TongJMSConfig.getInstance().getQcuName();
                    logger.trace("get qucname from tlclient.properties. {}", (Object)qcuName);
                }
                catch (Exception e) {
                    logger.trace("cannot read qucname from tlclient.properties.");
                }
                if (qcuName == null || qcuName.length() == 0) {
                    qcuName = "qcu1";
                }
                connectionUrl = "tlqlocal://localhost/" + qcuName;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("setting props, {},connectionURL:{}", new Integer(props.size()), (Object)connectionUrl);
            }
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String key = entry.getKey().toString();
                if (logger.isDebugEnabled()) {
                    logger.debug("key {} value {}", (Object)key, (Object)entry.getValue().toString());
                }
                if (environment.containsKey(key)) continue;
                environment.put(key, entry.getValue().toString());
            }
            this.createDefaultConnectionFactory(connectionUrl);
            this.createConnectionFactroys(data, environment, connectionUrl);
            this.createQueues(data, environment);
            this.createTopics(data, environment, props);
        }
        return this.createContext(environment, data);
    }

    private void createDefaultConnectionFactory(String connectionUrl) throws NamingException {
        try {
            if (data.get("ConnectionFactory") == null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("create factory.");
                }
                ConnectionFactory connectionFactory = null;
                connectionFactory = new ConnectionFactory();
                this.setConnectionUrl(connectionUrl, connectionFactory);
                data.put("ConnectionFactory", connectionFactory);
                connectionFactory = new QueueConnectionFactory();
                this.setConnectionUrl(connectionUrl, connectionFactory);
                data.put("QueueConnectionFactory", connectionFactory);
                connectionFactory = new TopicConnectionFactory();
                this.setConnectionUrl(connectionUrl, connectionFactory);
                data.put("TopicConnectionFactory", connectionFactory);
                connectionFactory = new XAConnectionFactory();
                this.setConnectionUrl(connectionUrl, connectionFactory);
                data.put("XAConnectionFactory", connectionFactory);
                connectionFactory = new XAQueueConnectionFactory();
                this.setConnectionUrl(connectionUrl, connectionFactory);
                data.put("XAQueueConnectionFactory", connectionFactory);
                connectionFactory = new XATopicConnectionFactory();
                this.setConnectionUrl(connectionUrl, connectionFactory);
                data.put("XATopicConnectionFactory", connectionFactory);
            }
        }
        catch (JMSException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
    }

    private void setConnectionUrl(String connectionUrl, ConnectionFactory connectionFactory) throws JMSException {
        String address = connectionFactory.getProperty("tmqiAddressList");
        if (address == null) {
            if (connectionUrl == null) {
                TongJMSConfig conf = TongJMSConfig.getInstance();
                connectionUrl = "tlqlocal://localhost/" + conf.getQcuName();
            }
            connectionFactory.setProperty("tmqiAddressList", connectionUrl);
        } else if (connectionUrl != null) {
            connectionFactory.setProperty("tmqiAddressList", connectionUrl);
        }
    }

    public String getTopicPrefix() {
        return this.topicPrefix;
    }

    public void setTopicPrefix(String topicPrefix) {
        this.topicPrefix = topicPrefix;
    }

    public String getQueuePrefix() {
        return this.queuePrefix;
    }

    public void setQueuePrefix(String queuePrefix) {
        this.queuePrefix = queuePrefix;
    }

    protected ReadOnlyContext createContext(Hashtable environment, Map data) {
        return new ReadOnlyContext(environment, data);
    }

    protected String[] getConnectionFactoryNames(Map environment) {
        String factoryNames = (String)environment.get("connectionFactoryNames");
        if (factoryNames != null) {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer enumeration = new StringTokenizer(factoryNames, ",");
            while (enumeration.hasMoreTokens()) {
                list.add(enumeration.nextToken().trim());
            }
            int size = list.size();
            if (size > 0) {
                String[] answer = new String[size];
                list.toArray(answer);
                return answer;
            }
        }
        return DEFAULT_CONNECTION_FACTORY_NAMES;
    }

    protected void createQueues(Map data, Hashtable environment) {
        for (Map.Entry entry : environment.entrySet()) {
            String jndiName;
            String key = entry.getKey().toString();
            if (!key.startsWith(this.queuePrefix) || data.get(jndiName = key.substring(this.queuePrefix.length())) != null) continue;
            data.put(jndiName, this.createQueue(entry.getValue().toString()));
            if (!logger.isTraceEnabled()) continue;
            logger.trace("create new queue obj, {}, {}", (Object)jndiName, (Object)entry.getValue().toString());
        }
    }

    protected void createTopics(Map data, Hashtable environment, Properties prop) {
        for (Map.Entry entry : environment.entrySet()) {
            String jndiName;
            String key = entry.getKey().toString();
            if (!key.startsWith(this.topicPrefix) || data.get(jndiName = key.substring(this.topicPrefix.length())) != null) continue;
            data.put(jndiName, this.createTopic(entry.getValue().toString(), prop));
            if (!logger.isTraceEnabled()) continue;
            logger.trace("create new queue obj, {}, {}", (Object)jndiName, (Object)entry.getValue().toString());
        }
    }

    protected javax.jms.Queue createQueue(String name) {
        try {
            return new Queue(name);
        }
        catch (JMSException ex) {
            ex.printStackTrace();
            throw new RuntimeException("create Queue fail.");
        }
    }

    protected javax.jms.Topic createTopic(String name, Properties prop) {
        try {
            String pubQueue;
            Topic topic = new Topic(name);
            String subQueue = (String)prop.get(name + ".SUB");
            if (subQueue != null && !subQueue.equals("")) {
                topic.setProperty("tmqiTopicSubQueueName", subQueue);
            }
            if ((pubQueue = (String)prop.get(name + ".PUB")) != null && !pubQueue.equals("")) {
                topic.setProperty("tmqiTopicPubQueueName", pubQueue);
            }
            return topic;
        }
        catch (JMSException ex) {
            throw new RuntimeException("create Topic fail.");
        }
    }

    public String getConnectionPrefix() {
        return this.connectionPrefix;
    }

    public void setConnectionPrefix(String connectionPrefix) {
        this.connectionPrefix = connectionPrefix;
    }

    private void createConnectionFactroys(Map data, Hashtable environment, String connectionUrl) {
        try {
            for (Map.Entry entry : environment.entrySet()) {
                String jndiName;
                String key = entry.getKey().toString();
                ConnectionFactory connectionFactory = null;
                if (key.startsWith(this.cfPrefix)) {
                    jndiName = key.substring(this.cfPrefix.length());
                    if (data.get(jndiName) == null) {
                        connectionFactory = new ConnectionFactory();
                        this.setConnectionUrl(connectionUrl, connectionFactory);
                        data.put(jndiName, connectionFactory);
                    }
                } else if (key.startsWith(this.qcfPrefix)) {
                    jndiName = key.substring(this.qcfPrefix.length());
                    if (data.get(jndiName) == null) {
                        connectionFactory = new QueueConnectionFactory();
                        this.setConnectionUrl(connectionUrl, connectionFactory);
                        data.put(jndiName, connectionFactory);
                    }
                } else if (key.startsWith(this.tcfPrefix)) {
                    jndiName = key.substring(this.tcfPrefix.length());
                    if (data.get(jndiName) == null) {
                        connectionFactory = new TopicConnectionFactory();
                        this.setConnectionUrl(connectionUrl, connectionFactory);
                        data.put(jndiName, connectionFactory);
                    }
                } else if (key.startsWith(this.xacfPrefix)) {
                    jndiName = key.substring(this.xacfPrefix.length());
                    if (data.get(jndiName) == null) {
                        connectionFactory = new XAConnectionFactory();
                        this.setConnectionUrl(connectionUrl, connectionFactory);
                        data.put(jndiName, connectionFactory);
                    }
                } else if (key.startsWith(this.xaqcfPrefix)) {
                    jndiName = key.substring(this.xaqcfPrefix.length());
                    if (data.get(jndiName) == null) {
                        connectionFactory = new XAQueueConnectionFactory();
                        this.setConnectionUrl(connectionUrl, connectionFactory);
                        data.put(jndiName, connectionFactory);
                    }
                } else if (key.startsWith(this.xatcfPrefix) && data.get(jndiName = key.substring(this.xatcfPrefix.length())) == null) {
                    connectionFactory = new XATopicConnectionFactory();
                    this.setConnectionUrl(connectionUrl, connectionFactory);
                    data.put(jndiName, connectionFactory);
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("create new queue obj, {}, {}", (Object)key, (Object)entry.getValue().toString());
            }
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }
}

