/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import javax.net.ServerSocketFactory;

public class MQServerSocketFactory
extends ServerSocketFactory {
    boolean reuseAddr = true;
    ServerSocketFactory ssf = null;

    protected MQServerSocketFactory() {
        this.ssf = null;
    }

    protected MQServerSocketFactory(ServerSocketFactory ssf) {
        this.ssf = ssf;
    }

    public void setReuseAddress(boolean on) {
        this.reuseAddr = on;
    }

    @Override
    public ServerSocket createServerSocket() throws IOException {
        ServerSocket ss = this.ssf != null ? this.ssf.createServerSocket() : new ServerSocket();
        ss.setReuseAddress(this.reuseAddr);
        return ss;
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        ServerSocket ss = this.createServerSocket();
        ss.bind(new InetSocketAddress(port));
        return ss;
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        ServerSocket ss = this.createServerSocket();
        ss.bind(new InetSocketAddress(port), backlog);
        return ss;
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        ServerSocket ss = this.createServerSocket();
        ss.bind(new InetSocketAddress(ifAddress, port), backlog);
        return ss;
    }

    public static ServerSocketFactory getDefault() {
        return new MQServerSocketFactory();
    }

    public static ServerSocketFactory wrapFactory(ServerSocketFactory ssf) {
        return new MQServerSocketFactory(ssf);
    }

    public static String serverSocketToString(ServerSocket s) {
        try {
            return "SO_RCVBUF=" + s.getReceiveBufferSize() + ", SO_REUSEADDR=" + s.getReuseAddress() + ", SO_TIMEOUT=" + s.getSoTimeout();
        }
        catch (IOException e) {
            return "Bad serverSocket: " + e;
        }
    }
}

