/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.pool;

import com.tongtech.jms.Connection;
import com.tongtech.jms.Session;
import com.tongtech.org.apache.commons.pool.ObjectPool;
import com.tongtech.org.apache.commons.pool.PoolableObjectFactory;
import com.tongtech.tmqi.jmsclient.UnifiedSessionImpl;
import com.tongtech.tmqi.pool.AlreadyClosedException;
import com.tongtech.tmqi.pool.ConnectionPool;
import com.tongtech.tmqi.pool.PooledSession;
import com.tongtech.tmqi.pool.SessionKey;
import javax.jms.JMSException;

public class SessionPool
implements PoolableObjectFactory {
    private ConnectionPool connectionPool;
    private SessionKey key;
    private ObjectPool sessionPool;

    public SessionPool(ConnectionPool connectionPool, SessionKey key, ObjectPool sessionPool) {
        this.connectionPool = connectionPool;
        this.key = key;
        this.sessionPool = sessionPool;
        sessionPool.setFactory(this);
    }

    public void close() throws Exception {
        if (this.sessionPool != null) {
            this.sessionPool.close();
        }
        this.sessionPool = null;
    }

    public PooledSession borrowSession() throws JMSException {
        try {
            Object object = this.getSessionPool().borrowObject();
            return (PooledSession)object;
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JMSException(e.getMessage());
        }
    }

    public void returnSession(PooledSession session) throws JMSException {
        this.getConnection();
        try {
            this.connectionPool.onSessionReturned(session);
            this.getSessionPool().returnObject(session);
        }
        catch (Exception e) {
            throw new JMSException("Failed to return session to pool: " + e);
        }
    }

    public void invalidateSession(PooledSession session) throws JMSException {
        try {
            this.connectionPool.onSessionInvalidated(session);
            this.getSessionPool().invalidateObject(session);
        }
        catch (Exception e) {
            throw new JMSException("Failed to invalidate session: " + e);
        }
    }

    @Override
    public Object makeObject() throws Exception {
        return new PooledSession((UnifiedSessionImpl)this.createSession(), this);
    }

    @Override
    public void destroyObject(Object o) throws Exception {
        PooledSession session = (PooledSession)o;
        session.getInternalSession().close();
    }

    @Override
    public boolean validateObject(Object o) {
        return true;
    }

    @Override
    public void activateObject(Object o) throws Exception {
    }

    @Override
    public void passivateObject(Object o) throws Exception {
    }

    protected ObjectPool getSessionPool() throws AlreadyClosedException {
        if (this.sessionPool == null) {
            throw new AlreadyClosedException();
        }
        return this.sessionPool;
    }

    protected Connection getConnection() throws JMSException {
        return this.connectionPool.getConnection();
    }

    protected Session createSession() throws JMSException {
        return (Session)this.getConnection().createSession(this.key.isTransacted(), this.key.getAckMode());
    }
}

