/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class FastOutputStream
extends OutputStream {
    public static final int DEFAULT_INIT_SIZE = 100;
    public static final int DEFAULT_BUMP_SIZE = 100;
    private int len;
    private int bumpLen;
    private byte[] buf;

    public FastOutputStream() {
        this.initBuffer(100, 100);
    }

    public FastOutputStream(int initialSize) {
        this.initBuffer(initialSize, 100);
    }

    public FastOutputStream(int initialSize, int bumpSize) {
        this.initBuffer(initialSize, bumpSize);
    }

    public FastOutputStream(byte[] buffer) {
        this.buf = buffer;
        this.bumpLen = 100;
    }

    public FastOutputStream(byte[] buffer, int bumpSize) {
        this.buf = buffer;
        this.bumpLen = bumpSize;
    }

    private void initBuffer(int bufferSize, int bumpLen) {
        this.buf = new byte[bufferSize];
        this.bumpLen = bumpLen;
    }

    public int size() {
        return this.len;
    }

    public void reset() {
        this.len = 0;
    }

    @Override
    public void write(int b) throws IOException {
        this.writeFast(b);
    }

    @Override
    public void write(byte[] fromBuf) throws IOException {
        this.writeFast(fromBuf);
    }

    @Override
    public void write(byte[] fromBuf, int offset, int length) throws IOException {
        this.writeFast(fromBuf, offset, length);
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.len);
    }

    public String toString() {
        return new String(this.buf, 0, this.len);
    }

    public String toString(String encoding) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.len, encoding);
    }

    public byte[] toByteArray() {
        byte[] toBuf = new byte[this.len];
        for (int i = 0; i < this.len; ++i) {
            toBuf[i] = this.buf[i];
        }
        return toBuf;
    }

    public final void writeFast(int b) {
        if (this.len + 1 > this.buf.length) {
            this.bump(1);
        }
        this.buf[this.len++] = (byte)b;
    }

    public final void writeFast(byte[] fromBuf) {
        int needed = this.len + fromBuf.length - this.buf.length;
        if (needed > 0) {
            this.bump(needed);
        }
        for (int i = 0; i < fromBuf.length; ++i) {
            this.buf[this.len++] = fromBuf[i];
        }
    }

    public final void writeFast(byte[] fromBuf, int offset, int length) {
        int needed = this.len + length - this.buf.length;
        if (needed > 0) {
            this.bump(needed);
        }
        int fromLen = offset + length;
        for (int i = offset; i < fromLen; ++i) {
            this.buf[this.len++] = fromBuf[i];
        }
    }

    public void toByteArray(byte[] toBuf, int offset) {
        int toLen = toBuf.length > this.len ? this.len : toBuf.length;
        for (int i = offset; i < toLen; ++i) {
            toBuf[i] = this.buf[i];
        }
    }

    public byte[] getBufferBytes() {
        return this.buf;
    }

    public int getBufferOffset() {
        return 0;
    }

    public int getBufferLength() {
        return this.len;
    }

    public void makeSpace(int sizeNeeded) {
        int needed = this.len + sizeNeeded - this.buf.length;
        if (needed > 0) {
            this.bump(needed);
        }
    }

    public void addSize(int sizeAdded) {
        this.len += sizeAdded;
    }

    private void bump(int needed) {
        byte[] toBuf = new byte[this.buf.length + needed + this.bumpLen];
        for (int i = 0; i < this.len; ++i) {
            toBuf[i] = this.buf[i];
        }
        this.buf = toBuf;
    }
}

