/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.util;

import com.tongtech.tmqi.util.MD5;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.util.Properties;

public class FileUtil {
    private static String magicNumberString = "%947634%";
    private static String mqversion = "4.2";
    private static String formatversion = "1.0";
    private static char[] fseq = new char[]{'\u0000', '\u0001', '\u0001', '\u0002', '\u0003', '\u0005', '\b'};

    FileUtil() {
    }

    public static void removeFiles(File path, boolean removeTopDir) throws IOException {
        if (!path.exists()) {
            return;
        }
        if (!path.isDirectory()) {
            if (!path.delete()) {
                throw new IOException("failed to delete " + path);
            }
        } else {
            String[] files = path.list();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    FileUtil.removeFiles(new File(path, files[i]), true);
                }
            }
            if (removeTopDir && !path.delete()) {
                throw new IOException("failed to delete " + path);
            }
        }
    }

    public static String getCanonicalPath(String path) {
        File f = new File(path);
        try {
            return f.getCanonicalPath();
        }
        catch (Exception e) {
            return path;
        }
    }

    public static void copyDirectory(File srcDir, File dstDir) throws IOException {
        if (srcDir.isDirectory()) {
            if (!dstDir.exists()) {
                dstDir.mkdir();
            }
            String[] children = srcDir.list();
            for (int i = 0; i < children.length; ++i) {
                FileUtil.copyDirectory(new File(srcDir, children[i]), new File(dstDir, children[i]));
            }
        } else {
            FileUtil.copyFile(srcDir, dstDir);
        }
    }

    public static void copyFile(File src, File dst) throws IOException {
        FileChannel srcChannel = new FileInputStream(src).getChannel();
        FileChannel dstChannel = new FileOutputStream(dst).getChannel();
        dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
        srcChannel.close();
        dstChannel.close();
    }

    public static void main(String[] args) {
        try {
            System.out.println("obfuscating file");
            FileUtil.obfuscateFile("myfile", "myfile2");
            System.out.println("deobfuscating file");
            FileUtil.deobfuscateFile("myfile2", "myfile3");
            System.out.println("Reading normal file");
            InputStream is = FileUtil.retrieveObfuscatedFile("myfile");
            FileWriter fw = new FileWriter("myfile4");
            Properties prop1 = new Properties();
            prop1.load(is);
            fw.close();
            is.close();
            System.out.println(prop1);
            System.out.println("Reading modified file");
            is = FileUtil.retrieveObfuscatedFile("myfile2");
            Properties prop2 = new Properties();
            prop2.load(is);
            System.out.println(prop2);
            System.out.println("DONE");
            fw.close();
            is.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void obfuscateFile(String src, String dest) throws IOException {
        String line;
        FileInputStream fis = new FileInputStream(src);
        byte[] currentBuffer = new byte[fis.available()];
        int bread = fis.read(currentBuffer);
        byte[] hashbytes = MD5.getHash(currentBuffer);
        String hash = MD5.convertToString(hashbytes);
        fis.close();
        FileReader fr = new FileReader(src);
        BufferedReader br = new BufferedReader(fr);
        FileWriter fw = new FileWriter(dest);
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(magicNumberString + ":" + hash + ":" + formatversion + ":" + mqversion);
        bw.newLine();
        int linecnt = 0;
        while ((line = br.readLine()) != null) {
            char[] c = line.toCharArray();
            int pos = linecnt % fseq.length;
            String newstr = "";
            for (int i = 0; i < c.length; ++i) {
                if (pos >= fseq.length) {
                    pos = 0;
                }
                newstr = newstr + (char)(c[i] ^ fseq[pos]);
                ++pos;
            }
            bw.write(newstr);
            bw.newLine();
            ++linecnt;
        }
        bw.close();
        fw.close();
        br.close();
        fr.close();
    }

    public static void deobfuscateFile(String src, String dest) throws IOException {
        String line;
        FileReader fr = new FileReader(src);
        BufferedReader br = new BufferedReader(fr);
        String top = br.readLine();
        int linecnt = 0;
        if (!top.startsWith(magicNumberString)) {
            fr.close();
            br.close();
            throw new IOException("unobfuscated file");
        }
        int start = top.indexOf(58);
        int end = top.indexOf(58, start + 1);
        String hashcode = top.substring(start + 1, end);
        FileWriter fw = new FileWriter(dest);
        BufferedWriter bw = new BufferedWriter(fw);
        StringBuffer contents = new StringBuffer();
        linecnt = 0;
        while ((line = br.readLine()) != null) {
            char[] c = line.toCharArray();
            int pos = linecnt % fseq.length;
            for (int i = 0; i < c.length; ++i) {
                if (pos >= fseq.length) {
                    pos = 0;
                }
                char newc = (char)(c[i] ^ fseq[pos]);
                contents.append(newc);
                ++pos;
            }
            contents.append('\n');
            ++linecnt;
        }
        String str = contents.toString();
        String newhash = MD5.getHashString(str);
        if (!newhash.equals(hashcode)) {
            throw new IOException("deobfuscateFile:  File corrupted, hashcodes do not match");
        }
        bw.write(str);
        bw.close();
        fw.close();
        br.close();
        fr.close();
    }

    public static boolean isobfuscated(String src) throws IOException {
        FileReader fr = new FileReader(src);
        BufferedReader br = new BufferedReader(fr);
        String top = br.readLine();
        br.close();
        fr.close();
        return top.startsWith(magicNumberString);
    }

    public static InputStream retrieveObfuscatedFile(String src) throws IOException {
        String line;
        FileInputStream fis = new FileInputStream(src);
        int avail = fis.available();
        byte[] data = new byte[avail];
        fis.read(data);
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(bis);
        String magicline = dis.readLine();
        if (!magicline.startsWith(magicNumberString)) {
            bis.reset();
            fis.close();
            return bis;
        }
        int start = magicline.indexOf(58);
        int end = magicline.indexOf(58, start + 1);
        String hashcode = magicline.substring(start + 1, end);
        StringBuffer contents = new StringBuffer();
        int linecnt = 0;
        while ((line = dis.readLine()) != null) {
            char[] c = line.toCharArray();
            int pos = linecnt % fseq.length;
            for (int i = 0; i < c.length; ++i) {
                if (pos >= fseq.length) {
                    pos = 0;
                }
                char newc = (char)(c[i] ^ fseq[pos]);
                contents.append(newc);
                ++pos;
            }
            contents.append('\n');
            ++linecnt;
        }
        String str = contents.toString();
        String newhash = MD5.getHashString(str);
        if (!newhash.equals(hashcode)) {
            throw new IOException("retrieveObfuscatedFile:  File corrupted, hashcodes do not match");
        }
        byte[] bytes = str.getBytes("UTF8");
        ByteArrayInputStream pipeis = new ByteArrayInputStream(bytes);
        bis.close();
        dis.close();
        fis.close();
        return pipeis;
    }
}

