/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.util.lists;

import com.tongtech.tmqi.util.lists.SetEntry;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedSet;

public class FifoSet
extends AbstractSet
implements SortedSet {
    protected SetEntry head = null;
    protected SetEntry tail = null;
    protected Map lookup = null;
    protected FifoSet parent = null;
    protected SetEntry start = null;
    protected SetEntry end = null;
    protected Object lock = null;

    protected void setLock(Object lock) {
        this.lock = lock;
    }

    @Override
    public String toString() {
        return this.getClass().toString();
    }

    @Override
    public boolean isEmpty() {
        return this.lookup.isEmpty();
    }

    @Override
    public int size() {
        if (this.parent == null) {
            return this.lookup.size();
        }
        if (this.start == null && this.end == null) {
            return 0;
        }
        int cnt = 0;
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            itr.next();
            ++cnt;
        }
        return cnt;
    }

    @Override
    public boolean contains(Object o) {
        assert (this.lock == null || Thread.holdsLock(this.lock));
        SetEntry se = (SetEntry)this.lookup.get(o);
        boolean has = se != null && se.isValid();
        return has;
    }

    public FifoSet() {
        this.lookup = new HashMap();
        this.head = null;
        this.tail = null;
        this.start = null;
        this.end = null;
        this.parent = null;
        this.lookup = new HashMap();
    }

    private FifoSet(FifoSet parent, SetEntry start, SetEntry end) {
        this.parent = parent;
        this.lookup = parent.lookup;
        this.start = start;
        this.end = end;
    }

    protected boolean cleanupEntry(SetEntry e) {
        assert (this.lookup.size() != 0 || this.head == null && this.tail == null);
        assert (this.head != null && this.tail != null || this.head == null && this.tail == null) : "values: " + this.head + "," + this.tail;
        if (e == null) {
            return false;
        }
        boolean retval = e.isValid();
        this.lookup.remove(e.getData());
        e.remove();
        SetEntry oldhead = this.head;
        SetEntry oldtail = this.tail;
        if (this.head == e) {
            this.head = e.getNext();
        }
        if (this.tail == e) {
            this.tail = e.getPrevious();
        }
        assert (this.head != null && this.tail != null || this.head == null && this.tail == null) : "values: \n\thead: " + this.head + "\n\ttail: " + this.tail + "\n\toldhead: " + oldhead + "\n\toldtail: " + oldtail + "\n\tentry removed:" + e + "\n\n";
        return retval;
    }

    @Override
    public Iterator iterator() {
        assert (this.lock == null || Thread.holdsLock(this.lock)) : " lock is " + this.lock + ":" + Thread.holdsLock(this.lock);
        SetEntry beginEntry = this.parent != null ? (this.start == null ? this.parent.head : this.start) : this.head;
        return new SetIterator(beginEntry, this.end);
    }

    public Comparator comparator() {
        return null;
    }

    public SortedSet subSet(Object fromElement, Object toElement) {
        assert (this.lock == null || Thread.holdsLock(this.lock));
        if (this.parent != null) {
            boolean foundFrom = fromElement == null;
            boolean foundTo = toElement == null;
            for (Object o : this) {
                if (!foundFrom && (o == fromElement || o.equals(fromElement))) {
                    foundFrom = true;
                }
                if (!foundTo && (o == toElement || o.equals(toElement))) {
                    foundTo = true;
                }
                if (!foundTo || !foundFrom) continue;
                break;
            }
            if (!foundFrom || !foundTo) {
                throw new IllegalArgumentException("Elements are not in subset");
            }
        }
        SetEntry st = null;
        if (fromElement != null) {
            st = (SetEntry)this.lookup.get(fromElement);
        }
        SetEntry end = null;
        if (toElement != null) {
            end = (SetEntry)this.lookup.get(toElement);
        }
        return new FifoSet(this, st, end);
    }

    public SortedSet headSet(Object toElement) {
        return this.subSet((Object)null, toElement);
    }

    public SortedSet tailSet(Object fromElement) {
        return this.subSet(fromElement, (Object)null);
    }

    @Override
    public void clear() {
        assert (this.lock == null || Thread.holdsLock(this.lock));
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            itr.remove();
        }
        if (this.parent == null) {
            super.clear();
            this.lookup.clear();
        }
        this.head = null;
        this.tail = null;
        this.start = null;
        this.end = null;
    }

    public Object first() {
        Object o;
        assert (this.lock == null || Thread.holdsLock(this.lock));
        SetEntry beginEntry = this.parent != null ? (this.start == null ? this.parent.head : this.start) : this.head;
        Object object = o = beginEntry == null ? null : beginEntry.getData();
        if (beginEntry != null && this.lookup.get(o) == null || beginEntry == null && !this.lookup.isEmpty()) assert (false) : "List corrupted: \n\t beginEntry: " + (beginEntry == null ? "null" : beginEntry.toString()) + "\n\t parent : " + this.parent + "\n\t head " + this.head + "\n\t start " + this.start + "\n\t lookup " + this.lookup.toString();
        return o;
    }

    public Object last() {
        assert (this.lock == null || Thread.holdsLock(this.lock));
        if (this.parent != null) {
            if (this.end != null) {
                return this.end.getPrevious().getData();
            }
            return this.parent.last();
        }
        return this.tail == null ? null : this.tail.getData();
    }

    @Override
    public boolean add(Object o) {
        assert (this.lock == null || Thread.holdsLock(this.lock));
        if (this.parent != null) {
            if (this.end != null) {
                throw new IllegalArgumentException("Object added is past end of subset");
            }
            return this.parent.add(o);
        }
        if (this.lookup.get(o) != null) {
            this.remove(o);
        }
        SetEntry e = new SetEntry(o);
        this.lookup.put(o, e);
        if (this.tail != null) {
            this.tail.insertEntryAfter(e);
        }
        this.tail = e;
        if (this.head == null) {
            this.head = this.tail;
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        assert (this.lock == null || Thread.holdsLock(this.lock)) : this.lock + " : " + this;
        if (this.parent != null) {
            Iterator itr = this.iterator();
            while (itr.hasNext()) {
                if (itr.next() != o) continue;
                itr.remove();
                return true;
            }
            return false;
        }
        SetEntry e = (SetEntry)this.lookup.get(o);
        if (e == null) {
            return false;
        }
        return this.cleanupEntry(e);
    }

    public void sort(Comparator c) {
        if (this.head == null) {
            return;
        }
        this.head = this.head.sort(c);
        if (this.start != null) {
            this.start = this.head;
        }
        SetEntry e = this.head;
        while (e.next != null) {
            e = e.next;
        }
        this.tail = e;
        if (this.end != null) {
            this.end = this.tail;
        }
    }

    class SetIterator
    implements Iterator {
        SetEntry last_entry = null;
        SetEntry first_entry = null;
        boolean initialPass = true;
        SetEntry current = null;

        public SetIterator(SetEntry initialEntry, SetEntry finalEntry) {
            assert (FifoSet.this.lock == null || Thread.holdsLock(FifoSet.this.lock)) : " lock is " + this$0.lock + ":" + Thread.holdsLock(this$0.lock);
            this.first_entry = initialEntry;
            this.last_entry = finalEntry;
            this.current = null;
            this.initialPass = true;
        }

        @Override
        public boolean hasNext() {
            assert (FifoSet.this.lock == null || Thread.holdsLock(FifoSet.this.lock));
            if (this.current == null && !this.initialPass) {
                return false;
            }
            SetEntry nextEntry = null;
            for (nextEntry = this.initialPass ? this.first_entry : this.current.getNext(); nextEntry != null && !nextEntry.isValid() && nextEntry != this.last_entry; nextEntry = nextEntry.getNext()) {
            }
            return nextEntry != null && nextEntry != this.last_entry && nextEntry.isValid();
        }

        public Object next() {
            assert (FifoSet.this.lock == null || Thread.holdsLock(FifoSet.this.lock));
            if (this.current == null && this.initialPass) {
                this.current = this.first_entry;
                this.initialPass = false;
            } else {
                this.current = this.current.getNext();
            }
            if (this.current == null) {
                throw new NoSuchElementException("set empty");
            }
            while (this.current != null && !this.current.isValid() && this.current != this.last_entry) {
                this.current = this.current.getNext();
            }
            if (this.current == null || !this.current.isValid() || this.current == this.last_entry) {
                throw new NoSuchElementException("set empty");
            }
            return this.current.getData();
        }

        @Override
        public void remove() {
            if (this.current != null) {
                FifoSet.this.cleanupEntry(this.current);
            }
        }
    }
}

