/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.util.lists;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

class SetEntry {
    public static boolean DEBUG = false;
    SetEntry next = null;
    SetEntry previous = null;
    boolean valid = true;
    Object data = null;
    static int ctr = 0;
    int debugid = DEBUG ? ctr++ : this.hashCode();

    public SetEntry sort(Comparator comp) {
        if (this.next == null) {
            return this;
        }
        Comparator realcmp = this.createSortComparator(comp);
        ArrayList<SetEntry> al = new ArrayList<SetEntry>();
        SetEntry entry = this;
        al.add(this);
        while (entry.next != null) {
            al.add(entry.next);
            entry = entry.next;
        }
        Collections.sort(al, comp);
        SetEntry back = null;
        for (int i = 0; i < al.size(); ++i) {
            SetEntry fwd = i < al.size() - 1 ? (SetEntry)al.get(i + 1) : null;
            SetEntry cur = (SetEntry)al.get(i);
            cur.previous = back;
            cur.next = fwd;
            back = cur;
        }
        return (SetEntry)al.get(0);
    }

    protected Comparator createSortComparator(Comparator comp) {
        return new SetEntryComparator(comp);
    }

    public SetEntry(Object data) {
        this.data = data;
    }

    public String toString() {
        return "SetEntry(" + this.debugid + ")[ before(" + (this.previous == null ? null : String.valueOf(this.previous.debugid)) + ") after(" + (this.next == null ? null : String.valueOf(this.next.debugid)) + ") ] " + this.data + "]";
    }

    public SetEntry getNext() {
        return this.next;
    }

    public SetEntry getPrevious() {
        return this.previous;
    }

    public Object getData() {
        return this.data;
    }

    public boolean isFirst() {
        return this.previous == null;
    }

    public boolean isLast() {
        return this.next == null;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void clear() {
        this.previous = null;
        this.next = null;
        this.data = null;
    }

    public boolean remove() {
        this.valid = false;
        this.data = null;
        if (this.previous != null) {
            this.previous.next = this.next;
        }
        if (this.next != null) {
            this.next.previous = this.previous;
        }
        if (this.next == null || this.previous == null) {
            return true;
        }
        assert (this.previous.next == this.next && this.next.previous == this.previous);
        return false;
    }

    public boolean insertEntryAfter(SetEntry newEntry) {
        newEntry.previous = this;
        newEntry.next = this.next;
        this.next = newEntry;
        if (newEntry.next != null) {
            newEntry.next.previous = newEntry;
        }
        assert (newEntry.previous == this && this.next == newEntry);
        return newEntry.next == null;
    }

    public boolean insertEntryBefore(SetEntry newEntry) {
        if (this.previous != null) {
            this.previous.next = newEntry;
        }
        newEntry.next = this;
        newEntry.previous = this.previous;
        this.previous = newEntry;
        assert (newEntry.next == this && this.previous == newEntry);
        return newEntry.previous == null;
    }

    static class SetEntryComparator
    implements Comparator {
        Comparator datacmp = null;

        public SetEntryComparator(Comparator c) {
            this.datacmp = c;
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof SetEntry && o2 instanceof SetEntry) {
                Object d1 = ((SetEntry)o1).data;
                Object d2 = ((SetEntry)o2).data;
                return this.datacmp.compare(d1, d2);
            }
            if (o1 instanceof SetEntry) {
                Object d1 = ((SetEntry)o1).data;
                return this.datacmp.compare(d1, o2);
            }
            if (o2 instanceof SetEntry) {
                Object d2 = ((SetEntry)o2).data;
                return this.datacmp.compare(o1, d2);
            }
            if (o2 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return o1.hashCode() - o2.hashCode();
        }

        @Override
        public boolean equals(Object o1) {
            return super.equals(o1);
        }
    }
}

