/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.util.selector;

public class RegularExpression {
    String expression = null;
    Character escape = null;

    public RegularExpression(String expression, String escape) {
        this.expression = expression;
        if (escape != null) {
            this.escape = new Character(escape.charAt(0));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegularExpression)) {
            return false;
        }
        RegularExpression obj = (RegularExpression)o;
        return this.expression.equals(obj.expression) && this.escape.equals(obj.escape);
    }

    public String toString() {
        return "{re=" + this.expression + ", esc=" + this.escape + "}";
    }

    public String getExpression() {
        return this.expression;
    }

    public Character getEscape() {
        return this.escape;
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public boolean match(String string) {
        return this.match(this.expression, 0, string, 0);
    }

    private boolean match(String re, int reStart, String value, int valStart) {
        int reLen = re.length();
        int vLen = value.length();
        int i = reStart;
        int j = valStart;
        char esc = '\u0000';
        if (this.escape != null) {
            esc = this.escape.charValue();
        }
        boolean escaped = false;
        do {
            char c = re.charAt(i);
            if (this.escape != null && c == esc) {
                escaped = true;
                ++i;
                continue;
            }
            switch (c) {
                case '_': {
                    if (escaped) {
                        escaped = false;
                        if (c == value.charAt(j)) {
                            ++i;
                            ++j;
                            break;
                        }
                        return false;
                    }
                    ++i;
                    ++j;
                    break;
                }
                case '%': {
                    if (escaped) {
                        escaped = false;
                        if (c == value.charAt(j)) {
                            ++i;
                            ++j;
                            break;
                        }
                        return false;
                    }
                    if (++i == reLen) {
                        return true;
                    }
                    do {
                        if (!this.match(re, i, value, j)) continue;
                        return true;
                    } while (++j < vLen);
                    return false;
                }
                default: {
                    if (c == value.charAt(j)) {
                        ++i;
                        ++j;
                        escaped = false;
                        break;
                    }
                    return false;
                }
            }
        } while (j < vLen && i < reLen);
        while (i < reLen && re.charAt(i) == '%') {
            ++i;
        }
        return j == vLen && i == reLen;
    }

    public static void main(String[] args) {
        String[][] tests = new String[][]{{"abcd", "abcd", null, "true"}, {"a_cd", "abcd", null, "true"}, {"_bcd", "abcd", null, "true"}, {"_bc_", "abcd", null, "true"}, {"____", "abcd", null, "true"}, {"_X__", "abcd", null, "false"}, {"a%d", "abcd", null, "true"}, {"a%d", "ad", null, "true"}, {"%cd", "abcd", null, "true"}, {"%cd", "cd", null, "true"}, {"ab%", "abcd", null, "true"}, {"ab%", "ab", null, "true"}, {"ab%%", "ab", null, "true"}, {"%%ab", "ab", null, "true"}, {"a%c%", "abcd", null, "true"}, {"a%%d", "abcd", null, "true"}, {"%%%%", "abcd", null, "true"}, {"a%cd", "acdcdbcd", null, "true"}, {"X%cd", "acdcdbcd", null, "false"}, {"a%_cd", "abcd", null, "true"}, {"a%_cd", "abbbbcd", null, "true"}, {"a%_%d", "abbbbcd", null, "true"}, {"a%_%d", "ad", null, "false"}, {"a~_c", "abc", "~", "false"}, {"a~_c", "a_c", "~", "true"}, {"a~%c", "abc", "~", "false"}, {"a~%c", "a%c", "~", "true"}, {"a%c", "abc", "~", "true"}, {"~a%c", "abc", "~", "true"}};
        int failCnt = 0;
        for (int n = 0; n < tests.length; ++n) {
            String result;
            RegularExpression re = new RegularExpression(tests[n][0], tests[n][2]);
            boolean expected = Boolean.valueOf(tests[n][3]);
            boolean actual = re.match(tests[n][1]);
            if (actual == expected) {
                result = "      PASS";
            } else {
                result = "***** FAIL";
                ++failCnt;
            }
            System.out.println(result + " " + tests[n][0] + "=" + tests[n][1] + (tests[n][2] != null ? " (esc=" + tests[n][2] + ")" : "") + " : expected=" + expected + " actual=" + actual + " ");
        }
        System.out.println(tests.length + " tests: " + (tests.length - failCnt) + " passed " + failCnt + " failed ");
        if (failCnt > 0) {
            System.exit(1);
        } else {
            System.exit(0);
        }
    }
}

