/*
 * Decompiled with CFR 0.152.
 */
package tongtech.jms.jndi;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import tongtech.jms.jndi.EnvAccessException;

public class Env
extends Properties {
    public static final String OSNAME = System.getProperty("os.name");
    public static final String USERNAME = System.getProperty("user.name");
    private static String s_shell = null;
    private static Env s_lastEnv = null;
    private static Map envs_cache = new HashMap();

    public Env() throws EnvAccessException {
        Properties l_props = Env.getEnvVariables();
        Enumeration<?> l_list = l_props.propertyNames();
        while (l_list.hasMoreElements()) {
            String l_key = (String)l_list.nextElement();
            this.setProperty(l_key, l_props.getProperty(l_key));
        }
        s_lastEnv = this;
    }

    Env getLastEnv() throws EnvAccessException {
        if (s_lastEnv == null) {
            s_lastEnv = new Env();
        }
        return (Env)s_lastEnv.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getEnvVariable(String a_name) {
        String env_value = null;
        String l_osName = System.getProperty("os.name");
        String not_env_String = "null_tlqnoenv";
        Map map = envs_cache;
        synchronized (map) {
            env_value = (String)envs_cache.get(a_name);
            if (env_value != null && env_value.length() > 0) {
                return env_value;
            }
            if (env_value != null && env_value.endsWith(not_env_String)) {
                return null;
            }
            try {
                if (Env.isUnix()) {
                    Properties l_props = Env.getUnixShellVariables();
                    env_value = l_props.getProperty(a_name);
                } else if (-1 != l_osName.indexOf("Windows")) {
                    if (null == s_shell) {
                        s_shell = -1 != l_osName.indexOf("98") || -1 != l_osName.indexOf("95") ? "command.exe" : "cmd.exe";
                    }
                    env_value = Env.getWindowsShellVariable(a_name);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (env_value != null) {
                envs_cache.put("a_name", env_value);
                return env_value;
            }
            envs_cache.put("a_name", not_env_String);
            return null;
        }
    }

    public static boolean isUnix() {
        return -1 != OSNAME.indexOf("Linux") || -1 != OSNAME.indexOf("SunOS") || -1 != OSNAME.indexOf("Solaris") || -1 != OSNAME.indexOf("MPE/iX") || -1 != OSNAME.indexOf("AIX") || -1 != OSNAME.indexOf("FreeBSD") || -1 != OSNAME.indexOf("Irix") || -1 != OSNAME.indexOf("Digital Unix") || -1 != OSNAME.indexOf("HP-UX") || -1 != OSNAME.indexOf("Mac OS X");
    }

    public static boolean isWindows() {
        return -1 != OSNAME.indexOf("Windows");
    }

    public static boolean isNetWare() {
        return -1 != OSNAME.indexOf("netware");
    }

    public static boolean isOpenVMS() {
        return -1 != OSNAME.indexOf("openvms");
    }

    public static Properties getEnvVariables() throws EnvAccessException {
        if (Env.isUnix()) {
            return Env.getUnixShellVariables();
        }
        if (Env.isWindows()) {
            return Env.getWindowsShellVariables();
        }
        throw new EnvAccessException(new UnsupportedOperationException("Environment operations not supported on unrecognized operatings system"));
    }

    public static String getUserShell() throws EnvAccessException {
        if (-1 != OSNAME.indexOf("Mac OS X")) {
            return Env.getMacUserShell();
        }
        if (Env.isWindows()) {
            return Env.getWindowsUserShell();
        }
        throw new EnvAccessException(new UnsupportedOperationException("Environment operations not supported on unrecognized operatings system"));
    }

    private static String getMacUserShell() throws EnvAccessException {
        Process l_proc = null;
        BufferedReader l_in = null;
        if (null != s_shell) {
            return s_shell;
        }
        try {
            String l_entry = null;
            String[] l_args = new String[]{"nidump", "passwd", "/"};
            l_proc = Runtime.getRuntime().exec(l_args);
            l_in = new BufferedReader(new InputStreamReader(l_proc.getInputStream()));
            while (null != (l_entry = l_in.readLine())) {
                if (!l_entry.startsWith(USERNAME)) continue;
                int l_index = l_entry.lastIndexOf(58);
                if (l_index == -1) {
                    throw new EnvAccessException("passwd database contains malformed user entry for " + USERNAME);
                }
                String string = s_shell = l_entry.substring(l_index + 1);
                return string;
            }
            l_proc.waitFor();
            l_in.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new EnvAccessException(t);
        }
        finally {
            if (l_proc != null) {
                l_proc.destroy();
            }
            try {
                if (null != l_in) {
                    l_in.close();
                }
            }
            catch (IOException iOException) {}
        }
        throw new EnvAccessException("User " + USERNAME + " does not seem to exist in the passwd database");
    }

    private static Properties getUnixShellVariables() throws EnvAccessException {
        Process l_proc = null;
        Properties l_props = new Properties();
        BufferedReader l_in = null;
        try {
            String[] l_args = new String[]{Env.getUnixEnv()};
            l_proc = Runtime.getRuntime().exec(l_args);
            l_in = new BufferedReader(new InputStreamReader(l_proc.getInputStream()));
            String l_line = null;
            while (null != (l_line = l_in.readLine())) {
                int l_idx = l_line.indexOf(61);
                if (-1 == l_idx) {
                    if (l_line.length() == 0) continue;
                    System.err.println("Skipping line - could not find '=' in line: '" + l_line + "'");
                    continue;
                }
                String l_name = l_line.substring(0, l_idx);
                String l_value = l_line.substring(l_idx + 1, l_line.length());
                l_props.setProperty(l_name, l_value);
            }
            l_proc.waitFor();
            l_in.close();
        }
        catch (Throwable t) {
            throw new EnvAccessException("NA", t);
        }
        finally {
            if (l_proc != null) {
                l_proc.destroy();
            }
            try {
                if (null != l_in) {
                    l_in.close();
                }
            }
            catch (IOException l_args) {}
        }
        if (0 != l_proc.exitValue()) {
            throw new EnvAccessException("Environment process failed  with non-zero exit code of " + l_proc.exitValue());
        }
        return l_props;
    }

    private static String getUnixEnv() throws EnvAccessException {
        File l_env = new File("/bin/env");
        if (l_env.exists() && l_env.canRead() && l_env.isFile()) {
            return l_env.getAbsolutePath();
        }
        l_env = new File("/usr/bin/env");
        if (l_env.exists() && l_env.canRead() && l_env.isFile()) {
            return l_env.getAbsolutePath();
        }
        throw new EnvAccessException("Could not find the UNIX env executable");
    }

    private static String getWindowsUserShell() {
        if (null != s_shell) {
            return s_shell;
        }
        if (-1 != OSNAME.indexOf("98") || -1 != OSNAME.indexOf("95")) {
            s_shell = "command.exe";
            return s_shell;
        }
        s_shell = "cmd.exe";
        return s_shell;
    }

    private static Properties getWindowsShellVariables() throws EnvAccessException {
        String l_line = null;
        Process l_proc = null;
        BufferedReader l_in = null;
        Properties l_props = new Properties();
        StringBuffer l_cmd = new StringBuffer();
        if (-1 != OSNAME.indexOf("98") || -1 != OSNAME.indexOf("95")) {
            l_cmd.append("command.exe /C SET");
        } else {
            l_cmd.append("cmd.exe /C SET");
        }
        try {
            l_proc = Runtime.getRuntime().exec(l_cmd.toString());
            l_in = new BufferedReader(new InputStreamReader(l_proc.getInputStream()));
            while (null != (l_line = l_in.readLine())) {
                int l_idx = l_line.indexOf(61);
                if (-1 == l_idx) {
                    System.err.println("Skipping line - could not find '=' in line: '" + l_line + "'");
                    continue;
                }
                String l_name = l_line.substring(0, l_idx);
                String l_value = l_line.substring(l_idx + 1, l_line.length());
                l_props.setProperty(l_name, l_value);
            }
            l_proc.waitFor();
            l_in.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new EnvAccessException(t);
        }
        finally {
            l_proc.destroy();
            try {
                if (null != l_in) {
                    l_in.close();
                }
            }
            catch (IOException l_idx) {}
        }
        if (0 != l_proc.exitValue()) {
            throw new EnvAccessException("Environment process failed with non-zero exit code of " + l_proc.exitValue());
        }
        return l_props;
    }

    private static String getWindowsShellVariable(String a_name) throws EnvAccessException {
        String l_value = null;
        Process l_proc = null;
        BufferedReader l_in = null;
        StringBuffer l_cmd = new StringBuffer(Env.getWindowsUserShell());
        l_cmd.append(" /C echo %");
        l_cmd.append(a_name);
        l_cmd.append('%');
        try {
            l_proc = Runtime.getRuntime().exec(l_cmd.toString());
            l_in = new BufferedReader(new InputStreamReader(l_proc.getInputStream()));
            l_value = l_in.readLine();
            l_proc.waitFor();
            l_in.close();
        }
        catch (Throwable t) {
            throw new EnvAccessException(a_name, t);
        }
        finally {
            l_proc.destroy();
            try {
                if (null != l_in) {
                    l_in.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (0 == l_proc.exitValue()) {
            if (l_value.startsWith("%") && l_value.endsWith("%")) {
                return null;
            }
            return l_value;
        }
        throw new EnvAccessException(a_name, "Environment process failed with non-zero exit code of " + l_proc.exitValue());
    }
}

