/*
 * Decompiled with CFR 0.152.
 */
package tongtech.jms.jndi;

import com.tongtech.backport.java.util.Arrays;
import com.tongtech.backport.java.util.concurrent.ConcurrentHashMap;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.Queue;
import com.tongtech.tmqi.QueueConnectionFactory;
import com.tongtech.tmqi.Topic;
import com.tongtech.tmqi.TopicConnectionFactory;
import com.tongtech.tmqi.XAConnectionFactory;
import com.tongtech.tmqi.XAQueueConnectionFactory;
import com.tongtech.tmqi.XATopicConnectionFactory;
import com.tongtech.tmqi.clusterclient.ClusterQueue;
import com.tongtech.tmqi.jmscluster_v2.ClusConnectionFactory;
import com.tongtech.tmqi.naming.ReadOnlyContext;
import com.tongtech.tmqi.pool.PooledConnectionFactory;
import com.tongtech.tmqi.pool.PooledQueueConnectionFactory;
import com.tongtech.tmqi.pool.PooledTopicConnectionFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import tongtech.jms.jndi.Env;
import tongtech.jms.jndi.INIParser;
import tongtech.jms.jndi.MutilUrlSocketNamingContext;
import tongtech.jms.jndi.SocketNamingContext;

public class JmsContextFactory
implements InitialContextFactory {
    static Logger logger = LoggerFactory.getLogger(JmsContextFactory.class);
    protected static final String TLQCONFDIR = "TLQCONFDIR";
    protected static final String JNDI_FILE_NAME = "tlqjndi.conf";
    protected static final String FACTORY_RECORD = "FactoryRecord";
    protected static final String FACTORY_NAME = "FactoryName";
    protected static final String FACTORY_TYPE = "FactoryType";
    protected static final String QUEUE_RECORD = "JndiQueueRecord";
    protected static final String TLQ_QUEUE_NAME = "TlqQueueName";
    protected static final String QUEUE_JNDI_NAME = "JndiQueueName";
    protected static final String TOPIC_RECORD = "JndiTopicRecord";
    protected static final String TLQ_TOPIC_NAME = "TlqTopicName";
    protected static final String TOPIC_JNDI_NAME = "JndiTopicName";
    protected static final String TOPIC_PUB_QUEUE = "TopicPubQueue";
    protected static final String TOPIC_SUB_QUEUE = "TopicSubQueue";
    protected static final String qcfPrefix = "qf";
    protected static final String cfPrefix = "cf";
    protected static final String tcfPrefix = "tf";
    protected static final String xaqcfPrefix = "xqf";
    protected static final String xacfPrefix = "xcf";
    protected static final String xatcfPrefix = "xtf";
    protected static final String POOLED_FACTORY = "usePooledConnection";
    private static final String POOL_MAX_CONNECTIONS = "maxConnections";
    private static final String POOL_MAX_SESSIONS = "maxSessions";
    private static final String POOL_IDLE_TIME = "idleTimeout";
    private static final String POOL_SESSION_BLOCK = "blockIfSessionIsFull";
    private static final String POOL_EXPIRY_TIME = "expiryTimeout";
    private static final String CLUSTER_URL_SEPARATE = ",";
    private static final String CLUSTER_STRATEGY = "strategy";
    private static final String CLUSTER_MAXCONNSPERCLUSTERMEMBER = "maxConnsPerClusterMember";
    private Map data = new ConcurrentHashMap();

    public Context getInitialContext(Hashtable env) throws NamingException {
        String providerUrl = (String)env.get("java.naming.provider.url");
        if (providerUrl == null || providerUrl.equals("") || providerUrl.startsWith("tlqlocal://")) {
            return this.HandleLocalFileJndi(env);
        }
        if (providerUrl.startsWith("tlq://") || providerUrl.startsWith("tlkq://") || providerUrl.startsWith("http://")) {
            return this.HandleRemoteJndi(env, providerUrl);
        }
        throw new NamingException("Illegal address. Unknown address scheme : " + providerUrl);
    }

    private Context HandleLocalFileJndi(Hashtable env) {
        String confDir = null;
        confDir = Env.getEnvVariable(TLQCONFDIR);
        if (confDir == null || confDir.equals("")) {
            logger.debug("Can't load 'TLQCONFDIR' from env ,Will try to load from System Property ");
            confDir = System.getProperty(TLQCONFDIR);
        }
        if (confDir == null || confDir.equals("")) {
            throw new RuntimeException("Can't load TLQCONFDIR ,Please set the 'TLQCONFDIR' environment !");
        }
        try {
            List topicList;
            List queueList;
            INIParser parser = new INIParser(confDir + File.separator + JNDI_FILE_NAME);
            List factoryList = parser.getSectionAsPropertiesList(FACTORY_RECORD);
            if (factoryList != null) {
                this.createConnectionFactories(factoryList, env);
            }
            if ((queueList = parser.getSectionAsPropertiesList(QUEUE_RECORD)) != null) {
                this.createQueues(queueList, env);
            }
            if ((topicList = parser.getSectionAsPropertiesList(TOPIC_RECORD)) != null) {
                this.createTopics(topicList, env);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Can't find tlqjndi.conf file in TLQCONFDIR dir [" + confDir + "]!");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new ReadOnlyContext(env, this.data);
    }

    private Context HandleRemoteJndi(Hashtable env, String url) throws NamingException {
        boolean canUsed = false;
        try {
            String[] urls = null;
            if (url.indexOf(44) > 0) {
                urls = url.split(CLUSTER_URL_SEPARATE);
            }
            if (urls != null && urls.length > 0) {
                SocketNamingContext[] contexts = new SocketNamingContext[urls.length];
                Exception[] me = new Exception[urls.length];
                for (int i = 0; i < urls.length; ++i) {
                    try {
                        contexts[i] = new SocketNamingContext(env, urls[i]);
                        canUsed = true;
                        continue;
                    }
                    catch (Exception e) {
                        me[i] = e;
                        contexts[i] = null;
                    }
                }
                if (!canUsed) {
                    throw new Exception("all jndi server cant used!", me[0]);
                }
                MutilUrlSocketNamingContext context = new MutilUrlSocketNamingContext(env, contexts);
                return context;
            }
            return new SocketNamingContext(env, url);
        }
        catch (Exception e) {
            NamingException ex = new NamingException();
            ex.setRootCause(e);
            logger.debug("Jndi exception :", e);
            throw ex;
        }
    }

    private void createTopics(List topicList, Hashtable env) throws JMSException {
        for (int i = 0; i < topicList.size(); ++i) {
            Properties props = (Properties)topicList.get(i);
            String jndiName = props.getProperty(TOPIC_JNDI_NAME);
            this.data.put(jndiName, JmsContextFactory.createTopicByProperties(props));
        }
    }

    protected static Topic createTopicByProperties(Properties props) throws JMSException {
        String topicName = props.getProperty(TLQ_TOPIC_NAME);
        String pubQueue = props.getProperty(TOPIC_PUB_QUEUE, "TLQ.SYS.BROKER.SYN");
        String subQueue = props.getProperty(TOPIC_SUB_QUEUE, "TLQ.SYS.BROKER.SUB");
        Topic topic = new Topic(topicName);
        if (pubQueue != null && !pubQueue.equals("")) {
            topic.setProperty("tmqiTopicPubQueueName", pubQueue);
        }
        if (subQueue != null && !subQueue.equals("")) {
            topic.setProperty("tmqiTopicSubQueueName", subQueue);
        }
        return topic;
    }

    private void createQueues(List queueList, Hashtable env) throws JMSException {
        for (int i = 0; i < queueList.size(); ++i) {
            Properties props = (Properties)queueList.get(i);
            String jndiName = props.getProperty(QUEUE_JNDI_NAME);
            this.data.put(jndiName, JmsContextFactory.createQueueByProperties(props));
        }
    }

    protected static Queue createQueueByProperties(Properties props) throws JMSException {
        String queueName = props.getProperty(TLQ_QUEUE_NAME);
        return new Queue(queueName);
    }

    private void createConnectionFactories(List factoryList, Hashtable env) {
        for (int i = 0; i < factoryList.size(); ++i) {
            Properties props = (Properties)factoryList.get(i);
            String jndiName = props.getProperty(FACTORY_NAME);
            this.data.put(jndiName, JmsContextFactory.createConnectionFactoryByProperties(props));
        }
    }

    protected static ConnectionFactory createConnectionFactoryByProperties(Properties props) {
        String facType = props.getProperty(FACTORY_TYPE);
        String jndiName = props.getProperty(FACTORY_NAME);
        com.tongtech.tmqi.ConnectionFactory fac = null;
        ClusConnectionFactory clusterfac = null;
        Object[] urls = null;
        boolean cluster_v2_flag = false;
        if (props != null) {
            String jmsserverURLs = props.getProperty("tmqiAddressList");
            urls = jmsserverURLs.split(CLUSTER_URL_SEPARATE);
        }
        if (cfPrefix.equals(facType)) {
            fac = new com.tongtech.tmqi.ConnectionFactory();
        } else if (qcfPrefix.equals(facType)) {
            fac = new QueueConnectionFactory();
        } else if (tcfPrefix.equals(facType)) {
            fac = new TopicConnectionFactory();
        } else if (xacfPrefix.equals(facType)) {
            fac = new XAConnectionFactory();
        } else if (xaqcfPrefix.equals(facType)) {
            fac = new XAQueueConnectionFactory();
        } else if (xatcfPrefix.equals(facType)) {
            fac = new XATopicConnectionFactory();
        } else {
            throw new RuntimeException("FactoryType set error in [FactoryRecord],FactoryName :'" + jndiName + "'");
        }
        if (urls != null && urls.length > 1) {
            String factoryName;
            clusterfac = new ClusConnectionFactory(fac);
            cluster_v2_flag = true;
            String jndiurl = props.getProperty("java.naming.provider.url");
            if (jndiurl != null && jndiurl.length() > 0) {
                clusterfac.setJndiURLS(jndiurl);
            }
            if ((factoryName = props.getProperty(FACTORY_NAME)) != null && factoryName.length() > 0) {
                clusterfac.setFactoryName(factoryName);
            }
        }
        if (props != null && props.getProperty("tmqiFileRcvDir") != null && props.getProperty("tmqiFileRcvDir").trim().equals("")) {
            props.remove("tmqiFileRcvDir");
        }
        fac.getConfiguration().putAll((Map<?, ?>)props);
        String usePool = props.getProperty(POOLED_FACTORY);
        if (usePool != null && !usePool.equals("") && usePool.equals("true")) {
            PooledConnectionFactory pool = null;
            pool = fac instanceof TopicConnectionFactory ? new PooledTopicConnectionFactory(fac) : (fac instanceof QueueConnectionFactory ? new PooledQueueConnectionFactory(fac) : new PooledConnectionFactory(fac));
            String connctions = props.getProperty(POOL_MAX_CONNECTIONS);
            String sessions = props.getProperty(POOL_MAX_SESSIONS);
            String idleTime = props.getProperty(POOL_IDLE_TIME);
            String expiryTime = props.getProperty(POOL_EXPIRY_TIME);
            String blockSession = props.getProperty(POOL_SESSION_BLOCK);
            pool.setMaxConnections(Integer.parseInt(connctions));
            pool.setMaxSessions(Integer.parseInt(sessions));
            pool.setIdleTimeout(Integer.parseInt(idleTime) * 1000);
            pool.setExpiryTimeout((long)Integer.parseInt(expiryTime) * 1000L);
            pool.setBlockIfSessionPoolIsFull(new Boolean(blockSession));
            return pool;
        }
        if (cluster_v2_flag) {
            String maxConnsPerClusterMemberstr;
            String strategy = props.getProperty(CLUSTER_STRATEGY);
            if (strategy != null) {
                clusterfac.setStrategy(Integer.parseInt(strategy));
            }
            if ((maxConnsPerClusterMemberstr = props.getProperty(CLUSTER_MAXCONNSPERCLUSTERMEMBER)) != null) {
                clusterfac.setMaxConnsPerClusterMember(Integer.parseInt(maxConnsPerClusterMemberstr));
            }
            clusterfac.setUrls(Arrays.asList(urls));
            return clusterfac;
        }
        return fac;
    }

    protected static ClusterQueue createClusterQueueByProperties(Properties[] props) throws JMSException {
        ClusterQueue queue = new ClusterQueue();
        ConnectionFactory[] cfs = new com.tongtech.tmqi.ConnectionFactory[props.length];
        for (int i = 0; i < props.length; ++i) {
            ConnectionFactory cf = JmsContextFactory.createConnectionFactoryByProperties(props[i]);
            cfs[i] = cf;
            queue.addFactory(props[i].getProperty(FACTORY_NAME), cf);
        }
        String name = props[0].getProperty("ClusterQueueName");
        Properties qProperties = new Properties();
        qProperties.put(TLQ_QUEUE_NAME, name);
        queue.setBrokerConnectionFactories(cfs);
        queue.setQueue(JmsContextFactory.createQueueByProperties(qProperties));
        return queue;
    }
}

