/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.starter.config;

import com.tongweb.container.startup.ServletContainer;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.starter.bean.TongWebProperties;
import com.tongweb.starter.config.ConfigHandler;
import com.tongweb.starter.config.ConnectorConfigHandler;
import com.tongweb.starter.config.ContextConfigHandler;
import com.tongweb.starter.config.EngineConfigHandler;
import com.tongweb.starter.config.HostConfigHandler;
import com.tongweb.starter.config.LicenseConfigHandler;
import com.tongweb.starter.config.MonitorConfigHandler;
import com.tongweb.starter.config.ProtocolConfigHandler;
import com.tongweb.starter.config.ServerContainerHandler;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ConfigHandlerHolder {
    private static final Log log = LogFactory.getLog(ConfigHandlerHolder.class);
    private static Set<ConfigHandler> handlers = new LinkedHashSet<ConfigHandler>();

    private static synchronized void initConfigHandlers(ServletContainer tongweb) {
        handlers.add(new MonitorConfigHandler(tongweb));
        handlers.add(new ServerContainerHandler(tongweb));
        handlers.add(new ConnectorConfigHandler(tongweb));
        handlers.add(new LicenseConfigHandler(tongweb));
        handlers.add(new HostConfigHandler(tongweb));
        handlers.add(new ContextConfigHandler(tongweb));
        handlers.add(new EngineConfigHandler(tongweb));
        handlers.add(new ProtocolConfigHandler(tongweb));
    }

    public static void configComponents(TongWebProperties tongWebProperties, ServletContainer tongweb) throws Exception {
        ConfigHandlerHolder.initConfigHandlers(tongweb);
        for (ConfigHandler cla : handlers) {
            cla.config(tongWebProperties);
        }
    }

    public static void configInternal(TongWebProperties tongWebProperties, ServletContainer tongweb) throws Exception {
        ArrayList<ConfigHandler> handlers = new ArrayList<ConfigHandler>();
        List<Class> clazzs = ConfigHandlerHolder.getAllInterfaceAchieveClass(ConfigHandler.class);
        for (Class clazz : clazzs) {
            Constructor constructor = clazz.getDeclaredConstructor(ServletContainer.class);
            handlers.add((ConfigHandler)constructor.newInstance(tongweb));
        }
        for (ConfigHandler cla : handlers) {
            System.out.println("\u5b9e\u73b0\u7c7b:" + cla.getClass() + "start config tongweb");
            cla.config(tongWebProperties);
        }
    }

    public static List<Class> getAllInterfaceAchieveClass(Class clazz) {
        ArrayList<Class> list = new ArrayList<Class>();
        if (clazz.isInterface()) {
            try {
                ArrayList<Class> allClass = ConfigHandlerHolder.getAllClassByPath(clazz.getPackage().getName());
                for (int i = 0; i < allClass.size(); ++i) {
                    if (Modifier.isAbstract(allClass.get(i).getModifiers()) || !clazz.isAssignableFrom(allClass.get(i)) || clazz.equals(allClass.get(i))) continue;
                    list.add(allClass.get(i));
                }
            }
            catch (Exception e) {
                System.out.println("\u51fa\u73b0\u5f02\u5e38");
            }
        }
        return list;
    }

    public static ArrayList<Class> getAllClassByPath(String packagename) {
        ArrayList<Class> list = new ArrayList<Class>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packagename.replace('.', '/');
        try {
            ArrayList<File> fileList = new ArrayList<File>();
            Enumeration<URL> enumeration = classLoader.getResources(path);
            while (enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                fileList.add(new File(url.getFile()));
            }
            for (int i = 0; i < fileList.size(); ++i) {
                list.addAll(ConfigHandlerHolder.findClass((File)fileList.get(i), packagename));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    private static ArrayList<Class> findClass(File file, String packagename) {
        File[] files;
        ArrayList<Class> list = new ArrayList<Class>();
        if (!file.exists()) {
            return list;
        }
        for (File file2 : files = file.listFiles()) {
            if (file2.isDirectory()) {
                assert (!file2.getName().contains("."));
                ArrayList<Class> arrayList = ConfigHandlerHolder.findClass(file2, packagename + "." + file2.getName());
                list.addAll(arrayList);
                continue;
            }
            if (!file2.getName().endsWith(".class")) continue;
            try {
                list.add(Class.forName(packagename + '.' + file2.getName().substring(0, file2.getName().length() - 6)));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return list;
    }
}

